/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t vfsmount();
const commandtable_t command_vfsmount =
	{"vfsmount", vfsmount, "[address]", "print vfsmount table"};

addr_t mount_hashtable_addr, hash_mask_addr;

extern addr_t print_vfsmount();

PRIVATE addr_t
vfsmount()
{
	int i, c;
	addr_t addr;
	extern void prhead_vfsmount();

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	prhead_vfsmount();

	if (optind == argcnt) {
		addr_t mount_hashtable;
		struct list_head lh;
		int hash_mask;

		GETADDR(mount_hashtable);
		memread(mount_hashtable_addr, sizeof(addr_t), &mount_hashtable, "mount_hashtable");
		GETADDR(hash_mask);
		memread(hash_mask_addr, sizeof(hash_mask), &hash_mask, "hash_mask");
		for (i = 0; i <= hash_mask; i++) {
			memread(mount_hashtable, sizeof(lh), &lh, "mount_hashtable");
			addr = (addr_t)lh.next;
			while (addr != mount_hashtable && addr) {
				addr = print_vfsmount(addr, 1);
			}
			mount_hashtable += sizeof(lh);
		}
	} else {
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			addr = print_vfsmount(addr, 0);
		}
	}
	return addr;
}
