/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp.daemon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.jent.checksmtp.daemon.ApplicationProperties;
import org.jent.checksmtp.daemon.LDAPSearch;
import org.jent.checksmtp.daemon.SmtpBufferedWriter;
import org.jent.checksmtp.daemon.ToListDialog;

public class Processer
implements Runnable {
    private Socket client;
    private final int RESULT_UNKNOWN = 0;
    private final int RESULT_OK = 1;
    private final int RESULT_NG = 2;
    private int result = 0;
    private final int R354StartInput = 354;
    private final int R221ServiceClosing = 221;
    private final int R451RequestedActionAbort = 451;
    private final int R502CommandNotImplemented = 502;
    private final String COMMAND_RCPT_TO = "RCPT TO:";
    private final String COMMAND_DATA = "DATA";
    private final String COMMAND_RESET = "RSET";
    private final String COMMAND_TURN = "TURN";

    public Processer(Socket client) {
        this.client = client;
    }

    public void run() {
        try {
            String servername = ApplicationProperties.getSmtpServerHost();
            int serverport = ApplicationProperties.getSmtpServerPort();
            Socket server = new Socket(servername, serverport);
            InputStream serverInput = server.getInputStream();
            OutputStream serverOutput = server.getOutputStream();
            InputStream clientInput = this.client.getInputStream();
            OutputStream clientOutput = this.client.getOutputStream();
            BufferedReader serverReader = new BufferedReader(new InputStreamReader(server.getInputStream()));
            PrintWriter serverWriter = new PrintWriter((Writer)new SmtpBufferedWriter(new OutputStreamWriter(server.getOutputStream(), "ISO-8859-1")), true);
            BufferedReader clientReader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            PrintWriter clientWriter = new PrintWriter((Writer)new SmtpBufferedWriter(new OutputStreamWriter(this.client.getOutputStream(), "ISO-8859-1")), true);
            this.smtpStart(serverReader, clientWriter, clientReader, serverWriter);
            server.close();
            this.client.close();
        }
        catch (IOException e) {
            System.err.println("Execption occurred in Processer.");
            e.printStackTrace();
        }
    }

    private int getCode(String s) {
        return Integer.parseInt(s.substring(0, 3));
    }

    private boolean isContinue(String s) {
        return '-' == s.charAt(3);
    }

    private boolean isRcptTo(String s) {
        return s.startsWith("RCPT TO:");
    }

    private boolean isData(String s) {
        return s.startsWith("DATA");
    }

    private boolean isTurn(String s) {
        return s.startsWith("TURN");
    }

    public void sayOK() {
        this.result = 1;
        this.notifyResult();
    }

    public void sayNG() {
        this.result = 2;
        this.notifyResult();
    }

    private synchronized void notifyResult() {
        this.notify();
    }

    private void smtpStart(BufferedReader serverReader, PrintWriter clientWriter, BufferedReader clientReader, PrintWriter serverWriter) {
        try {
            ArrayList<String> toList = new ArrayList<String>();
            while (true) {
                String line = serverReader.readLine();
                clientWriter.println(line);
                System.out.println(line);
                if (this.isContinue(line)) continue;
                if (221 != this.getCode(line)) {
                    if (354 == this.getCode(line)) {
                        System.out.println("Send mail data.");
                        do {
                            line = clientReader.readLine();
                            serverWriter.println(line);
                        } while (!line.equals("."));
                        continue;
                    }
                    while (true) {
                        if (this.isRcptTo(line = clientReader.readLine())) {
                            toList.add(this.formatToAddress(line));
                            break;
                        }
                        if (this.isTurn(line)) {
                            System.err.println("'TURN' is unsupported command.");
                            clientWriter.println(502);
                            continue;
                        }
                        if (!this.isData(line)) break;
                        ListIterator iterater = toList.listIterator();
                        while (iterater.hasNext()) {
                            System.out.println("ADDRESS CHECK:" + iterater.next());
                        }
                        new ToListDialog(this, toList);
                        while (this.result == 0) {
                            try {
                                Processer processer = this;
                                synchronized (processer) {
                                    Object var10_11;
                                    try {
                                        this.wait();
                                        var10_11 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var10_11 = null;
                                        throw throwable;
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                System.err.println("Dialg wait interrupted");
                                e.printStackTrace();
                            }
                        }
                        if (this.result != 2) break;
                        System.out.println("CANCEL sending mail.");
                        serverWriter.println("RSET");
                        line = serverReader.readLine();
                        System.out.println("RSET:ANSER is " + line);
                        clientWriter.println(451);
                    }
                    serverWriter.println(line);
                    System.out.println(line);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("End of Session.");
    }

    private String formatToAddress(String line) {
        int i;
        System.out.println("FIND To: " + line);
        String str = line.substring("RCPT TO:".length() + 1);
        Pattern pattern = Pattern.compile("[< >]+");
        String[] address = pattern.split(str);
        for (i = 0; i < address.length && address[i].equals(""); ++i) {
        }
        str = String.valueOf(address[i]) + " " + LDAPSearch.search(address[i]);
        return str;
    }
}

