TARGET = \
	ann_nsm.mdc ban_sgw_v1.mdc ban_sg1.mdc ban_sg2.mdc btc_rlc.mdc \
	dfc_juk.mdc dfc_kf12.mdc dfc_j4.mdc \
	fmc_tc12.mdc fmc_tc34.mdc fmc_ppn.mdc fmc_thse.mdc fmc_smb.mdc \
	ifd_sl2.mdc ima_gin.mdc jfd_dfs.mdc jfd_ggb.mdc \
	kds_esp.mdc kds_aka.mdc kds_you.mdc kds_nzn.mdc kds_twn.mdc \
	kds_akm_v0.mdc kds_akm_v1.mdc \
	ksc_elc.mdc pnf_dan.mdc pnf_win.mdc \
	sfc_fyt.mdc sfc_neu.mdc sfc_psr.mdc ssd_dzn.mdc \
	sqf_krn.mdc sqf_rjn.mdc 
#	ifd_slr.mdc ban_sg1.mdc \
#	sfc_fyt.mdc 
ADDRESS_RANGE = \$$6000-\$$dfff
TYPE = disk

include mdc.mk

#multi version specify for KDS-AKM
kds_akm_v0.o: kds_akm.s
	$(AS) -D version=0 -l -o $@ $< > $(subst .o,.lst,$@)
kds_akm_v1.o: kds_akm.s
	$(AS) -D version=1 -l -o $@ $< > $(subst .o,.lst,$@)
#multi version specify for ANN-NSM
ann_nsm.o: ann_nsm.s
	$(AS) -D version=0 -L -o $@ $<
ann_nsm.mdc: ann_nsm.o
	make -f disk_manual2.mak $@ MDC=$@ OBJ=$?\
	FILE0=NSMMAIN R0S=6000 R0E=c5cf \
	FILE1=NSMDATA3 R1S=c5d0 R1E=dfff

#for FMC-SMB
fmc_smb.o: ann_nsm.s
	$(AS) -D version=1 -l -o $@ $< > fmc_smb.lst
fmc_smb.mdc: fmc_smb.o
	make -f disk_manual2.mak $@ MDC=$@ OBJ=$?\
	FILE0=SM2MAIN R0S=6000 R0E=c5cf \
	FILE1=SM2DATA3 R1S=c5d0 R1E=dfff

#address filter for SSD-DZN. range for disk1.sideA.DOS
ssd_dzn.mot: ssd_dzn.o
	$(P2HEX) $< $@ -r \$$0450-\$$067d -F moto

sqf_krn.mdc: sqf_krn.o
	make -f disk_manual2.mak $@ MDC=$@ OBJ=$?\
	FILE0="START UP" R0S=6000 R0E=acef \
	FILE1=OPENING R1S=b100 R1E=dcef

ifd_sl2.mdc: ifd_sl2.o
	make -f disk_manual2.mak $@ MDC=$@ OBJ=$?\
	FILE0=LRMAIN02 R0S=6000 R0E=d9ae \
	FILE1=PROTECT R1S=d9af R1E=dfff

ifd_slr.mdc: ifd_slr.mot ../mdc/ifd_sl2.mdt
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	printf "$(PATCH_PREFIX)file = PROTECT\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat ifd_slr.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	cp $@ $(MDCDIR)

#version ͤϼդ֤ǤäơեȥСȤ̵ط
ban_sg1.o: ban_sg1.s
	$(AS) -D version=0 -l -o $@ $< > $(subst .o,.lst,$@)
ban_sg1.mdc: ban_sg1.o
	make -f disk_manual2.mak $@ MDC=$@ OBJ=$?\
	FILE0=GUN.COM R0S=cd00 R0E=dfff \
	FILE1=END.COM R1S=a000 R1E=abff
ban_sg2.o: ban_sg1.s
	$(AS) -D version=1 -l -o $@ $< > $(subst .o,.lst,$@)
ban_sg2.mdc: ban_sg2.o
	make -f disk_manual2.mak $@ MDC=$@ OBJ=$?\
	FILE0=GUN.COM R0S=cd00 R0E=dfff \
	FILE1=END.COM R1S=a000 R1E=abff
ban_sgw_v1.o: ban_sg1.s
	$(AS) -D version=2 -l -o $@ $< > $(subst .o,.lst,$@)
ban_sgw_v1.mdc: ban_sgw_v1.o
	make -f disk_manual2.mak $@ MDC=$@ OBJ=$?\
	FILE0=GUN.COM R0S=cd00 R0E=dfff \
	FILE1=END.COM R1S=a000 R1E=abff
