package jp.co.kpscorp.meema.test;

import com.thoughtworks.selenium.Wait;

import jp.co.kpscorp.meema.selenium.SeleniumAssert;
import jp.co.kpscorp.meema.selenium.SeleniumAssertExe;
import jp.co.kpscorp.meema.selenium.SeleniumAssertGen;
import jp.co.kpscorp.meema.selenium.SeleniumTestCase;

/**
 * <strong> selenum rc との連携サンプル。</strong>
 * <p>
 * 詳細は http://meema.sourceforge.jp を参照してください。
 * 
 * @author katsusuke
 * 
 */
public class WebSampleTest extends SeleniumTestCase {
	public void testSample() throws Exception {

		// SeleniumAssert コード生成
		SeleniumAssert sa = new SeleniumAssertGen(selenium, "src",
				"jp.co.kpscorp.meema.test.asserts");
		// コード生成 ここまで

		// SeleniumAssert コード実行
		// SeleniumAssert sa = new SeleniumAssertExe(selenium,
		// "jp.co.kpscorp.meema.test.asserts");
		// コード実行 ここまで

		// URLを開く
		selenium.open("/sample/sample.htm");
		// case01 メッセージ こんにちは世界
		selenium.type("i1", "こんにちは世界");
		selenium.click("//input[@value='GO']");
		// ta1に文字が出るのを待つ
		Wait w1 = new Wait() {
			public boolean until() {
				return !"".equals(selenium.getValue("ta1"));
			}
		};
		w1.wait("Time Over case01");
		// SeleniumAssert実行
		sa.makeHtml().checkTable("//table[1]").checkTable("//table[2]")
				.checkTable("//table[3]").exec("case01");

		// case02 メッセージ なし
		selenium.type("i1", "");
		selenium.click("//input[@value='GO']");
		w1.wait("Time Over case02");
		// SeleniumAssert実行
		sa.makeHtml().checkTable("//table[1]").checkTable("//table[2]")
				.checkTable("//table[3]").exec("case02");

	}
}
