/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.engine.plugin;

import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import jp.co.kpscorp.meema.engine.BeanMethod;
import jp.co.kpscorp.meema.util.Util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * BeanのプロパティからExcelシートを作成するBeanPropertyGetter用Plugin
 * 
 * @version 2004/08/02
 * @author Katsusuke
 * @see
 */
public class ExcelMaker implements Plugin {
	private int sheetIdx;

	private static String gColumnName = "@ParentName";

	private static String mColumnName = "@Property";

	private static String cColumnName = "@MyName";

	private String filePath;

	private String sufix;

	private Map<String, HSSFSheet> classNameMap;

	private Map<String, String> row;

	private HSSFWorkbook wb;

	private static Log log = LogFactory.getLog(ExcelMaker.class);

	/**
	 * 初期処理
	 * 
	 * @param arg
	 *            サフィックス
	 * @see jp.co.kpscorp.commontools.Plugin#setUp(java.lang.Object[])
	 */
	public void setUp(Object[] arg) {
		classNameMap = new HashMap<String, HSSFSheet>();
		wb = new HSSFWorkbook();
		sheetIdx = 0;
		if (arg[0] != null && arg[0] instanceof String) {
			sufix = (String) arg[0];
		}
	}

	/**
	 * @param bm
	 * @throws Exception
	 * @see jp.co.kpsCorp.commonTools.Plugin#execElement(jp.co.kpsCorp.commonTools.BeanMethod)
	 */
	public void execElement(BeanMethod bm) throws Exception {
	}

	/**
	 * @param bm
	 * @throws Exception
	 * @see jp.co.kpsCorp.commonTools.Plugin#objectBegin(jp.co.kpsCorp.commonTools.BeanMethod)
	 */
	public void objectBegin(BeanMethod bm) throws Exception {
		if (bm.getDepth() == 0) {
			setUp(bm);
		}
	}

	/**
	 * @param bm
	 * @throws Exception
	 * @see jp.co.kpsCorp.commonTools.Plugin#objectEnd(jp.co.kpsCorp.commonTools.BeanMethod)
	 */
	public void objectEnd(BeanMethod bm) throws Exception {
		// Check対象で無いなら処理しない
		if (!bm.isCheckOn()) {
			return;
		}
		// debug
		// if(bm.getPropertyName().equals("tmUsr")){
		// Object o = bm.getBean();
		// }
		//
		row = new TreeMap<String, String>();
		Iterator<BeanMethod> it = bm.getBeanMethods().iterator();
		while (it.hasNext()) {
			BeanMethod koBm = it.next();
			// if (koBm.isReturningWrapper())
			if (koBm.getReturnObject() != null)
				row.put(koBm.getPropertyName(), koBm.getReturnObject()
						.toString());
			else
				row.put(koBm.getPropertyName(), null);
		}
		if (!row.isEmpty()) {
			String returnClassName = bm.getReturnObject().getClass()
					.getSimpleName();
			HSSFSheet sheet = classNameMap.get(returnClassName);
			if (sheet == null) {
				sheet = wb.createSheet();
				// sheet名で無効な文字をなくす
				String sheetName = returnClassName.replaceAll("/", "");
				sheetName = sheetName.replaceAll("\\\\", "");
				sheetName = sheetName.replaceAll("\\*", "");
				sheetName = sheetName.replaceAll("\\?", "");
				sheetName = sheetName.replaceAll("\\[", "");
				sheetName = sheetName.replaceAll("\\]", "");
				if (sheetName.length() > 31) {
					sheetName = sheetName.substring(0, 30);
				}
				wb.setSheetName(sheetIdx, sheetName, HSSFCell.ENCODING_UTF_16);
				sheetIdx++;
				classNameMap.put(returnClassName, sheet);
				// 行タイトル作成
				HSSFRow sheetRow = sheet.createRow(0);
				// setToCell(sheetRow, 0, "確認者:");
				// setToCell(sheetRow, 2, "確認日:");
				// setToCell(sheetRow, 4, "結果:");
				// sheetRow = sheet.createRow(1);
				setToCell(sheetRow, 0, gColumnName);
				setToCell(sheetRow, 1, mColumnName);
				setToCell(sheetRow, 2, cColumnName);
				Iterator<String> it2 = row.keySet().iterator();
				int i = 3;
				while (it2.hasNext()) {
					setToCell(sheetRow, i, it2.next());
					i++;
				}
			}
			HSSFRow sheetRow = sheet.createRow(sheet.getLastRowNum() + 1);
			// オブジェクトの識別子を１－３列目に設定
			if (bm.getBean() != null)
				setToCell(sheetRow, 0, bm.getBean().toString());
			if (bm.getReturnObject() != null)
				setToCell(sheetRow, 1, bm.getPropertyName());
			if (bm.getReturnObject() != null)
				setToCell(sheetRow, 2, bm.getReturnObject().toString());
			Iterator<String> it2 = row.values().iterator();
			int i = 3;
			while (it2.hasNext()) {
				setToCell(sheetRow, i, it2.next());
				i++;
			}
		}
		if (bm.getDepth() == 0) {
			tearDown(bm);
		}
	}

	private HSSFCell setToCell(HSSFRow row, int i, String value) {
		HSSFCell cell = row.createCell((short) i);
		cell.setEncoding(HSSFCell.ENCODING_UTF_16);
		cell.setCellValue(value);
		return cell;
	}

	private void setUp(BeanMethod bm) throws Exception {
		classNameMap.clear();
	}

	private void tearDown(BeanMethod bm) throws Exception {
		if (!filePath.endsWith("xls")) {
			filePath = filePath + ".xls";
		}
		if (sufix != null) {
			filePath = Util.putMidfix(filePath, sufix);
		}
		FileOutputStream fos = new FileOutputStream(filePath);
		wb.write(fos);
		fos.close();
		log.info("ExcelMaker:excel file '" + filePath + "' was written!");
	}

	/**
	 * 出力するExcelファイルのフルパス名を参照する
	 * 
	 * @return
	 */
	public String getFilePath() {
		return filePath;
	}

	/**
	 * 出力するExcelファイルのフルパス名を参照する
	 * 
	 * @param string
	 */
	public void setFilePath(String string) {
		filePath = string;
	}
}
