/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.selenium;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

/**
 *<strong>Seleniumテスト用、Assertクラス生成および実行用のインターフェース 。</strong>
 *<p>
 * @author katsusuke
 *
 */
public interface SeleniumAssert {

	/**
	 * 生成したHTMLを正規変換する場合のfrom,toを追加する
	 * @param from
	 * @param to
	 */
	public void addHtmlRegex(String from, String to);

	/**
	 * Assertクラス生成または実行を行う
	 * @param suffix テストケース識別用のサフィックス
	 * @throws Exception
	 */
	public void exec(String suffix) throws Exception;

	/**
	 * DBの内容をAssertする
	 * @param sql 検証を行うためのselect文
	 * @param con DBのconnection
	 * @return
	 * @throws SQLException
	 */
	public SeleniumAssert execSql(String sql, Connection con)
			throws SQLException;

	/**
	 * テーブルのcellの内容をAssertする
	 * @param addr 検証対象のテーブルのtableLocator
	 * @return
	 */
	public SeleniumAssert checkTable(String addr);

	/**
	 * 検証した画面のHTMLを出力する
	 * @return
	 * @throws IOException
	 */
	public SeleniumAssert makeHtml() throws IOException;

	/**
	 * makeHtml()で出力するHTMLの出力先のパスを設定<br>
	 * ディフォルトは html
	 * @param dirPath
	 */
	public void setDirPath(String dirPath);

	/**
	 * makeHtml()を実行した際、実際にHTMLを出力するかどうかを設定する<br>
	 * ディフォルトは生成時：true 実行時：false
	 * @param makeHtml
	 */
	public void setMakeHtml(boolean makeHtml);

}
