/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.selenium;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import jp.co.kpscorp.meema.service.TestService;


/**
 *<strong> SeleniumAssertの実装用スーパークラス。</strong>
 *<p>
 * @author katsusuke
 *
 */
public abstract class SeleniumAssertBase implements SeleniumAssert {

	protected SeleniumTester tester;

	protected TestService ts;

	private boolean makeHtml;

	private boolean htmlFlg = false;

	public SeleniumAssertBase() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see sample.test.SeleniumAssert#addHtmlRegex(java.lang.String,
	 *      java.lang.String)
	 */
	public void addHtmlRegex(String from, String to) {
		tester.addHtmlRegex(from, to);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see sample.test.SeleniumAssert#exec(java.lang.String)
	 */
	public void exec(String suffix) throws Exception {
		tester.exec();
		if (makeHtml && htmlFlg) {
			tester.makeHtml(suffix);
		}
		htmlFlg = false;
		ts.exec(tester, suffix);
		tester.clear();
	}

	/* (non-Javadoc)
	 * @see sample.test.SeleniumAssert#execSql(java.lang.String, java.sql.Connection)
	 */
	public SeleniumAssert execSql(String sql, Connection con)
			throws SQLException {
		tester.execSql(sql, con);
		return this;
	}

	/* (non-Javadoc)
	 * @see sample.test.SeleniumAssert#checkTable(java.lang.String)
	 */
	public SeleniumAssert checkTable(String addr) {
		tester.execTable(addr);
		return this;
	}

	/* (non-Javadoc)
	 * @see sample.test.SeleniumAssert#makeHtml()
	 */
	public SeleniumAssert makeHtml() throws IOException {
		htmlFlg = true;
		return this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see sample.test.SeleniumAssert#setDirPath(java.lang.String)
	 */
	public void setDirPath(String dirPath) {
		tester.setDirPath(dirPath);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see sample.test.SeleniumAssert#setMakeHtml(boolean)
	 */
	public void setMakeHtml(boolean makeHtml) {
		this.makeHtml = makeHtml;
	}

}
