/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.service;

import jp.co.kpscorp.meema.engine.plugin.ExcelMaker;
import jp.co.kpscorp.meema.engine.plugin.Plugin;

/**
 * <strong>テストに便利なメソッドを提供する。 </strong>
 * <p>
 * チェック用Excelファイルを作成する。
 * 
 * @author Katsusuke 作成日:2005/06/09
 */
public class TestServiceExcel extends TestServiceSuper {
	private ExcelMaker bpem;

	/**
	 * @param dirPath
	 *            Excelファイルを作成するホルダー名
	 */
	public TestServiceExcel(String dirPath) {
		super();
		setSrcPath(dirPath);
	}

	/**
	 * Excelチェックファイルを作成するPluginを返す
	 * 
	 * @return
	 * @see jp.co.kpscorp.commontools.TestServiceSuper#getPlugin()
	 */
	protected Plugin getPlugin() {
		if (bpem == null) {
			bpem = new ExcelMaker();
		}
		return bpem;
	}

	/**
	 * 書き出したファイルのファイルパスを返す。
	 * 
	 * @return
	 */
	public String getFilePath() {
		return bpem.getFilePath();
	}

	public int getLineLimit() {
		return 0;
	}

	public void setLineLimit(int lineLimit) {
	}
}
