/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.util;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * BeanPropertyGetterPlugin用のサービスメソッドを集めたクラス。
 * 
 * @version 2004/07/29
 * @author Katsusuke
 * @see
 */
public class Util {

	/**
	 * オブジェクトのクラス名を返す。クラス名に"$"が含まれている場合は、 実装している1個目のインタフェース名を返す。
	 * 
	 * @param o
	 * @return
	 */
	public static String getClassName(Object o) {
		String className = o.getClass().getName();
		return className.replace("$".charAt(0), ".".charAt(0));
	}

	/**
	 * 生成するコードのメソッド名を返す
	 * 
	 * @param o
	 * @param sufix
	 * @return
	 */
	public static String getTestMethodName(Object o, String sufix) {
		StringBuffer methodName = new StringBuffer("check");
		methodName.append(o.getClass().getSimpleName());
		if (sufix != null) {
			methodName.append(sufix);
		}
		return methodName.toString();
	}

	/**
	 * 文字列がFileringされるか正規表現で判断する
	 * 
	 * @param s
	 * @param map
	 * @return
	 */
	public static boolean isFiltering(String s, Map map) {
		Iterator it = map.keySet().iterator();
		while (it.hasNext()) {
			String ng = (String) it.next();
			Pattern pattern = Pattern.compile(ng);
			Matcher matcher = pattern.matcher(s);
			if (matcher.matches()) {
				return true;
			}
		}
		return false;
	}

	/**
	 * S2AOPの拡張クラスの拡張名部分を外す
	 * 
	 * @param c
	 * @return
	 */
	public static String getExAopName(Class c) {
		String s = c.getName();
		// s2aop対応
		int i = s.indexOf("$$EnhancedByS2AOP$$");
		if (i != -1) {
			s = s.substring(0, i);
		}
		return s;
	}

	/**
	 * 文字列内の特殊文字をエスケープシーケンスに変換する。 <br>
	 * 対象の特殊文字は\\,\n,\r,\f,\t,\',\"
	 * 
	 * @param s
	 * @return
	 */
	public static String escapeString(String s) {
		String res = s;
		res = res.replaceAll("\\\\", "\\\\\\\\");
		res = res.replaceAll("\n", "\\\\n");
		res = res.replaceAll("\r", "\\\\r");
		res = res.replaceAll("\f", "\\\\f");
		res = res.replaceAll("\t", "\\\\t");
		res = res.replaceAll("\'", "\\\\'");
		res = res.replaceAll("\"", "\\\\\"");
		return res;
	}

	/**
	 * 文字列内のエスケープシーケンスを特殊文字にもどす。 <br>
	 * 対象の特殊文字は\\,\n,\r,\f,\t,\',\"
	 * 
	 * @param s
	 * @return
	 */
	public static String deescapeString(String s) {
		String res = s;
		res = res.replaceAll("\\\\\\\\", "\\\\");
		res = res.replaceAll("\\\\n", "\n");
		res = res.replaceAll("\\\\r", "\r");
		res = res.replaceAll("\\\\f", "\f");
		res = res.replaceAll("\\\\t", "\t");
		res = res.replaceAll("\\\\'", "\'");
		res = res.replaceAll("\\\\\"", "\"");
		return res;
	}
	
	/**
	 * ファイル名にmidFixをつける
	 * 
	 * @param fileName
	 * @param midFix
	 * @return
	 */
	public static String putMidfix(String fileName, String midFix) {
		int li = fileName.lastIndexOf(".");
		if (li > 0) {
			fileName = fileName.substring(0, li) + midFix
					+ fileName.substring(li);
		} else {
			fileName = fileName + midFix;
		}
		return fileName;
	}


}
