///////////////////////////////////////////////////////////////////////////////
//
// dll for Meltice eXtenDing "FROSTICE.MXD"
//
//   Meltice    : Meltice 2.x Copyright (C)2000-2002 ardry, Project Meltice.
//   Base Engine: Common Archiver Project DLL.
//
///////////////////////////////////////////////////////////////////////////////
// FC_INIST.CPP = Meltice Plug-ins / Frostice Config grp/ MEMory SeTtings.
///////////////////////////////////////////////////////////////////////////////
// $Id: FC_MEMST.CPP,v 1.12 2002/04/11 16:17:20 ardry Exp $ 
///////////////////////////////////////////////////////////////////////////////

#include "mxd_fltc.h"

static bool cfg_readonly; //INI is ReadOnly / INI cannot Write.
static char destfile[MAX_PATH+1]; // default output file. (mem only.)

//Instance for DLL
static HINSTANCE	hInstance;

//[Global] Section
static bool autolang; // Auto switching language.
static int  dialog_x;
static int  dialog_y;
static bool writelog; // WriteLog.


//[Pack] Section
static char destdir[MAX_PATH+1]; // default output directory.
static bool opendir; // Open directory by explorer.
static char opdirex[MAX_PATH+1]; // customize for Open directory program.
static bool samedir; // Frostice archive to same dir.
static char destexp[10]; // "lzh" , "tar.gz", ...
static char destexpcode; // 1=lzh, 2=zip,3=cab,... 1-8.

static int packlvl; //PackLevel. 0-9.
static bool dosname; // Frostice compress to DOS 8.3 filename.
static bool withsfx; // Frostice make sfx file for lzh,zip,cab.
static bool withjak; // Frostice make jak file whhen archive file over 1423KB.
static bool withpwd; // Frostice make archive file with password for zip,yz1.

static bool withmd5; // Frostice make archive file with md5 hash.
static bool md5form; // md5 hash form (short or long.)

static bool smplgui; // Dialog is omitted.

//-----------------------------------------------------------------------------
// void get_dll_instance / set_dll_instance
//
//  hInst : hInstance fot this mxd...
//
void set_dll_instance(HINSTANCE hInst)
{
	hInstance = hInst;
	return;
}

HINSTANCE get_dll_instance(void)
{
	return hInstance;
}


//-----------------------------------------------------------------------------
// void get_cfg_readonly / set_cfg_readonly
//
//  alang : true  = Read Only.
//        : false = ini file can Read and Write (Default)
//
void set_cfg_readonly(const bool ronly)
{
	cfg_readonly = ronly;
	return;
}

bool get_cfg_readonly(void)
{
	return cfg_readonly;
}



//-----------------------------------------------------------------------------
// void get_autolang / set_autolang
//
//  alang : true  = Japanese and US-English Auto switch dialog.
//        : false = US-English mode only.
//
void set_autolang(const bool alang)
{
	autolang = alang;
	return;
}

bool get_autolang(void)
{
	return autolang;
}

//-----------------------------------------------------------------------------
// void get_writelog / set_writelog
//
//  wlog : true  = Processing Log for Debug.
//       : false = No output log.
//
void set_writelog(const bool wlog)
{
	writelog = wlog;
	return;
}

bool get_writelog(void)
{
	return writelog;
}

//-----------------------------------------------------------------------------
// void get_dialog_x(y) / set_dialog_x(y)
void set_dialog_x(const int xpos)
{
	dialog_x = xpos;
	return;
}
void set_dialog_y(const int ypos)
{
	dialog_y = ypos;
	return;
}

int get_dialog_x(void)
{
	return dialog_x;
}

int get_dialog_y(void)
{
	return dialog_y;
}


//-----------------------------------------------------------------------------
// void get_destfile / set_destfile for memonly (autosave...)
//
//  outfil : Frostice output file.
//  fillen : string "output"'s length. 
void get_destfile(char *outfil, const int fillen)
{
	lstrcpyn(outfil, destfile, fillen);
	return;
}

void set_destfile(char *outfil, const int fillen)
{
	lstrcpyn(destfile, outfil, fillen);
	return;
}


//-----------------------------------------------------------------------------
// void get_destdir / set_destdir
//
//  outdir : Frostice output dir.
//  dirlen : string "output"'s length. 
//  sw     : not use (reserved.)
void get_destdir(char *outdir, const int dirlen, const int sw)
{
	lstrcpyn(outdir, destdir, dirlen);
	return;
}

void set_destdir(char *outdir, const int dirlen, const int sw)
{
	lstrcpyn(destdir, outdir, dirlen);
	return;
}

//-----------------------------------------------------------------------------
// void get_opendir / set_opendir
//
//  opdir : true  = open dir when frostice packed files. 
//        : false = silence when frostice packed file.(default)
//  sw    : not use (reserved.)
//
//
void set_opendir(const bool opdir, const int sw)
{
	opendir = opdir;
	return;
}

bool get_opendir(const int sw)
{
	return opendir;
}

//-----------------------------------------------------------------------------
// void get_opdirex / set_opdirex
//
//  runcmd : command for directory open.
//  cmdlen : string "output"'s length. 
//  sw     : not use (reserved.)
void get_opdirex(char *runcmd, const int cmdlen, const int sw)
{
	lstrcpyn(runcmd, opdirex, cmdlen);
	return;
}

void set_opdirex(const char *runcmd, const int cmdlen, const int sw)
{
	lstrcpyn(opdirex, runcmd, cmdlen);
	return;
}

//-----------------------------------------------------------------------------
// void get_samedir / set_samedir
//
//  smdir : true  = frostice pack file to same dir. 
//        : false = frostice pack file to destdir. (default)
//  sw    : not use (reserved.)
//
//
void set_samedir(const bool smdir, const int sw)
{
	samedir = smdir;
	return;
}

bool get_samedir(const int sw)
{
	return samedir;
}

//-----------------------------------------------------------------------------
// void get_destexp / int get_destexpcode / void set_destexp / 
// void set_destexpcode
//
//  exp : "lzh" = lzh, "tar.gz" = gzip, etc...
//
//

void set_destexp(const char *exp)
{
	char *buf = new char[lstrlen(exp)];
	lstrcpy(buf,exp);
	CharLower(buf);
	lstrcpyn(destexp,buf,8);
	
	if(lstrcmp(destexp,"zip")==0){
		destexpcode=2;
	}else if(lstrcmp(destexp,"cab")==0){
		destexpcode=3;
	}else if(lstrcmp(destexp,"tar.gz")==0){
		destexpcode=4;
	}else if(lstrcmp(destexp,"tar.bz2")==0){
		destexpcode=5;
	}else if(lstrcmp(destexp,"gza")==0){
		destexpcode=6;
	}else if(lstrcmp(destexp,"bza")==0){
		destexpcode=7;
	}else if(lstrcmp(destexp,"yz1")==0){
		destexpcode=8;
	}else{
		destexpcode=1; //lzh. (default).
	}
}

void get_destexp(char *dtexp, const int len)
{
	lstrcpyn(dtexp, destexp, len);
	return;
}

int get_destexpcode(void)
{
	return destexpcode;
}

void set_destexpcode(int dec)
{
	if(dec >= 1 && dec <= 8)
		destexpcode = dec;
	else
		destexpcode = 1;
	switch(destexpcode)
	{
		case 2:
			lstrcpy(destexp,"zip");
			break;
		case 3:
			lstrcpy(destexp,"cab");
			break;
		case 4:
			lstrcpy(destexp,"tar.gz");
			break;
		case 5:
			lstrcpy(destexp,"tar.bz2");
			break;
		case 6:
			lstrcpy(destexp,"gza");
			break;
		case 7:
			lstrcpy(destexp,"bza");
			break;
		case 8:
			lstrcpy(destexp,"yz1");
			break;
		default:
			lstrcpy(destexp,"lzh");
			break;
	}
}


//-----------------------------------------------------------------------------
// void get_packlvl / set_packlvl
void set_packlvl(const int pklvl)
{
	if(pklvl >= 0 && pklvl <= 9) packlvl = pklvl;
	else packlvl = 0;
	return;
}

int get_packlvl(void)
{
	if(packlvl >= 0 && packlvl <= 9) return packlvl;
	else return 0;
}

//-----------------------------------------------------------------------------
// void get_dosname / set_dosname
//
//  dsnme : true  = frostice pack file to same dir. 
//        : false = frostice pack file to destdir. (default)
//
void set_dosname(const bool dsnme)
{
	dosname = dsnme;
	return;
}

bool get_dosname(void)
{
	return dosname;
}

//-----------------------------------------------------------------------------
// void get_withsfx / set_withsfx
//
//  dsnme : true  = frostice make sfx.
//        : false = frostice don't make sfx.
//
//
void set_withsfx(const bool wtsfx)
{
	withsfx = wtsfx;
	return;
}

bool get_withsfx(void)
{
	return withsfx;
}

//-----------------------------------------------------------------------------
// void get_withjak / set_withjak
//
//  dsnme : true  = frostice make jak when archive 1423KB over.
//        : false = frostice don't make jak.
//
//
void set_withjak(const bool wtjak)
{
	withjak = wtjak;
	return;
}

bool get_withjak(void)
{
	return withjak;
}

//-----------------------------------------------------------------------------
// void get_withpwd / set_withpwd
//
//  dsnme : true  = frostice make archive file with password for zip,yz1.
//        : false = frostice make archive file without password.
//
//
void set_withpwd(const bool wtpwd)
{
	withpwd = wtpwd;
	return;
}

bool get_withpwd(void)
{
	return withpwd;
}


//-----------------------------------------------------------------------------
// void get_withmd5 / set_withmd5
//
//  wtmd5 : true  = frostice make archive file with md5 hash.
//        : false = frostice make archive file without md5 hash.
//
// void get_md5form / set_md5form
//
//  md5fm : true  = md5 hash is long style (for BSD,md5 command).
//        : false = md5 hash is short style (for GNU,md5sum command).
//
void set_withmd5(const bool wtmd5)
{
	withmd5 = wtmd5;
	return;
}

bool get_withmd5(void)
{
	return withmd5;
}

void set_md5form(const bool md5fm)
{
	md5form = md5fm;
	return;
}

bool get_md5form(void)
{
	return md5form;
}


//-----------------------------------------------------------------------------
// void get_smplgui / set_smplgui
//
//  dsnme : true  = frostice dialog is omitted.
//        : false = Archive with frostice dialog.
//
//
void set_smplgui(const bool spgui)
{
	smplgui = spgui;
	return;
}

bool get_smplgui(void)
{
	return smplgui;
}
