///////////////////////////////////////////////////////////////////////////////
//
// Frostice Core for Common Archiver Library v2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// FD_ARDLL.CPP = Frostice Doit group / for common ARchiver Library DLL func.
///////////////////////////////////////////////////////////////////////////////
// $Id: FD_ARDLL.CPP,v 1.22 2002/04/28 23:07:50 ardry Exp $
///////////////////////////////////////////////////////////////////////////////

#include "mxd_fltc.h"
#include "resource.h"

//-----------------------------------------------------------------------------
// for Common Archiver Project DLL settings...

HINSTANCE  hInstDll[SUPPORT_DLL_NUM+1];


//dll chk...
static char dllname[SUPPORT_DLL_NUM+1][16] = 
{	"",
	"UNLHA32.DLL",
	"ZIP32J.DLL",
	"CAB32.DLL",
	"TAR32.DLL",
	"TAR32.DLL",
	"BGA32.DLL",
	"BGA32.DLL",
	"YZ1.DLL"
};

static char getver_api[SUPPORT_DLL_NUM+1][24] = 
{
	"",
	"UnlhaGetVersion",
	"ZipGetVersion",
	"CabGetVersion",
	"TarGetVersion",
	"TarGetVersion",
	"BgaGetVersion",
	"BgaGetVersion",
	"Yz1GetVersion"
};

// processing...
static char arcrun_api[SUPPORT_DLL_NUM+1][12] = 
{
	"",
	"Unlha",
	"Zip",
	"Cab",
	"Tar",
	"Tar",
	"Bga",
	"Bga",
	"Yz1"
};

//command for Compress to DOS8.3 name 
static char arcrun_dosname_cmd[SUPPORT_DLL_NUM+1][8] = {
	"",
	" -ji1 ",	//UNLHA32	: -ji0 = LFN, -ji1 = DOS name.
	" -k ",		//UNZIP32	: (no opt) = LFN, -k = DOS name.
	" -q ",		//CAB32	: (no opt) = LFN, -q = DOS name.
	"",			//tar.gz  not supported.
	"", 		//tar.bz2 not supported.
	"",			//BGA32 not supported.
	"",			//BGA32 not supported.
	""			//YZ1 not supported.
};

//DLL compress command.
static char arcrun_pack_cmd[SUPPORT_DLL_NUM+1][24] = {
	"",
	"a -x1 -r2 -a2 -jso1",
	"-S -r",
	"-a -r",
	"-c -z", //TAR32  -z1 ... -z9 -> Pack Level (Default:6).
	"-c -B", //TAR32  -B1 ... -B9 -> Pack Level (Default:9).
	"a -m1 -a -r",
	"a -m2 -a -r",
	"c -y "
	
};

//DLL archive file to exe(SFX) command.
static char arcrun_sfx_cmd[SUPPORT_DLL_NUM+1][32] = {
	"",
	"s -gwe4 -x1 -r2 -a2 -jso1 ",	//UNLHA32 : gw4 = NoDialog and toWinSFX32M. -gw[e|j] = en or jp.
	"--sfx ",	//this option have to need sfx32gui.dat for ZIP32J.DLL
	"-f -i ",	// -f = makeSFX, i=Silent mode.
	"",			// ---v--- TAR32.DLL can't support SFX.
	"",			// ---^--- TAR32.DLL can't support SFX.
	"s ",
	"s ",
	""			//YZ1 SFX have to need yzdec.exe, but Frostice can't support YZ1 SFX.
	
};

//DLL archive file with password command. (for zip,yz1)
static char arcrun_pwd_cmd[SUPPORT_DLL_NUM+1][4] = {
	"",
	"",		// lzh cannot support password.
	" -e",
	"",		// cab cannot support password.
	"",		// tar cannot support password.
	"",
	"",		// bga cannot support password.
	"",
	" -p"
	
};

//PackLevel.
static char arcrun_pack_with_level[SUPPORT_DLL_NUM+1][8] = {
	"",
	" -jm",		//UNLHA32	: (-jm0=lh0,) -jm1=lh1, -jm2=lh5 (Default), -jm3=lh6, -jm4=lh7, -jma=lhx-auto.
	" -",		//ZIP32J	: (-0 = Lvl0,) -1 = Level 1 ... -9 = Level 9.
	" -ml:",	//CAB32		: (-ms = nocompress, -mz = mszip), -ml:15 = LZX/15 ... -ml:21 = LZX/21
	"", 		//TAR32		: -z1 = Level 1 ... -z9 = Level 9.
	"", 		//TAR32		: -B1 = Level 1 ... -B9 = Level 9.
	" -l",		//BGA32		: -l1 = Level 1 ... -l9 = Level 9. (Level 9 Default.)
	" -l",		//BGA32		: -l1 = Level 1 ... -l9 = Level 9. (Level 9 Default.)
	""  		//YZ1		: the YZ1 format has no level.
};


static char dllerr_msg[72][24] = {
	"ERROR_START", //0x8000
	"", //0x8001
	"", //0x8002
	"", //0x8003
	"", //0x8004
	"ERROR_DISK_SPACE",			//0x8005
	"ERROR_READ_ONLY",			//0x8006
	"ERROR_USER_SKIP",			//0x8007
	"ERROR_UNKNOWN_TYPE",		//0x8008
	"ERROR_METHOD",				//0x8009
	"ERROR_PASSWORD_FILE2",		//0x800A
	"ERROR_VERSION",			//0x800B
	"ERROR_FILE_CRC",			//0x800C
	"ERROR_FILE_OPEN",			//0x800D
	"ERROR_MORE_FRESH",			//0x800E
	"ERROR_NOT_EXIST",			//0x800F
	"ERROR_ALREADY_EXIST",		//0x8010
	"ERROR_TOO_MANY_FILES",		//0x8011
	"ERROR_MAKEDIRECTORY",		//0x8012
	"ERROR_CANNOT_WRITE",		//0x8013
	"ERROR_HUFFMAN_CODE",		//0x8014
	"ERROR_COMMENT_HEADER",		//0x8015
	"ERROR_HEADR_CRC",			//0x8016
	"ERROR_HEADER_BROKEN",		//0x8017
	"ERROR_ARC_FILE_OPEN",		//0x8018
	"ERROR_NOT_ARC_FILE",		//0x8019
	"ERROR_CANNOT_READ",		//0x801A
	"ERROR_FILE_STYLE",			//0x801B
	"ERROR_COMMAND_NAME",		//0x801C
	"ERROR_MORE_HEAP_MEMORY",	//0x801D
	"ERROR_ENOUGH_MEMORY",		//0x801E
	"ERROR_ALREADY_RUNNING",	//0x801F
	"ERROR_USER_CANCEL",		//0x8020
	"ERROR_HARC_ISNOT_OPENED",	//0x8021
	"ERROR_NOT_SEARCH_MODE",	//0x8022
	"ERROR_NOT_SUPPORT",		//0x8023
	"ERROR_TIME_STAMP",			//0x8024
	"ERROR_TMP_OPEN",			//0x8025
	"ERROR_LONG_FILE_NAME",		//0x8026
	"ERROR_ARC_READ_ONLY",		//0x8027
	"ERROR_SAME_NAME_FILE",		//0x8028
	"ERROR_NOT_FIND_ARC_FILE",	//0x8029
	"ERROR_RESPONSE_READ",		//0x802A
	"ERROR_NOT_FILENAME",		//0x802B
	"ERROR_TMP_COPY",			//0x802C
	"ERROR_EOF",				//0x802D
	"ERROR_ADD_TO_LARC",		//0x802E
	"ERROR_TMP_BACK_SPACE",		//0x802F
	"ERROR_SHARING",			//0x8030
	"ERROR_NOT_FIND_FILE",		//0x8031
	"ERROR_LOG_FILE",			//0x8032
	"ERROR_NO_DEVICE",			//0x8033
	"ERROR_GET_ATTRIBUTES",		//0x8034
	"ERROR_SET_ATTRIBUTES",		//0x8035
	"ERROR_GET_INFORMATION",	//0x8036
	"ERROR_GET_POINT",			//0x8037
	"ERROR_SET_POINT",			//0x8038
	"ERROR_CONVERT_TIME",		//0x8039
	"ERROR_GET_TIME",			//0x803a
	"ERROR_SET_TIME",			//0x803b
	"ERROR_CLOSE_FILE",			//0x803c
	"ERROR_HEAP_MEMORY",		//0x803d
	"ERROR_HANDLE",				//0x803e
	"ERROR_TIME_STAMP_RANGE",	//0x803f
	"ERROR_MAKE_ARCHIVE",		//0x8040
	"ERROR_NOT_CONFIRM_NAME"	//0x8041
};

void get_dllerr_msg(char *errmsg,int errcode)
{
	if(errcode >= 0x8000 && errcode <= 0x8041)
		lstrcpyn(errmsg,dllerr_msg[errcode-0x8000],64);
	else
		lstrcpyn(errmsg,"UNKNOWN",64);
	
}


//Get DLL CompressLevel Command.
static void get_levelcmd(char *cmd, const int level, const int mode)
{
	char *cbuf = new char[32];
	
	switch(mode)
	{
		// (arcrun_pack_with_level) + (1...9 number.)
		case 2: //ZIP
		case 4: //TAR (gzip)
		case 5: //TAR (bzip2)
		case 6: //BGA (gzip)
		case 7: //BGA (bzip2)
			wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level);
			break;
		case 1: //LHa
			if(level >= 1 && level <= 4) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],2); // level 1,2,3,4 = lh5. (-jm2)
			else if (level >= 8) wsprintf(cmd,"%sa ",arcrun_pack_with_level[mode]); // level 8,9 = lhx (Auto).
			else wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level-3); // level 5,6,7 = lh5,6,7. (lh1=no support.) (-jm2,3,4)
			break;
		case 3: //Cab
			if(level==1) lstrcpy(cmd, " -mz"); //mszip.
			else if(level>=2 && level<=8) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level+13); // level 2=LZX/15...level 8=LZX/21
			else wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],21); // level 9=LZX/21
			break;
		//none. (etc...)
		case 8: //YZ1
		default:
			lstrcpy(cmd,"");
			break;
		
	}
}

// load Common Archiver's Project DLL
//   return true  -> DLL load success!
//   return false -> DLL load failed.
static bool load_dll(int mode)
{
	if(mode == 0) return false;
//	if(get_noardll(0) == true) return false;

	hInstDll[mode] =  LoadLibrary( dllname[mode] );
	if(hInstDll[mode] == NULL) return false;
	return true;
}

// make SFX file from archive file.
static void arc2sfx
	(	const HWND hDlg,
		const char *packedfile,	//packedfile. (packfullpath.)
		const char *outputdir,	//outputdir
		int mode)				//mode/
{
	if( !(	mode == 1 ||	//lzh
			mode == 2 ||	//zip
			mode == 3 ||	//cab
			mode == 6 ||	//gza
			mode == 7 		//bza
			) ) return; //Frostice can support lzh,zip,cabs' SFX.
	typedef BOOL  (WINAPI *PARCRUNFUNC)(const HWND, LPCSTR,LPSTR, const DWORD);
	
	if( load_dll(mode) == true){
		PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstDll[mode], arcrun_api[mode]);
		if(ArcRun != NULL) // API function ready...
		{
			char cmdbuf[MAX_PATH * 4];
			wsprintf(cmdbuf,"%s %s %s",arcrun_sfx_cmd[mode], packedfile, outputdir);
			int ret = (*ArcRun)(hDlg,cmdbuf,NULL,0);
			if(get_writelog()==true)
			{
				char *logbuf = new char[MAX_PATH * 5];
				char *errormsg = new char[32]; get_dllerr_msg(errormsg,ret);

				wsprintf(logbuf, "%s : [%s cmd] <%s>",packedfile, dllname[mode], cmdbuf);
				OutputLog("FROSTICE.LOG",logbuf);

				if(ret == 0)
					wsprintf(logbuf, "%s : [OK] (Arc2Sfx) Frostice succeeded in processing of this file.",packedfile);
				else
					wsprintf(logbuf, "%s : [NG] (Arc2Sfx) Frostice failed in processing of this file. (0x%04x:%s)",packedfile,ret,errormsg);
				OutputLog("FROSTICE.LOG",logbuf);
				delete [] errormsg;
				delete [] logbuf;
			}


		}
	}
	return;
}

// make JACK file from archive file when archive file's filesize is 1423KB over
// and exist JACK32.DLL and Not create SFX File.
//(it is bonus function(as Japanese, "omake") :-)
static void arc2jak
	(	const HWND hDlg,
		const char *packedfile,	//packedfile. (packfullpath.)
		const char *outputdir)	//outputdir
{
	if( get_withsfx() == true ) return; // not supported SFX divide.
	
	HINSTANCE  hInstJakDll;
	typedef DWORD  (WINAPI *PJAKRUNFUNC)(LPCSTR,LPCSTR,int,LPCSTR);

	hInstJakDll =  LoadLibrary("JACK32.DLL");
	if(hInstJakDll == NULL) return;
	PJAKRUNFUNC JakRun = (PJAKRUNFUNC)GetProcAddress(hInstJakDll, "JackRipper");
	if(JakRun == NULL) return; // API function not ready...

	DWORD dwSize;
	HANDLE hPkFile = CreateFile(packedfile, GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hPkFile == INVALID_HANDLE_VALUE )
		return ;
	//GetFileSize (0 bytes - 4GB only.)
	dwSize = GetFileSize(hPkFile,NULL);
	if (dwSize == 0xFFFFFFFF)
	{
		CloseHandle(hPkFile);
		return ; //4GB over or other error.
	}
	CloseHandle(hPkFile);
	
	if(dwSize > 1423*1024) //over 1.38MB 2HD Disksize.
	{
		int ret;
		
		char *str_isjack_msg   = new char[1024];
		char *str_isjack_title = new char[128];
		if(get_autolang() == true && GetACP() == IDS_STR_JPN_CODEPAGE) //AutoLang == true and Japanese env.
		{
			LoadString(get_dll_instance(),IDS_STR_ISJACKDIV      +IDS_STR_ADD_FORJPN,str_isjack_msg,1023);
			LoadString(get_dll_instance(),IDS_STR_ISJACKDIV_TITLE+IDS_STR_ADD_FORJPN,str_isjack_title,127);
		}else{
			LoadString(get_dll_instance(),IDS_STR_ISJACKDIV      ,str_isjack_msg,1024);
			LoadString(get_dll_instance(),IDS_STR_ISJACKDIV_TITLE,str_isjack_title,128);
		}
		ret = MessageBox(hDlg,str_isjack_msg,str_isjack_title,MB_ICONQUESTION|MB_YESNOCANCEL|MB_TOPMOST);
		delete [] str_isjack_title;
		delete [] str_isjack_msg;

		switch(ret)
		{
			case IDYES:
				(*JakRun)(packedfile,outputdir,1,"1423");
				break;
			case IDNO:
				break; // no divide and no setting change.
			default:
				InicfgToMemcfg();  //setting reset.
				set_withjak(false); //User don't want to Jak divide now, and future.
				MemcfgToInicfg(NULL); // withjak=false saving...
				break;
		}
	}
}

// pack and compress file from data file.
//  hDlg      <- hWnd.
//  newpkfile <- new archive file name.
//  filenames <- Filenames for Pack. (String ->["file1.txt" "file2.txt" ...] )
//  basedir   <- Base Dir.
//  outputdir <- destdir
//  mode      <- Pack mode. (lzh,zip,...)
int ardll_frost
	(	const HWND hDlg,
		const char *newpkfile,
		const char *filenames,
		const char *basedir,
		const char *outputdir,
		int mode)
{
	int ret;
	typedef BOOL  (WINAPI *PARCRUNFUNC)(const HWND, LPCSTR,LPSTR, const DWORD);
	
	if( load_dll(mode) == true){
		PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstDll[mode], arcrun_api[mode]);
		if(ArcRun != NULL) // API function ready...
		{
			char *cmdbuf= new char[(lstrlen(filenames)+(MAX_PATH*4))*2];
			char packfullpath[MAX_PATH];
			char packdirpath[MAX_PATH];


			lstrcpyn(packfullpath,outputdir,lstrlen(outputdir)-1);
			Path_Add_Backslash(packfullpath);
			lstrcat(packfullpath,newpkfile);
			lstrcat(packfullpath,"\"");

			char *subcmd = new char[MAX_PATH]; char *cbuf = new char[MAX_PATH]; //Temp buffer create.
			lstrcpy(subcmd,"");
			
			//Pack Level Settings.
			if(get_packlvl() != 0)
			{
				get_levelcmd(cbuf, get_packlvl(), mode);
				lstrcat(subcmd,cbuf);
			}
			if(get_dosname() == true)
			{
				lstrcat(subcmd, arcrun_dosname_cmd[mode]);
			}
			if(get_withpwd() == true)
			{
				lstrcat(subcmd, arcrun_pwd_cmd[mode]);
			}
			
/*			//wsprintf max buf is 2048... :-(
			wsprintf(cmdbuf,"%s%s %s %s %s",
				arcrun_pack_cmd[mode],subcmd,
				packfullpath, basedir, filenames);
*/
			lstrcpy(cmdbuf,arcrun_pack_cmd[mode]);
			lstrcat(cmdbuf,subcmd);lstrcat(cmdbuf," ");
			lstrcat(cmdbuf,packfullpath);lstrcat(cmdbuf," ");
			lstrcat(cmdbuf,basedir);lstrcat(cmdbuf," ");
			lstrcat(cmdbuf,filenames);
			
			delete [] subcmd;
			delete [] cbuf;

			ret = (*ArcRun)(hDlg,cmdbuf,NULL,0);
			if(get_writelog()==true)
			{
				char *logbuf = new char[(lstrlen(filenames) + MAX_PATH*2)*2];
				char *errormsg = new char[32]; get_dllerr_msg(errormsg,ret);

				wsprintf(logbuf, "\r\n%s : [Base folder] %s",packfullpath, basedir);
				OutputLog("FROSTICE.LOG",logbuf);
				wsprintf(logbuf, "%s : [The files which you want to compress.] ",packfullpath);
				lstrcat(logbuf,filenames);
				OutputLog("FROSTICE.LOG",logbuf);

				wsprintf(logbuf, "%s : [%s cmd] <",packfullpath, dllname[mode]);
				lstrcat(logbuf,cmdbuf); lstrcat(logbuf,">");

				OutputLog("FROSTICE.LOG",logbuf);

				if(ret == 0)
					wsprintf(logbuf, "%s : [OK] Frostice succeeded in processing of this file.",packfullpath);
				else
					wsprintf(logbuf, "%s : [NG] Frostice failed in processing of this file. (0x%04x:%s)",packfullpath,ret,errormsg);
				OutputLog("FROSTICE.LOG",logbuf);
				delete [] errormsg;
				delete [] logbuf;
			}

			if(ret==0){

				//make sfx files for lzh,zip,cab.
				if(get_withsfx() == true) arc2sfx(hDlg,packfullpath,outputdir,mode);
				
				//make MD5 hash. (archive file only), can't SFX's MD5 hash.
				if(get_withsfx() != true && get_withmd5()==true){
					lstrcpyn(packfullpath,outputdir+1,lstrlen(outputdir)-2);
					lstrcat(packfullpath,newpkfile);
					MD5HashByFile(packfullpath,get_md5form());
				}

				if(get_withsfx() != true &&  get_withjak() == true )
				{ 
					lstrcpyn(packdirpath ,outputdir+1,lstrlen(outputdir)-2);
					lstrcpyn(packfullpath,outputdir+1,lstrlen(outputdir)-2);
					lstrcat(packfullpath,newpkfile);
					arc2jak(hDlg,packfullpath,packdirpath);
				}
			}
			delete [] cmdbuf;
			return ret;
		}
	}else{
		char *str_nodll_msg   = new char[1024];
		char *str_nodll_title = new char[128];
		char *msgbuf          = new char[1024];
		if(get_autolang() == true && GetACP() == IDS_STR_JPN_CODEPAGE) //AutoLang == true and Japanese env.
		{
			LoadString(get_dll_instance(),IDS_STR_ERR_NODLL      +IDS_STR_ADD_FORJPN,str_nodll_msg,1023);
			LoadString(get_dll_instance(),IDS_STR_ERR_NODLL_TITLE+IDS_STR_ADD_FORJPN,str_nodll_title,127);
		}else{
			LoadString(get_dll_instance(),IDS_STR_ERR_NODLL      ,str_nodll_msg,1024);
			LoadString(get_dll_instance(),IDS_STR_ERR_NODLL_TITLE,str_nodll_title,128);
		}

		wsprintf(msgbuf, str_nodll_msg, dllname[mode]);
		MessageBox(hDlg,msgbuf,str_nodll_title,MB_ICONSTOP | MB_TOPMOST );
		delete [] msgbuf;
		delete [] str_nodll_title;
		delete [] str_nodll_msg;
	}
	return 1; //err.
}
