///////////////////////////////////////////////////////////////////////////////
//
// dll for Meltice eXtenDing "FROSTICE.MXD"
//
//   Meltice    : Meltice 2.x Copyright (C)2000-2002 ardry, Project Meltice.
//   Base Engine: Common Archiver Project DLL.
//
///////////////////////////////////////////////////////////////////////////////
// MXD_FLTC.CPP = Meltice Plug-ins / Meltice eXtend Dll Frostice. (FLosTiCe?)
///////////////////////////////////////////////////////////////////////////////
// $Id: MXD_FLTC.CPP,v 1.36 2002/06/15 14:44:04 ardry Exp $ 
///////////////////////////////////////////////////////////////////////////////

#include "mxd_fltc.h"
#include "resource.h"

#define EXPORT extern "C" __declspec(dllexport)

#define MXDVER				2050
	// Frostice.mxd 2.05.0 (Ver.2.05 Build 40.)
#define MXD_PROTOCOL_VER	2000
	// MXD Protocol Ver.2.00.0, for Meltice 2.0.0.57 or later.
#define OBJNAME				"MXD_FLTCMxd"
	// This object is "MXDFLTCMxd".

#define		BUF_LEN	4096
#define		MSGBOX_LEN	2048


//For DLL Dialog
HINSTANCE	hInstance;
HWND		hWnd; 


int WINAPI DllMain(HINSTANCE hInst, DWORD fdReason, PVOID)
{
	switch (fdReason) 
	{
		case DLL_PROCESS_ATTACH:
			hInstance = hInst;
			set_dll_instance(hInst);
			hWnd = (HWND) CreateFileMapping((HANDLE)0xFFFFFFFF, NULL, 
				PAGE_READWRITE, 0, 1024, OBJNAME);
			if(hWnd == 0) return FALSE;
			break;
		case DLL_PROCESS_DETACH:
			CloseHandle(hWnd);
			break;
		default:
			break;
	}
	return TRUE;
};
// DLL Version.
EXPORT int WINAPI MxdGetVersion(void)
{
	return MXDVER;
};

// DLL Protocol Version.
EXPORT int  WINAPI MxdGetProtocolVersion(void)
{
	return MXD_PROTOCOL_VER;
};


EXPORT bool WINAPI MxdConfigName(char *szbuf, const int iMode, const int iLang)
{
	if(iLang==IDS_STR_JPN_CODEPAGE && iMode==1) //Japanese, and Unpack settings.
	{
		LoadString(get_dll_instance(), IDS_STR_MXDNAME+IDS_STR_ADD_FORJPN,szbuf,20);
	}else if(iMode==1) //no Japanese, and Unpack settings.
	{
		LoadString(get_dll_instance(), IDS_STR_MXDNAME                   ,szbuf,20);
	}
	return false;
}

static void AddDLLVerInfo(char *sVerInfo)
{
	typedef WORD (WINAPI *PGETVERFUNC)();

	char *msgbuf = new char[BUF_LEN]; // Message.
	char *tmpbuf = new char[BUF_LEN]; // Temp.
	
	*msgbuf = '\0';	*tmpbuf = '\0';

	
	HINSTANCE  hInstDll;
	HINSTANCE  hInstSubDll; // for ZCRYPT32.DLL only?

	int  tmpver;					// DLL Versions.
	static char dllname[SUPPORT_DLL_NUM+1][16] = {"","UNLHA32.DLL","","ZIP32J.DLL","CAB32.DLL","TAR32.DLL", "BGA32.DLL","YZ1.DLL", "JACK32.DLL"};

	char getver_api[SUPPORT_DLL_NUM+1][24] = 
	{
		"",
		"UnlhaGetVersion",
		"", //UNZIP32.
		"ZipGetVersion",
		"CabGetVersion",
		"TarGetVersion",
		"BgaGetVersion",
		"Yz1GetVersion",
		"JackGetVersion"
	};

	char expstr_api[SUPPORT_DLL_NUM+1][24] = 
	{
		"",
		".lzh",
		"", //UNZIP32.
		".zip",
		".cab",
		".tar",
		".?za",
		".yz1",
		".jak"
	};

	for(int i=1; i<=SUPPORT_DLL_NUM; i++){
		hInstDll = LoadLibrary( dllname[i] );
		if(hInstDll != NULL)
		{
			PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstDll, getver_api[i]);
			if(GetVer != NULL) // API function ready...
				tmpver = (int)(*GetVer)();
			else
				tmpver = 0;
		}else{
			tmpver = 0;
		}
				
		if(tmpver != 0){
			wsprintf(tmpbuf,"\n OK) %s\t............ %-12s \t Ver.%d.%02d", expstr_api[i], dllname[i], tmpver/100, tmpver%100);
			if(i == SUPPORT_DLL_NUM) //JACK32.DLL?
				strncat(msgbuf, "\n", BUF_LEN);
				
			if(i == 3) //if ZIP32J.DLL
			{
				hInstDll = LoadLibrary("ZIP32.DLL");
				if(hInstDll != NULL) strncat(tmpbuf,"\n\t\t+ included ZIP32.DLL.", BUF_LEN);
				else{
					hInstDll = LoadLibrary("IZIP32J.DLL");
					if(hInstDll != NULL){
						strncat(tmpbuf,"\n\t\t+ included IZIP32J.DLL.", BUF_LEN);
						hInstSubDll = LoadLibrary("ZCRYPT32.DLL");
						if(hInstSubDll != NULL)
							strncat(tmpbuf,"\n\t\t+ included ZCRYPT32.DLL.", BUF_LEN);
						else
							strncat(tmpbuf,"\n\t\t+ not found ZCRYPT32.DLL...", BUF_LEN);
					}else
						wsprintf(tmpbuf,"\n NG) %s\t............ %-12s \t Ver.%d.%02d\n\t\t+ without ZIP32.DLL, please setup.", expstr_api[i], dllname[i], tmpver/100, tmpver%100);
				}
			}
			strncat(msgbuf, tmpbuf, BUF_LEN);
		}else{
			if(i!=2){ //UNZIP not supported...
				wsprintf(tmpbuf,"\n NG) %s\t............ %-12s \t Ver.-.--", expstr_api[i], dllname[i]);
				strncat(msgbuf, tmpbuf, BUF_LEN);
			}
		}
	}
	strncat(sVerInfo,msgbuf , MSGBOX_LEN);
	
	delete [] tmpbuf;
	delete [] msgbuf;
}

void VerInfoDialog(const HWND hWnd)
{
	char *buf = new char[MSGBOX_LEN];
	char *msg = new char[MSGBOX_LEN];
	UINT CodePage;

	InicfgToMemcfg();
	if(get_autolang()==true)
		CodePage = GetACP();
	else CodePage = 9999; //dummy.

	if(CodePage==IDS_STR_JPN_CODEPAGE)
	{ //Japanese
		LoadString(get_dll_instance(), IDS_STR_VERINFO_MSG+IDS_STR_ADD_FORJPN,buf,1024);
	}else{
		LoadString(get_dll_instance(), IDS_STR_VERINFO_MSG                   ,buf,1024);
	}
	wsprintf(msg, 
		"Frostice.mxd Ver.%d.%02d.%d (MXD Protocol v%d.%02d.%d)\n"
		" Copyright (C)2001-2002 ardry, Project Meltice.\n\n%s",
		MXDVER/1000, (MXDVER%1000)/10, MXDVER%10,	// mxd ver.
		MXD_PROTOCOL_VER/1000, (MXD_PROTOCOL_VER%1000)/10, MXD_PROTOCOL_VER%10, buf);
														// MXD Protocol ver.

	AddDLLVerInfo(msg); //DLL Version Info...
	
	MessageBox(hWnd, msg,
		"Frostice for Windows", 
		MB_ICONINFORMATION);
	
	delete [] msg;
	delete [] buf;
}

EXPORT bool WINAPI MxdConfigDialog(const HWND hWnd, LPSTR, const int iMode)
{
	if(iMode==0)
	{
		VerInfoDialog(hWnd);
	}else if(iMode==2){ //PackMenu
		UINT CodePage;

		InicfgToMemcfg();
		if(get_autolang()==true)
			CodePage = GetACP();
		else CodePage = 9999; //dummy.

		int mbret;

		set_destfile(DUMMYMSG_FOR_CONFIG,MAX_PATH); //DUMMY for Condig Dialog.
		if(CodePage==IDS_STR_JPN_CODEPAGE){ //Japanese
			mbret = DialogBox(hInstance, "IDD_DLG_FLTC_JP", NULL, (DLGPROC)FTCCNFDLGProc);
		}else{
			mbret = DialogBox(hInstance, "IDD_DLG_FLTC", NULL, (DLGPROC)FTCCNFDLGProc);
		}
		return false;
	}else{
		return false;
	}
	return false; // No config...
}


//Check Archive.
EXPORT bool WINAPI MxdCheckArchive(const char * /*filename*/)
{
	return false; //Not Supported.
}

EXPORT bool  WINAPI MxdUnpackArchive(const char * /*filename*/,const char * /*outputdir*/)
{
	return false; //Not Supported.
}

//////////////////////////////////////////////////////////////////////////
// Open Folder by Explorer/etc. (Base = D_COOKFL.CPP@Meltice.exe)
static bool open_folder(const char *outputdir, int sw)
{
	DWORD fa;
	fa = GetFileAttributes(outputdir);
	if(fa & FILE_ATTRIBUTE_DIRECTORY){ //Folder.
		char *buf = new char[MAX_PATH*4+1];
		char *opdirpath = new char[MAX_PATH+1]; // Open Folder Path.
		get_opdirex(opdirpath, MAX_PATH, sw);
// 		wsprintf(buf,"%s \"%s\"", opdirpath, outputdir); // Original (Meltice.exe)
 		wsprintf(buf,"%s %s", opdirpath, outputdir); // DesignChange (Frostice.mxd)
		WinExec(buf, SW_SHOW);
		delete [] opdirpath;
		delete [] buf;
		return true;
	}else{
		//open error...
		return false;
	}
}

// for MxdPackArchive and mxd internal func (DnD support...).
bool PackArchive(const char * filenames,const char * basedir)
{
	char *buf = new char[2048];
	char *packedfile = new char[2048];
	char *destdir = new char[MAX_PATH];

	//Dialog...
	UINT CodePage;
	if(get_autolang()==true)
		CodePage = GetACP();
	else CodePage = 9999; //dummy.

	int mbret = IDCANCEL;
	//Dest to Exp...
	int mode;
	mode = get_destexpcode(); //mode 1 = lzh, 2 = zip, ...

	Split1stFilenames(buf,filenames);
	CutExp_fromFileName(buf);
	set_destfile(buf,MAX_PATH);

	if(get_smplgui()==true)
	{
		mbret = IDOK; //Dialog is passed.
	}else if(CodePage==IDS_STR_JPN_CODEPAGE){ //Japanese
		mbret = DialogBox(hInstance, "IDD_DLG_FLTC_JP", NULL, (DLGPROC)FTCCNFDLGProc);
	}else{
		mbret = DialogBox(hInstance, "IDD_DLG_FLTC", NULL, (DLGPROC)FTCCNFDLGProc);
	}
	if(mbret == IDCANCEL)
	{
		delete [] buf;
		delete [] packedfile;
		delete [] destdir;
		return false;
	}else if(mbret == IDOK)
	{	

		//DestDir.
		if(get_samedir(0)==true){
			lstrcpyn(destdir,basedir,MAX_PATH);
		}else{
			get_destdir(buf, MAX_PATH, 0);
			Path_Add_Backslash(buf);
			wsprintf(destdir,"\"%s\" ",buf); //format ["destdirname\" ].
		}
		mode = get_destexpcode(); //mode 1 = lzh, 2 = zip, ...
		get_destfile(buf,MAX_PATH);

		wsprintf(packedfile,"%s.%s",buf,pack_to_exp[mode]);

		char sfxmsg[8];
		if(get_withsfx() == true) lstrcpy(sfxmsg,"(SFX)");
		else lstrcpy(sfxmsg," ");

		if ( ardll_frost(0,packedfile,filenames,basedir,destdir,mode) == 0)
		{
			if(get_opendir(0) == true) open_folder(destdir,0);
		}
	}
	delete [] buf;
	delete [] packedfile;
	delete [] destdir;
	return true;
}

EXPORT bool WINAPI MxdPackArchive(const char * filenames,const char * basedir)
{
	InicfgToMemcfg();
	return PackArchive(filenames, basedir);
}
