///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// U_STRING.CPP = Utility group / STRING processing utilities.
///////////////////////////////////////////////////////////////////////////////
// $Id: U_STRING.CPP,v 1.4 2001/07/22 18:44:02 ardry Exp $ 
///////////////////////////////////////////////////////////////////////////////

#include	<windows.h>


//-----------------------------------------------------------------------------
// Path_Add_Backslash Function.
// Path_Remove_Backslash Function.
//
// (Compatible PathAddBackslash() and PathAddBackslash() API, not use 
// shlwapi.dll.   for Windows 95 OSR1, and Windows without MSIE user!)
//

// #include	<shlwapi.h> // needs shlwapi.lib for PathAddBackslash

char *Path_Add_Backslash(char *lpszPath)
{
	char *p; p = lpszPath;
	return (*CharPrev( p,p+lstrlen(p) )=='\\' ? p : lstrcat(p,"\\"));
//	return PathAddBackslash(lpszPath);
}

char *Path_Remove_Backslash(char *lpszPath)
{
	int iLastBs=0; //'\\' Last Backslash flag.
	int iBsHeaven=0; // '\\ \\ \\ \\ ..." Count.
	//C:\ -> return C:\ (not "c:" !)
	if(lstrlen(lpszPath) <= 3) return lpszPath;

	Path_Add_Backslash(lpszPath);

	for(int i=0;i<lstrlen(lpszPath);i++)
	{
		if(*(lpszPath+i) == '\\')
		{
			iLastBs=i;
			iBsHeaven++;
		}else{
			iBsHeaven=0;
		}
		
		if(IsDBCSLeadByte(*(lpszPath+i))==1)
		{
			iBsHeaven=0;
			i++; // i+=2!
		}
	}
	
	lstrcpyn(lpszPath,lpszPath,iLastBs-iBsHeaven+2); //+2 -> NULL BYTE + (-1[forHeaven])

	return lpszPath;
//	return PathRemoveBackslash(lpszPath);
}



//String check for filename with bad character.
// by string.c (original: WWWC source code.)
int BadNameCheck(char *buf)
{
	char *p;

	p = buf;

	while(*p != '\0'){
		if(IsDBCSLeadByte((BYTE)*p) == FALSE){
			//if bad character(not 2byte code) then return false.
			if(	*p == '\\'||
				*p == '/' ||
				*p == ':' ||
				*p == ',' ||
				*p == ';' ||
				*p == '*' ||
				*p == '?' ||
				*p == '\"'||
				*p == '<' ||
				*p == '>' ||
				*p == '|'){

				return FALSE;
			}
		}else{
			//2byte code
			p++;
		}
		p++;
	}
	return TRUE;
}

//bad character convert to noprobrem character for filename.
// by string.c (original: WWWC source code.)
void BadNameCheckConv(char *buf, char NewChar)
{
	char *p;

	p = buf;

	while(*p != '\0'){
		if(IsDBCSLeadByte((BYTE)*p) == FALSE){
			//if badchar then convert to indication character.
			if(	*p == '\\'||
				*p == '/' ||
				*p == ':' ||
				*p == ',' ||
				*p == ';' ||
				*p == '*' ||
				*p == '?' ||
				*p == '\"'||
				*p == '<' ||
				*p == '>' ||
				*p == '|'){

				*p = NewChar;
			}
		}else{
			//2byte code
			p++;
		}
		p++;
	}
}


//-----------------------------------------------------------------------------
// PATH -> 1st directory path Function.
//
// abcde\fghi\jklm.lno -> abcde
char *get1stDirName(char *lpszPath)
{
	char *lpszPtr = lpszPath;
	char *lpszOrgPtr = lpszPath;

	while(*lpszPtr != '\0'){
		//skiped for 2byte(left) character 
		if(IsDBCSLeadByte(*lpszPtr) == 0){
			//if [\],[/],[:] found, overwrite.
			if( (*lpszPtr == '\\') || (*lpszPtr == '/') ){
				*lpszPtr = '\0';
				break;
			}
		}
		//next character.
		lpszPtr=CharNext(lpszPtr);
	}
	
	lpszPath = lpszOrgPtr;

	return lpszPath;
}


//-----------------------------------------------------------------------------
// PATH -> FILENAME Function.
//
// C:\HOGEHOGE\FOOBAR.TXT -> FOOBAR.TXT
//
char *getFileName(char *lpszPath)
{
	char *lpszPtr = lpszPath;

	while(*lpszPtr != '\0'){
		//skiped for 2byte(left) character 
		if(IsDBCSLeadByte(*lpszPtr) == 0){
			//if [\],[/],[:] found, save current+1 pointer.
			if( (*lpszPtr == '\\') || (*lpszPtr == '/') || (*lpszPtr == ':')
			  ||(*lpszPtr ==  ';') || (*lpszPtr == ',') || (*lpszPtr == '*')
			  ||(*lpszPtr ==  '\"') || (*lpszPtr == '<') || (*lpszPtr == '?')
			  ||(*lpszPtr ==  '>') ){
				lpszPath=lpszPtr+1;
			}
		}
		//next character.
		lpszPtr=CharNext(lpszPtr);
	}
	
	return lpszPath;
}

//-----------------------------------------------------------------------------
// PATH -> EXPNAME Function.
//
// C:\HOGEHOGE\FOOBAR.TXT -> TXT
//
// You may call getFileName() function before this Function.

char *getExpName(char *lpszPath)
{
	char *lpszPtr = lpszPath;

	while(*lpszPtr != '\0'){
		//skiped for 2byte(left) character 
		if(IsDBCSLeadByte(*lpszPtr) == 0){
			//if [\],[/],[:] found, save current+1 pointer.
			if( *lpszPtr == '.' ){
				lpszPath=lpszPtr+1;
			}
		}
		//next character.
		lpszPtr=CharNext(lpszPtr);
	}
	return lpszPath;
}

//-----------------------------------------------------------------------------
// FILENAME.EXP -> FILENAME Function.
//
// FOOBAR.TXT -> FOOBAR
//
// You may call getFileName() function before this Function.
char *CutExp_fromFileName(char *lpszPath)
{
	char lpszStr[MAX_PATH];
	lstrcpyn(lpszStr,lpszPath,MAX_PATH);
	int iLastDot=lstrlen(lpszPath);

	for(int i=0;i<lstrlen(lpszStr); i++){
		if(lpszStr[i] == '.'){
			iLastDot = i;
		}
	}
	
	lstrcpyn(lpszPath,lpszStr,iLastDot+1);
	return lpszPath;
}

//-----------------------------------------------------------------------------
// FILE1234 -> FILE Function.
//
// FOOBAR12 -> FOOBAR
//
// You may call CutExp_fromFileName() function before this Function.
char *CutNum_fromNoExpFileName(char *lpszPath)
{
	char lpszStr[MAX_PATH];
	lstrcpyn(lpszStr,lpszPath,MAX_PATH);

	int iLastNum=lstrlen(lpszStr);; //'0-9' Last Number flag.
	int iNumHeaven=0; // '1 2 3 4 5 6 ..." LastNumber Count.

	for(int i=0;i<lstrlen(lpszStr);i++)
	{
		if( (lpszStr[i] >= '0' && lpszStr[i] <= '9') 
			|| lpszStr[i] == '-'
			|| lpszStr[i] == '_'
			|| lpszStr[i] == '.' )
		{
			iLastNum=i;
			iNumHeaven++;
		}else{
			iNumHeaven=0;
			iLastNum=lstrlen(lpszStr); //iLastNum must be reset,
		}
		
		if(IsDBCSLeadByte(lpszStr[i])==1)
		{
			iNumHeaven=0;
			i++; // i+=2!
		}
	}
	
	lstrcpyn(lpszStr,lpszStr,iLastNum-iNumHeaven+2); //+2 -> NULL BYTE + (-1[forHeaven])

	if(lstrlen(lpszStr) == 0){return lpszPath;}
	lstrcpyn(lpszPath,lpszStr,MAX_PATH);
	return lpszPath;
}


//-----------------------------------------------------------------------------
// PATH -> DIRNAME Function.
//
// C:\HOGEHOGE\FOOBAR.TXT -> C:\HOGEHOGE\  
//

char *getDirName(char *lpszPath)
{
	char *lpszPtr = lpszPath;
	char *lpszOrgPtr = lpszPath;   //original pointer address.
	char *lpszFinalPtr = lpszPath; //pointer for final \\ save address.
	

	while(*lpszPtr != '\0'){
		//skiped for 2byte(left) character 
		if(IsDBCSLeadByte(*lpszPtr) == 0){
			//if [\],[/] found, save current pointer.
			if( (*lpszPtr == '\\') || (*lpszPtr == '/') ){
				lpszFinalPtr = lpszPtr;
			}
		}
		//next character.
		lpszPtr=CharNext(lpszPtr);
	}
	
	*lpszFinalPtr = '\0'; // final \\ pointer overwrited.
	lpszPath = lpszOrgPtr;
	Path_Add_Backslash(lpszPath);

	return lpszPath;
}

//-----------------------------------------------------------------------------
// Split1stFilenames function.
//
// filenames <- [ "abcd.lzh" "efgh.zip" "ijkl.txt" ]
// singlefile <- (Buffer, NULL Str.)
//
// ret -> abcd.lzh
//////
// ex2. "abcd\*.*" "efgh.zip" -> ret: abcd
//
char *Split1stFilenames(char *singlefile, const char *filenames)
{
	char *tmpbuf = new char[lstrlen(filenames)];
	lstrcpyn(tmpbuf,filenames,lstrlen(filenames));
	
	int iFastDblqt=-1;

	for(int i=0;i<lstrlen(tmpbuf);i++)
	{
		if(IsDBCSLeadByte(*(tmpbuf+i))==1)
		{
			i++; // i+=2!
		}else if(*(tmpbuf+i) == '\"' || *(tmpbuf+i) == '\\')
		{
			if(iFastDblqt == -1)
			{
				iFastDblqt=i;
			}else{
				*(tmpbuf+i) = '\0';
			}
		}
		
	}
	lstrcpy(singlefile,(tmpbuf+iFastDblqt+1));
	delete [] tmpbuf;
	return singlefile;
}


//-----------------------------------------------------------------------------
// init_newchr()
//
//
void init_newchr(char *str, int strlen)
{
	for(int i=0; i< strlen; i++)
		*(str+i) = 0;
}
