; Live Paint?
; $Id: live-paint.scm,v 1.1 2006/06/01 06:46:08 torus Exp $

(add-load-path "../lib")

(use srfi-1)
(use srfi-11)
(use util.stream)

(use gauche.sequence)
(use gauche.collection)
(use gauche.threads)

(use gl)
(use gl.glut)
(use gl.math3d)

(use mephisto.constraint)
(use mephisto.stream)
(use mephisto.animation)
(use mephisto.animation.util)
(use mephisto.model)
(use mephisto.picture)

(load "./paint-primitives")

;;;;;;;;;;

(define *new-streams* '(x))

(define (marge-live-streams streams)
    (let1 new-streams (append (cdr *new-streams*) streams)
      (set-cdr! *new-streams* '())
      (let ((next-procs (map stream-car new-streams))
	    (next-streams (remove (lambda (s) (stream-null? s))
				  (map stream-cdr new-streams))))
	(stream-cons next-procs
		     (marge-live-streams next-streams)))))

(define (make-live-stream)
  (stream-map (lambda (t lst)
		(cons t
		      (lambda ()
			(for-each (lambda (x) (x))
				  lst))))
	      (make-time-stream)
	      (marge-live-streams '())))

(define (procedure-stream proc)
  (cons-stream proc (procedure-stream proc)))

(define (main args)
  (mephisto-add-cut! (make-live-stream))

  (glut-init args)
  (glut-init-display-mode (logior GLUT_DOUBLE GLUT_DEPTH GLUT_RGB))

  (glut-init-window-size 800 600)
  (glut-init-window-position 0 0)
  (glut-create-window "MEPHISTO DEMO")
  (mephisto-init!)

  ;; WiLiKi  Shiro ν񤭹ߤꡣ
  (thread-start! (make-thread (lambda () (read-eval-print-loop))))
  (while #t
    (guard (e (else (report-error e) (exit 1)))
	   (glut-main-loop)))
;;   (glut-main-loop)

  0)

(define (append-painter-streams! . strms)
  (append! *new-streams* strms)
  'ok)

;;
;; EXAMPLES
;;

#|
;; An expanding tea pot!

(define-wires count p1 p2)

(attach-constraint!
 (count => p1)
 (/ (remainder count 30) 3))

(wires-set-value! (p1 3))

(append-painter-streams!
 (procedure-stream
  (lambda/constraint
   (p1)
   (glut-solid-teapot p1))))

(append-painter-streams!
 (stream-map (lambda (x)
	       x
	       (lambda ()
		 (wires-set-value! (count x))))
	     (make-time-stream)))

((p1 'reset))

|#

#|
(load "./live-paint")

(main '())

(define-wires count x y)

(append-painter-streams!
 (stream-map (lambda (x)
	       x
	       (lambda ()
		 (wires-set-value! (count x))))
	     (make-time-stream)))

(append-painter-streams!
 (procedure-stream
  (move-to (point4f -15 10 0)
	   (paint-yellow
	    (char-painter GLUT_BITMAP_HELVETICA_18 "MEPHISTO on Gauche.")))
 ))

(attach-constraint!
 (count => x)
 (* 10 (cos (/ count 30)))
 )

(attach-constraint!
 (count => y)
 (* 10 (sin (/ count 100)))
 )

(append-painter-streams!
 (procedure-stream
  (lambda/constraint
   (x y)
   ((move-to (point4f (* x 1.5) (* 0.5 y) -2)
	     (paint-red cube))))
 ))

(append-painter-streams!
 (procedure-stream
  (lambda/constraint
   (x y)
   ((move-to (point4f (+ x 1.5) (* 0.5 y) -2)
	     (char-painter GLUT_BITMAP_HELVETICA_10 #`"x = ,x y = ,y"))))
 ))

|#

#|
(load "./live-paint")

(main '())

(define-wires count ux uy n o)

;; ե졼५󥿤ꡣ
(append-painter-streams!
 (stream-map (lambda (x)
	       (lambda ()
		 (wires-set-value! (count x))))
	     (make-time-stream)))

;; ŬͤƤ
(wires-set-value! (ux (vector4f 1 0 0))
		  (uy (vector4f 0 1 0))
		  (n 5)
		  (o (point4f 0 0 0)))

;; ¿ѷη cube ֤롣
(append-painter-streams!
 (procedure-stream
  (lambda/constraint
   (ux uy n o)
   (let ((radius 10))
     (let loop ((i n))
       (unless (zero? i)
	 (let ((angle (/ (* 2 PI i) n)))
	   ((move-to (point4f-add (point4f-add o (vector4f-scale ux (* (cos angle) radius)))
				  (vector4f-scale uy (* (sin angle) radius)))
		     cube))
	   (loop (- i 1)))))))))

;; ¿ѷδ٥ȥ count ˤäѲ롣
(attach-constraint!
 (count => ux)
 (let1 angle (/ count 10)
   (vector4f-add (vector4f-scale (vector4f 1 0 0) (cos angle))
		 (vector4f-scale (vector4f 0 0 1) (sin angle)))))

;; ư褦ˡäꥻåȡ
(wire-reset! ux)

(attach-constraint!
 (count => uy)
 (let1 angle (/ count 30)
   (vector4f-add (vector4f-scale (vector4f 0 1 0) (cos angle))
		 (vector4f-scale (vector4f 0 0 1) (sin angle)))))

(wire-reset! uy)

;; ¿ѷγѤοѤƤߤ롣
(wire-set-value! n 30)

;; Ѥο count ˤäѲ롣
(attach-constraint!
 (count => n)
 (remainder (quotient count 30) 20))

(wire-reset! n)

;; դƤߤ롣
(define-wires r g b)

(append-painter-streams!
 (procedure-stream
  (lambda/constraint
   (r g b)
   ((paint-color (lambda ()) r g b)))))

(wires-set-value! (r 0)
		  (g 1)
		  (b 1))

;; ǿǤ褦ˤ롣
;; 0 <= hue < 3
;; rgb = (list r g b)
(define-wires rgb hue)

(attach-constraint!
 (hue => rgb)
 (cond ((< hue 1)
	(list (- 1 hue) hue 1))
       ((< hue 2)
	(list 1 (- hue 1) (- 2 hue)))
       ((< hue 3)
	(list (- 3 hue) 1 (- hue 2)))
       (else
	#f)))

(attach-constraint!
 (rgb => r)
 (ref rgb 0))

(attach-constraint!
 (rgb => g)
 (ref rgb 1))

(attach-constraint!
 (rgb => b)
 (ref rgb 2))

;; ŬͤƤߤ롣
(wires-set-value! (hue 1.2))

(wire-reset! r)
(wire-reset! g)
(wire-reset! b)

;;  count ˤäѲ롣
(attach-constraint!
 (count => hue)
 (/ (remainder count 300) 100))

|#
