;; Drowing font sample with live-paint
;; $Id: live-font.scm,v 1.1 2006/06/04 09:17:21 torus Exp $

(load "./live-paint")

;; If you are in the Emacs, run the main procedure now to get into the
;; interactive environment.

;(main '())

(define-wires count x y)

(append-painter-streams!
 (stream-map (lambda (x)
	       x
	       (lambda ()
		 (wires-set-value! (count x))))
	     (make-time-stream)))

(append-painter-streams!
 (procedure-stream
  (move-to (point4f -15 10 0)
	   (paint-yellow
	    (char-painter GLUT_BITMAP_HELVETICA_18 "MEPHISTO on Gauche.")))
 ))

(attach-constraint!
 (count => x)
 (* 10 (cos (/ count 30)))
 )

(attach-constraint!
 (count => y)
 (* 10 (sin (/ count 100)))
 )

(append-painter-streams!
 (procedure-stream
  (lambda/constraint
   (x y)
   ((move-to (point4f (* x 1.5) (* 0.5 y) -2)
	     (paint-red cube))))
 ))

(append-painter-streams!
 (procedure-stream
  (lambda/constraint
   (x y)
   ((move-to (point4f (+ x 1.5) (* 0.5 y) -2)
	     (char-painter GLUT_BITMAP_HELVETICA_10 #`"x = ,x y = ,y"))))
 ))
