;; Simple model data importer
;; $Id: model.scm,v 1.4 2006/06/01 06:36:56 torus Exp $

(define-module mephisto.model
  (use srfi-13)

  (use util.match)
  (use gauche.charconv)
  (use gauche.sequence)
  (use gl)
  (use gl.glut)

  (export read-obj-model)
)

(select-module mephisto.model)

(define (read-obj-model path)
  (let ((vertices '(v))
	(polygons '(p))
	)
    (define (add-vertex! v) (append! vertices (list v)))
    (define (add-polygon! p) (append! polygons (list p)))
    (define (switch-group! g) #f)

    (with-input-from-file path
      (lambda ()
	(port-for-each
	 (lambda (line)
	   (let1 line (string-trim-right
		       (or (string-scan line #\# 'before) line))
	     (unless (string=? line "")
	       (match (string-tokenize line)
		      (("v" coord ...)
		       (add-vertex! (list->point4f (map obj-value->number coord))))
;; 		      (("vn" coord ...)
;; 		       (add-normal! (list->vector4f (map obj-value->number coord))))
;; 		      (("vt" coord ...)
;; 		       (add-uv! (map obj-value->number coord)))
		      (("f" vtx ...)
		       (add-polygon!
			(map (lambda (s)
			       (map (lambda (t) (obj-value->number t))
				    (string-split s #\/)))
			     vtx)
			))
		      (("g" group-name)
		       (switch-group! group-name))
		      ((sym args ...)
		       #f
		       )
		      ))
	     ))
	 read-line)) :encoding "shift_jis")

    (lambda ()
      (map (lambda (poly)
	     (let1 poly (map (cut ref <> 0) poly)
	       (gl-normal
		(vector4f-normalize
		 (vector4f-cross
		  (point4f-sub (ref vertices (ref poly 1)) (ref vertices (ref poly 0)))
		  (point4f-sub (ref vertices (ref poly 2)) (ref vertices (ref poly 1)))
		  )))
	       (gl-begin GL_POLYGON)
	       (map (lambda (i)
		      (gl-vertex (ref vertices i)))
		    poly)
	       (gl-end)))
	   (cdr polygons))
      )
    )
  )

(define (obj-value->number x)
  (with-input-from-string x read))

(provide "mephisto.model")
