// lexer.h cK\̎
#ifndef __MERCURY_LEXER__
#define __MERCURY_LEXER__


namespace mercury
{
	namespace _regex
	{
		// g[N̎
		typedef enum tagTOKEN_KIND
		{
			TOKEN_CHARACTER,                        // ʏ̕
			TOKEN_OP_UNION,                         // aWZ
			TOKEN_OP_LOOP,                          // Z
			TOKEN_GROUP_BEGIN,                      // O[vJn
			TOKEN_GROUP_END,                        // O[vI
			TOKEN_EOF,                              // EOF
		} TOKEN_KIND;


		// g[N\
		template<typename _Char>
		struct token
		{
			token(void) { kind = TOKEN_CHARACTER; value = _Char(0); }
			token(const TOKEN_KIND k, const _Char v) { kind = k; value = v; }
			TOKEN_KIND kind;
			_Char      value;
		};

		template<typename _Char>
		class token_traits
		{
		public:
			enum
			{
				ESCAPE      = _Char('\\'),
				UNION       = _Char('|' ),
				LOOP        = _Char('*' ),
				GROUP_BEGIN = _Char('('),
				GROUP_END   = _Char(')'),
			};
		};

		// 
		template<typename _Char, typename _ConstIterator, typename _Traits = token_traits<_Char> >
		class lexer
		{
		public:
			// RXgN^iwj
			lexer(_ConstIterator pattern_begin, _ConstIterator pattern_end)
				: m_pattern_begin(pattern_begin), m_pattern_end(pattern_end)
			{
				_init(pattern_begin, pattern_end);
			}


			token<_Char> get_token(void)
			{
				// ̏I[
				if(m_now == m_pattern_end)
				{
					return token<_Char>(TOKEN_EOF, _Char(0));
				}

				const _Char ch = *m_now++;
				token<_Char> tk(TOKEN_CHARACTER, ch);
				switch(ch)
				{
				case _Traits::ESCAPE:        // GXP[v
					if(m_now != m_pattern_end)
					{
						tk.value = *m_now++;
					}
					break;
				case _Traits::UNION:
					tk.kind = TOKEN_OP_UNION;
					break;
				case _Traits::LOOP:
					tk.kind = TOKEN_OP_LOOP;
					break;
				case _Traits::GROUP_BEGIN:
					tk.kind = TOKEN_GROUP_BEGIN;
					break;
				case _Traits::GROUP_END:
					tk.kind = TOKEN_GROUP_END;
					break;
				}
				return tk;
			}

		private:
			_ConstIterator m_pattern_begin;
			_ConstIterator m_pattern_end;
			_ConstIterator m_now;

			// 
			void _init(_ConstIterator begin, _ConstIterator end)
			{
				m_now = begin;
			}
		};
	}
}

#endif // __MERCURY_LEXER__
