// regex_syntax_node.h cK\p̍\
#ifndef __MERCURY_REGEX_SYNTAX_NODE__
#define __MERCURY_REGEX_SYNTAX_NODE__

#include <list>
#include <cstdarg>
#include "../syntax_node.h"


namespace mercury
{
	namespace _regex
	{
		////////////////////////////////////////////////////////////////////////////////
		// characterm[hij
		template<typename _Input, _Input _Epsilon = _Input(0)>
		class syntax_node_character : public syntax_node<_Input, _Epsilon>
		{
		public:
			syntax_node_character(const _Input &character) : m_character(character)
			{
			}

			// NFA\z
			nfa<_Input, _Epsilon> build_nfa(state_t &state)
			{
				state_t start  = state++;
				state_t accept = state++;

				// m_characteȓJڂɂ
				nfa<_Input, _Epsilon> frag(start);
				frag.connect(start, m_character, accept);
				frag.add_accept(accept);

				return frag;
			}

			// J
			void free(void)
			{
				delete this;
			}

		private:
			_Input m_character;
		};


		////////////////////////////////////////////////////////////////////////////////
		// unioni_aj
		template<typename _Input, _Input _Epsilon = _Input(0)>
		class syntax_node_union : public syntax_node<_Input, _Epsilon>
		{
		public:
			syntax_node_union(syntax_node<_Input, _Epsilon> *node, ...)
			{
				va_list ap;
				va_start(ap, node);

				syntax_node_ptr_t arg = NULL;
				m_nodes.push_back(node);
				while((arg = va_arg(ap, syntax_node_ptr_t)) != NULL)
				{
					m_nodes.push_back(arg);
				}
				va_end(ap);
			}

			// NFA\z
			nfa<_Input, _Epsilon> build_nfa(state_t &state)
			{
				const state_t start = state++;
				nfa<_Input, _Epsilon> frag(start);

				for(syntax_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					nfa<_Input, _Epsilon> frag_x = (*p)->build_nfa(state);

					// Jڃ}bvƎeԂ}[W
					frag.merge_transition(frag_x);
					frag.merge_acccepts  (frag_x);

					// frag̊JnԂfrag_x̊JnԂɃÑJ
					frag.connect(start, _Epsilon, frag_x.get_start());
				}
				return frag;
			}

			// J
			void free(void)
			{
				// qm[hSĉAg
				for(syntax_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					syntax_node_ptr_t node = *p;
					node->free();
				}
				delete this;
			}

		private:
			typedef syntax_node<_Input, _Epsilon>                  *syntax_node_ptr_t;
			typedef std::list<syntax_node_ptr_t>                    syntax_node_ptr_list_t;
			typedef typename syntax_node_ptr_list_t::const_iterator syntax_node_ptr_list_const_iterator_t;
			syntax_node_ptr_list_t m_nodes;
		};


		////////////////////////////////////////////////////////////////////////////////
		// concatenateiAj
		template<typename _Input, _Input _Epsilon = _Input(0)>
		class syntax_node_concatenate : public syntax_node<_Input, _Epsilon>
		{
		public:
			syntax_node_concatenate(syntax_node<_Input, _Epsilon> *node, ...)
			{
				va_list ap;
				va_start(ap, node);

				syntax_node_ptr_t arg = NULL;
				m_nodes.push_back(node);
				while((arg = va_arg(ap, syntax_node_ptr_t)) != NULL)
				{
					m_nodes.push_back(arg);
				}
				va_end(ap);
			}

			// NFA\z
			nfa<_Input, _Epsilon> build_nfa(state_t &state)
			{
				// JnԂeԂփÑJڂA_~[NFA쐬
				const state_t start  = state++;
				const state_t accept = state++;
				nfa<_Input, _Epsilon> frag(start);
				frag.add_accept(accept);
				frag.connect(start, _Epsilon, accept);

				for(syntax_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					nfa<_Input, _Epsilon> frag_x = (*p)->build_nfa(state);

					// frag̎eԂfrag_x̊JnԂփÑJ
					const state_set_t accepts = frag.get_accepts();
					for(state_set_t::const_iterator p2 = accepts.begin(); p2 != accepts.end(); p2++)
					{
						frag.connect(*p2, _Epsilon, frag_x.get_start());
					}

					// Jڃ}bv}[W
					frag.merge_transition(frag_x);

					// frag̎eԂfrag_x̎eԂɂ
					frag.set_accepts(frag_x.get_accepts());
				}
				return frag;
			}

			// J
			void free(void)
			{
				// qm[hSĉAg
				for(syntax_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					syntax_node_ptr_t node = *p;
					node->free();
				}
				delete this;
			}

		private:
			typedef syntax_node<_Input, _Epsilon>                  *syntax_node_ptr_t;
			typedef std::list<syntax_node_ptr_t>                    syntax_node_ptr_list_t;
			typedef typename syntax_node_ptr_list_t::const_iterator syntax_node_ptr_list_const_iterator_t;
			syntax_node_ptr_list_t m_nodes;
		};


		////////////////////////////////////////////////////////////////////////////////
		// loopi0ȏ̌JԂj
		template<typename _Input, _Input _Epsilon = _Input(0)>
		class syntax_node_loop : public syntax_node<_Input, _Epsilon>
		{
		public:
			syntax_node_loop(syntax_node<_Input, _Epsilon> *node)
			{
				m_node = node;
			}

			// NFA\z
			nfa<_Input, _Epsilon> build_nfa(state_t &state)
			{
				nfa<_Input, _Epsilon> frag = m_node->build_nfa(state);

				// eԂJnԂփÑJ
				const state_t     start   = frag.get_start();
				const state_set_t accepts = frag.get_accepts();
				for(state_set_t::const_iterator p = accepts.begin(); p != accepts.end(); p++)
				{
					frag.connect(*p, _Epsilon, start);
				}

				// 0̌JԂ邽߁AstarteԂɉ
				frag.add_accept(start);
				return frag;
			}

			// J
			void free(void)
			{
				m_node->free();
				delete this;
			}

		private:
			syntax_node<_Input, _Epsilon> *m_node;
		};
	}
}

#endif // __MERCURY_REGEX_SYNTAX_NODE__
