// syntaxer.h cK\̍\
#ifndef __MERCURY_SYNTAXER__
#define __MERCURY_SYNTAXER__

#include "regex_syntax_node.h"
#include "lexer.h"


namespace mercury
{
	namespace _regex
	{
		////////////////////////////////////////////////////////////////////////////////
		// \
		// ȉŒ`镶R@ɂA\͂
		//  expression     subexpression EOF
		//  subexpression  sequence '|' subexpression | sequence
		//  sequence       subsequence | ''
		//  subsequence    loop subsequence | loop
		//  loop           factor '*' | factor
		//  factor         '(' subexpression ')' | CHARACTER

		template<typename _Input, typename _ConstIterator, typename _Traits = token_traits<_Input>, _Input _Epsilon = _Input(0)>
		class syntaxer
		{
		public:
			enum
			{
				SYERR_SYNTAXERROR,
			};

			typedef syntax_node<_Input, _Epsilon> *syntax_node_ptr;

		public:
			// RXgN^iwj
			syntaxer(_ConstIterator pattern_begin, _ConstIterator pattern_end) : m_lexer(pattern_begin, pattern_end)
			{
				_init(pattern_begin, pattern_end);
			}

			// ͂A\؂쐬
			syntax_node_ptr parse(void)
			{
				// \؂쐬
				return rule_expression();
			}

		private:
			lexer<_Input, _ConstIterator, _Traits> m_lexer;
			token<_Input>                          m_lookahead;

		private:
			// R@[

			// expression -> subexpression EOF
			syntax_node_ptr rule_expression(void)
			{
				// expression -> subexpression EOF
				syntax_node_ptr node = rule_subexpression();
				move(TOKEN_EOF);
				return node;
			}

			// subexpression -> sequence '|' subexpression | sequence
			syntax_node<_Input, _Epsilon> *rule_subexpression(void)
			{
				syntax_node_ptr node = rule_sequence();
				if(m_lookahead.kind == TOKEN_OP_UNION)
				{
					// subexpression -> sequence '|' subexpression
					move(TOKEN_OP_UNION);
					syntax_node_ptr node2 = rule_subexpression();
					node = new syntax_node_union<_Input, _Epsilon>(node, node2, NULL);
				}
				return node;
			}

			// sequence -> subsequence | ''
			syntax_node_ptr rule_sequence(void)
			{
				if(m_lookahead.kind == TOKEN_GROUP_BEGIN || m_lookahead.kind == TOKEN_CHARACTER)
				{
					// sequence -> subsequence
					return rule_subsequence();
				}
				else
				{
					// sequence -> ''
					return new syntax_node_character<_Input, _Epsilon>(_Epsilon);
				}
			}

			// subsequence -> loop subsequence | loop
			syntax_node_ptr rule_subsequence(void)
			{
				syntax_node_ptr node1 = rule_loop();
				if(m_lookahead.kind == TOKEN_GROUP_BEGIN || m_lookahead.kind == TOKEN_CHARACTER)
				{
					// subsequence -> loop subsequence
					syntax_node_ptr node2 = rule_subsequence();
					return new syntax_node_concatenate<_Input, _Epsilon>(node1, node2, NULL);
				}
				else
				{
					// subsequence -> loop
					return node1;
				}
			}

			// loop -> factor '*' | factor
			syntax_node_ptr rule_loop(void)
			{
				syntax_node_ptr node = rule_factor();
				if(m_lookahead.kind == TOKEN_OP_LOOP)
				{
					// loop -> factor '*'
					move(TOKEN_OP_LOOP);
					node = new syntax_node_loop<_Input, _Epsilon>(node);
				}
				return node;
			}

			// factor -> '(' subexpression ')' | CHARACTER
			syntax_node_ptr rule_factor(void)
			{
				if(m_lookahead.kind == TOKEN_GROUP_BEGIN)
				{
					// factor -> '(' subexpression ')'
					move(TOKEN_GROUP_BEGIN);
					syntax_node_ptr node = rule_subexpression();
					move(TOKEN_GROUP_END);
					return node;
				}
				else
				{
					// factor -> CHARACTER
					syntax_node_ptr node = new syntax_node_character<_Input, _Epsilon>(m_lookahead.value);
					move(TOKEN_CHARACTER);
					return node;
				}
			}

		private:
			void _init(_ConstIterator /* pattern_begin */, _ConstIterator /* pattern_end */)
			{
				move();
			}

			// g[Nǂݍ݁iG[`FbNȂj
			void move(void)
			{
				m_lookahead = m_lexer.get_token();
			}

			// g[Nǂݍ݁iG[`FbNj
			void move(const TOKEN_KIND k)
			{
				if(m_lookahead.kind != k)
				{
					throw SYERR_SYNTAXERROR;
				}
				move();
			}
		};
	}
}

#endif // __MERCURY_SYNTAXER__
