// nfa.h cNFAi񌈒萫LI[g}gj̃f
#ifndef __MERCURY_NFA__
#define __MERCURY_NFA__

#include <queue>
#include "dfa.h"


namespace mercury
{
	template<typename _Input, _Input _Epsilon = _Input(0)>
	class nfa
	{
	public:
		typedef std::pair<state_t, _Input>            state_input_t;
		typedef std::map<state_input_t, state_set_t>  transition_t;
		typedef typename transition_t::const_iterator transition_const_iterator_t;

	private:
		// NFADFAϊpf[^^
		typedef std::pair<state_set_t, _Input>     n2d_tuple_t;
		typedef std::map<n2d_tuple_t, state_set_t> n2d_transition_t;
		typedef std::set<state_set_t>              n2d_state_set_set_t;
		typedef std::map<state_set_t, state_t>     n2d_state_map_t;
		typedef typename std::map<n2d_tuple_t, state_set_t>::const_iterator n2d_transition_const_iterator_t;
		typedef typename std::set<state_set_t>::const_iterator              n2d_state_set_set_const_iterator_t;
		typedef typename std::map<state_set_t, state_t>::const_iterator     n2d_state_map_const_iterator_t;

	public:
		nfa(state_t start)
		{
			m_start = start;
		}

		// J
		state_set_t transit(const state_t &state, const _Input &input) const
		{
			// ԂƓ͂̃^v쐬
			const state_input_t tuple(state, input);
			transition_const_iterator_t p = m_transition.find(tuple);
			if(p == m_transition.end())
			{
				// Jڐ悪Ȃ΋̏WԂ
				return state_set_t();
			}
			return p->second;
		}

		// Jڂ쐬
		void connect(const state_t &from, const _Input &input, const state_t &to)
		{
			// ԂƓ͂̃^v쐬
			const state_input_t tuple(from, input);
			m_transition[tuple].insert(to);
		}

		// Jڂ}[W
		void merge_transition(const nfa &rhs)
		{
			m_transition.insert(rhs.m_transition.begin(), rhs.m_transition.end());
		}

		// eԂ}[W
		void merge_acccepts(const nfa &rhs)
		{
			m_accepts.insert(rhs.m_accepts.begin(), rhs.m_accepts.end());
		}

		// JnԂ̎擾/ݒ
		state_t get_start(void) const    { return m_start; }
		void    set_start(state_t start) { m_start = start; }

		// eԂ̎擾/ݒ/ǉ
		const state_set_t get_accepts(void) const                 { return m_accepts; }
		void              set_accepts(const state_set_t &accepts) { m_accepts = accepts; }
		void              add_accepts(const state_set_t &accepts) { m_accepts.insert(accepts.begin(), accepts.end()); }
		void              add_accept (const state_t     &accept ) { m_accepts.insert(accept); }

		// eԂH
		bool is_accept_state(const state_t &state) const { return (m_accepts.find(state) != m_accepts.end()); }

		// ͂󗝉\H
		template<typename _ConstIterator>
		bool can_accept(_ConstIterator text_begin, _ConstIterator text_end) const
		{
			// [DT
			return _match_depth(text_begin, text_end, get_start());
		}

		// NFADFAɕϊ
		dfa<_Input> build_dfa(void) const
		{
			// Jn
			state_set_t starts = _expand_epsilon(m_start);

			// Jڃ}bv
			// ōJڃ}bv́uԂ̏WvuԁvƂ݂ȂĂB
			n2d_transition_t    transition;
			n2d_state_set_set_t done;
			_build_dfa_transition(starts, transition, done);

			// uԂ̏WvVȁuԁvɒu}bv쐬
			n2d_state_map_t state_map;
			_build_state_map(state_map, transition);

			// uJڃ}bv쐬
			typename dfa<_Input>::transition_t transition2;
			for(n2d_transition_const_iterator_t p = transition.begin(); p != transition.end(); p++)
			{
				const state_set_t from_ = (p->first).first;
				const _Input      input = (p->first).second;
				const state_set_t to_   = p->second;

				const n2d_state_map_const_iterator_t from = state_map.find(from_);
				const n2d_state_map_const_iterator_t to   = state_map.find(to_);
				if(from != state_map.end() && to != state_map.end())
				{
					// ʂ͌nY
					transition2[state_input_t(from->second, input)] = to->second;
				}
			}

			// Jn
			const state_t start = state_map[starts];

			// e
			const state_set_t accepts = _build_dfa_accepts(state_map);
			return dfa<_Input>(start, accepts, transition2);
		}

	private:
		state_t      m_start;                   // Jn
		state_set_t  m_accepts;                 // eԂ̏W
		transition_t m_transition;              // Jڃ}bv

		// [DT
		template<typename _ConstIterator>
		bool _match_depth(_ConstIterator text_pos, _ConstIterator text_end, const state_t state) const
		{
			// Sē͂I_ŎeԂłtrue
			if(text_pos == text_end) { return is_accept_state(state); }

			const _Input &input = *text_pos++;

			// stateÑJڂňړ\ȏԂ擾
			const state_set_t states = _expand_epsilon(state);
			for(state_set_t::const_iterator p = states.begin(); p != states.end(); p++)
			{
				// ꂼ̏ԂinputőJډ\ȏԂ擾
				const state_set_t states_transit = transit(*p, input);
				for(state_set_t::const_iterator p2 = states_transit.begin(); p2 != states_transit.end(); p2++)
				{
					// 1ł󗝂trueԂ
					if(_match_depth(text_pos, text_end, *p2)) { return true; }
				}
			}
			return false;
		}

		// stateÑJڂňړ\Ȕ͈͂擾
		state_set_t _expand_epsilon(const state_t &state) const
		{
			state_set_t states;
			states.insert(state);
			return _expand_epsilon(states);
		}
		state_set_t _expand_epsilon(const state_set_t &states) const
		{
			// 󕶎HׂԂW߂L[
			std::queue<state_t> remains;
			for(state_set_t::const_iterator p = states.begin(); p != states.end(); p++)
			{
				remains.push(*p);
			}

			state_set_t done;                       // HI

			while(!remains.empty())
			{
				// L[o
				const state_t state = remains.front();
				remains.pop();

				// 󕶎ɂĒHJڂH
				state_set_t nexts = transit(state, _Epsilon);

				// ̏Ԃ͒HI
				done.insert(state);

				// HďoėԂɋ󕶎ŒH邽߁AL[ɓ
				for(state_set_t::const_iterator p = nexts.begin(); p != nexts.end(); p++)
				{
					// HIĂȂvfL[ɓ
					if(done.find(*p) == done.end())
					{
						remains.push(*p);
					}
				}
			}
			return done;
		}

		// DFA\zp֐
		void _build_dfa_transition(const state_set_t &states, n2d_transition_t &transition, n2d_state_set_set_t &done) const
		{
			done.insert(states);
			for(transition_const_iterator_t p = m_transition.begin(); p != m_transition.end(); p++)
			{
				const state_t from  = (p->first).first;
				const _Input  input = (p->first).second;
				if(input != _Epsilon && states.find(from) != states.end())
				{
					// statesinputiÑJڈȊOjŒHꏊċA
					const n2d_tuple_t tuple(states, input);
					const state_set_t to = _expand_epsilon(p->second);
					transition[tuple] = to;
					if(done.find(to) == done.end())
					{
						_build_dfa_transition(to, transition, done);
					}
				}
			}
		}

		// uԂ̏WvVȁuԁvɒu}bv쐬
		void _build_state_map(n2d_state_map_t &state_map, const n2d_transition_t &transition) const
		{
			state_t state = 0;
			for(n2d_transition_const_iterator_t p = transition.begin(); p != transition.end(); p++)
			{
				state_map[(p->first).first] = state++;
				state_map[ p->second      ] = state++;
			}
		}

		// state_mapm_acceptsADFA̎eԂ̏W쐬
		state_set_t _build_dfa_accepts(const n2d_state_map_t &state_map) const
		{
			state_set_t accepts;
			for(n2d_state_map_const_iterator_t p = state_map.begin(); p != state_map.end(); p++)
			{
				for(state_set_t::const_iterator p2 = m_accepts.begin(); p2 != m_accepts.end(); p2++)
				{
					// eԂ1ł܂܂ĂuԂ̏Wv΁AeԂɒǉ
					state_set_t::const_iterator found = p->first.find(*p2);
					if(found != p->first.end())
					{
						accepts.insert(p->second);
					}
				}
			}
			return accepts;
		}

		// statesinputłǂ蒅͈͂擾
		state_set_t _dfa_transit(const state_set_t &states, const _Input &input) const
		{
			state_set_t ret;
			for(state_set_t::const_iterator p = states.begin(); p != states.end(); p++)
			{
				const state_set_t trans = transit(*p, input);
				ret.insert(trans.begin(), trans.end());
			}
			// ɃÑJڂłǂ蒅͈͂܂
			return _expand_epsilon(ret);
		}
	};
}

#endif // __MERCURY_NFA__
