// regex.h cK\
// ȉ̋LQlɁAR[hC++ɈڐAE
// http://codezine.jp/article/detail/3039/
#ifndef __MERCURY_REGEX__
#define __MERCURY_REGEX__

#include "dfa.h"
#include "_regex/syntaxer.h"


namespace mercury
{
	template<typename _Char, typename _Traits = _regex::token_traits<_Char>, _Char _Epsilon = _Char(0)>
	class basic_regex
	{
	public:
		// RXgN^
		basic_regex(const _Char *pattern_string, const size_t pattern_length) : m_dfa(STATE_ERROR)
		{
			_init(&pattern_string[0], &pattern_string[pattern_length]);
		}
		template<typename _Container>
		basic_regex(const _Container &pattern) : m_dfa(STATE_ERROR)
		{
			_init(pattern.begin(), pattern.end());
		}
		template<typename _ConstIterator>
		basic_regex(_ConstIterator pattern_begin, _ConstIterator pattern_end) : m_dfa(STATE_ERROR)
		{
			_init(pattern_begin, pattern_end);
		}

		// Sv
		bool match(const _Char *text_string, const size_t text_length) const
		{
			return match(&text_string[0], &text_string[text_length]);
		}
		template<typename _Container>
		bool match(const _Container &text) const
		{
			return match(text.begin(), text.end());
		}
		template<typename _ConstIterator>
		bool match(_ConstIterator text_begin, _ConstIterator text_end) const
		{
			return m_dfa.can_accept(text_begin, text_end);
		}

	private:
		dfa<_Char> m_dfa;

		// Ce[^ɂ鏉
		template<typename _ConstIterator>
		void _init(_ConstIterator pattern_begin, _ConstIterator pattern_end)
		{
			// \́i\؂쐬j
			_regex::syntaxer<_Char, _ConstIterator, _Traits, _Epsilon> syntax(pattern_begin, pattern_end);
			syntax_node<_Char, _Epsilon> *node = syntax.parse();

			// \؂NFA쐬
			state_t state = 0;
			nfa<_Char, _Epsilon> nfa_instance = node->build_nfa(state);

			// NFADFA쐬
			m_dfa = nfa_instance.build_dfa();

			// DFAœK
			m_dfa.compact();

			// \؂J
			node->free();
		}
	};

	// char, wchar_tɂ͐p̖Ot
	typedef basic_regex< char  >  regex;
	typedef basic_regex<wchar_t> wregex;
}

#endif // __MERCURY_REGEX__
