// nfa.h cNFAi񌈒萫LI[g}gj̃f
#ifndef __MERCURY_NFA__
#define __MERCURY_NFA__

#include <utility>
#include <stack>
#include <queue>
#include "dfa.h"


namespace mercury
{
	////////////////////////////////////////////////////////////////////////////////
	// Jڃ}bvNX
	template<typename _Input>
	class nfa_transition
	{
	private:
		typedef std::pair<state_t, _Input> state_input_t;
		typedef std::map<state_input_t, state_set_t> transition_t;
		typedef std::map<state_t      , state_set_t> transition_epsilon_t;
		typedef std::map<state_t      , state_t    > transition_default_t;

	public:
		typedef typename transition_t        ::const_iterator transition_const_iterator_t;
		typedef typename transition_epsilon_t::const_iterator transition_epsilon_const_iterator_t;
		typedef typename transition_default_t::const_iterator transition_default_const_iterator_t;

	public:
		transition_const_iterator_t begin(void) const { return m_transition.begin(); }
		transition_const_iterator_t end  (void) const { return m_transition.end  (); }
		transition_epsilon_const_iterator_t begin_epsilon(void) const { return m_transition_epsilon.begin(); }
		transition_epsilon_const_iterator_t end_epsilon  (void) const { return m_transition_epsilon.end  (); }
		transition_default_const_iterator_t begin_default(void) const { return m_transition_default.begin(); }
		transition_default_const_iterator_t end_default  (void) const { return m_transition_default.end  (); }

		// Jڂ쐬
		void connect(const state_t &from, const state_t &to, const _Input &input)
		{
			const _Input *inputs = &input;
			connect(from, to, &inputs[0], &inputs[1]);
		}
		template<typename _InputIterator>
		void connect(const state_t &from, const state_t &to, const _InputIterator &begin, const _InputIterator &end)
		{
			// ԂƓ͂̃^v쐬
			for(_InputIterator p = begin; p != end; p++)
			{
				const state_input_t tuple(from, *p);
				m_transition[tuple].insert(to);
			}
		}
		// ÑJڂ쐬
		void connect_epsilon(const state_t &from, const state_t &to)
		{
			// ÑJڃ}bvɓo^
			m_transition_epsilon[from].insert(to);
		}
		// ftHgJڂ쐬
		void connect_default(const state_t &from, const state_t &to)
		{
			// ftHgJڃ}bvɓo^
			m_transition_default[from] = to;
		}

		// Jڂ}[W
		void merge(const nfa_transition<_Input> &rhs)
		{
			// Jڃ}bvEÑJځEftHgJڂ}[W
			_merge        (rhs.m_transition);
			_merge_epsilon(rhs.m_transition_epsilon);
			_merge_default(rhs.m_transition_default);
		}

		// J
		state_set_t transit(const state_t &state, const _Input &input) const
		{
			// {block}
			// ԂƓ͂JڐT
			{
				// ԂƓ͂̃^v쐬
				const state_input_t tuple(state, input);
				transition_const_iterator_t p = m_transition.find(tuple);
				if(p != m_transition.end())
				{
					// ΑJڐԂ
					return p->second;
				}
			}

			// {block}
			// Jڐ悪Ȃ΃ftHgJڂs
			{
				transition_default_const_iterator_t p = m_transition_default.find(state);
				if(p != m_transition_default.end())
				{
					// ΑJڐԂ
					state_set_t to;
					to.insert(p->second);
					return to;
				}
			}

			// Jڐ悪Ȃ΋̏WԂ
			return state_set_t();
		}

		// ÑJ
		state_set_t transit(const state_t &state) const
		{
			// ÑJڃ}bv
			transition_epsilon_const_iterator_t p = m_transition_epsilon.find(state);
			if(p != m_transition_epsilon.end())
			{
				// ΑJڐԂ
				return p->second;
			}

			// Jڐ悪Ȃ΋̏WԂ
			return state_set_t();
		}

		// stateÑJڂňړ\Ȕ͈͂擾
		state_set_t expand_epsilon(const state_t &state) const
		{
			state_set_t states;
			states.insert(state);
			return expand_epsilon(states);
		}
		state_set_t expand_epsilon(const state_set_t &states) const
		{
			// 󕶎HׂԂW߂L[
			std::queue<state_t> remains;
			for(state_set_t::const_iterator p = states.begin(); p != states.end(); p++)
			{
				remains.push(*p);
			}

			state_set_t done;                       // HI

			while(!remains.empty())
			{
				// L[o
				const state_t state = remains.front();
				remains.pop();

				// ÑJڂɂĒH
				const state_set_t nexts = transit(state);

				// ̏Ԃ͒HI
				done.insert(state);

				// HďoėԂɋ󕶎ŒH邽߁AL[ɓ
				for(state_set_t::const_iterator p = nexts.begin(); p != nexts.end(); p++)
				{
					// HIĂȂvfL[ɓ
					if(done.find(*p) == done.end())
					{
						remains.push(*p);
					}
				}
			}
			return done;
		}

	private:
		transition_t         m_transition;
		transition_epsilon_t m_transition_epsilon;
		transition_default_t m_transition_default;

	private:
		// Jڃ}bv}[W
		void _merge(const transition_t &transition)
		{
			for(transition_const_iterator_t p = transition.begin(); p != transition.end(); p++)
			{
				const state_input_t si = p->first;
				const state_set_t   to = p->second;
				m_transition[si].insert(to.begin(), to.end());
			}
		}

		// ÑJڂ}[W
		void _merge_epsilon(const transition_epsilon_t &transition_epsilon)
		{
			for(transition_epsilon_const_iterator_t p = transition_epsilon.begin(); p != transition_epsilon.end(); p++)
			{
				const state_t     from = p->first;
				const state_set_t to   = p->second;
				m_transition_epsilon[from].insert(to.begin(), to.end());
			}
		}

		// ftHgJڂ}[Wi㏑j
		void _merge_default(const transition_default_t &transition_default)
		{
			for(transition_default_const_iterator_t p = transition_default.begin(); p != transition_default.end(); p++)
			{
				const state_t from = p->first;
				const state_t to   = p->second;
				m_transition_default[from] = to;
			}
		}
	};

	////////////////////////////////////////////////////////////////////////////////
	// NFA
	template<typename _Input>
	class nfa
	{
	public:
		nfa(const state_t &start = STATE_ERROR)
		{
			m_start = start;
		}

		// J
		state_set_t transit(const state_t &state, const _Input &input) const
		{
			return m_transition.transit(state, input);
		}

		// ÑJ
		state_set_t transit(const state_t &state) const
		{
			return m_transition.transit(state);
		}

		// Jڂ쐬
		void connect(const state_t &from, const state_t &to, const _Input &input)
		{
			m_transition.connect(from, to, input);
		}
		template<typename _InputIterator>
		void connect(const state_t &from, const state_t &to, const _InputIterator &begin, const _InputIterator &end)
		{
			m_transition.connect(from, to, begin, end);
		}
		// ÑJڂ쐬
		void connect_epsilon(const state_t &from, const state_t &to)
		{
			m_transition.connect_epsilon(from, to);
		}
		// ftHgJڂ쐬
		void connect_default(const state_t &from, const state_t &to)
		{
			m_transition.connect_default(from, to);
		}

		// Jڂ}[W
		void merge_transition(const nfa &rhs)
		{
			m_transition.merge(rhs.m_transition);
		}

		// eԂƔeԂ}[W
		void merge_accepts(const nfa &rhs)
		{
			m_accepts   .insert(rhs.m_accepts   .begin(), rhs.m_accepts   .end());
			m_no_accepts.insert(rhs.m_no_accepts.begin(), rhs.m_no_accepts.end());
		}

		// eԂƔeԂւiNOTj
		void invert_accepts(void)
		{
			std::swap(m_accepts, m_no_accepts);
		}

		// JnԂ̎擾/ݒ
		state_t get_start(void) const    { return m_start; }
		void    set_start(state_t start) { m_start = start; }

		// eԂ̎擾/ݒ/ǉ
		state_set_t get_accepts(void) const                 { return m_accepts; }
		void        set_accepts(const state_set_t &accepts) { m_accepts = accepts; }
		void        add_accepts(const state_set_t &accepts) { m_accepts.insert(accepts.begin(), accepts.end()); }
		void        add_accept (const state_t     &accept ) { m_accepts.insert(accept); }

		// eԂ̎擾/ݒ/ǉ
		state_set_t get_no_accepts(void) const                 { return m_no_accepts; }
		void        set_no_accepts(const state_set_t &no_accepts) { m_no_accepts = no_accepts; }
		void        add_no_accepts(const state_set_t &no_accepts) { m_no_accepts.insert(no_accepts.begin(), no_accepts.end()); }
		void        add_no_accept (const state_t     &no_accept ) { m_no_accepts.insert(no_accept); }

		// eԂH
		bool is_accept_state(const state_t &state) const { return (m_accepts.find(state) != m_accepts.end()); }

		// }b`OiOvj
		//  * }b`ꍇAԒ}b`ꏊ̃Ce[^Ԃ
		//  * }b`ȂꍇAtext_beginԂ
		template<typename _InputIterator, typename _OutputIterator>
		bool match_forward(const _InputIterator &text_begin, const _InputIterator &text_end, _OutputIterator &match_end, size_t &match_length) const
		{
			// ԂƃCe[^̃yA
			typedef std::pair<state_t, _InputIterator > state_iterator_t;
			typedef typename std::set<state_iterator_t> state_iterator_set_t;

			// ɐ[idepthjǉ
			typedef typename std::pair<state_iterator_t, size_t> state_iterator_size_t;
			typedef typename std::set <state_iterator_size_t   > state_iterator_size_set_t;

			// Œvꏊ
			state_iterator_size_t longest;
			_InputIterator &longest_pos   = longest.first.second;
			size_t         &longest_depth = longest.second;
			longest_depth = 0;

			// IԁECe[^̏W
			state_iterator_set_t done;

			// ԂƃCe[^i[obt@
			// [DŌĂ邪AstackqueueɂΕDɂȂ
			typename std::stack<state_iterator_size_t> remains;
			state_set_t expands = m_transition.expand_epsilon(m_start);
			for(state_set_t::const_iterator p = expands.begin(); p != expands.end(); p++)
			{
				remains.push(std::make_pair(std::make_pair(*p, text_begin), 1));
			}

			while(!remains.empty())
			{
				// X^bN̐擪o
				const state_iterator_size_t top = remains.top();
				remains.pop();
				done.insert(top.first);

				const state_t  state = top.first.first;
				_InputIterator pos   = top.first.second;
				const size_t   depth = top.second;

				// eԂȂŒvꏊXV
				if(is_accept_state(state))
				{
					if(longest_depth < depth)
					{
						longest = top;
					}
				}

				// I[܂ňv烋[v𔲂
				if(pos == text_end)
				{
					if(longest_pos == pos)
					{
						break;
					}
					continue;
				}

				// w蕶őJڂł͈͂擾
				state_set_t next = transit(state, *pos++);
				next = m_transition.expand_epsilon(next);

				// ړł͈͂X^bNɊi[
				for(state_set_t::const_iterator p = next.begin(); p != next.end(); p++)
				{
					const state_iterator_t si(*p, pos);
					if(done.find(si) == done.end())
					{
						remains.push(std::make_pair(std::make_pair(*p, pos), depth + 1));
					}
				}
			}

			if(longest_depth == 0) { return false; }

			match_end    = longest_pos;
			match_length = longest_depth - 1;
			return true;
		}

		// NFADFAɕϊ
		// ӁFftHgJڃ}bvłȂꍇ
		// DFAɕϊȂƂsmFς
		dfa<_Input> build_dfa(void) const
		{
			// JnԁEJڃ}bv쐬
			// ōJڃ}bv́uԂ̏WvuԁvƂ݂ȂĂB
			state_set_t              n2d_start;
			n2d_transition_t         n2d_transition;
			n2d_transition_default_t n2d_transition_default;
			_build_n2d_transition(n2d_start, n2d_transition, n2d_transition_default);

			// uԂ̏WvVȁuԁvɒu}bv쐬
			n2d_state_map_t state_map;
			_build_state_map(state_map, n2d_transition, n2d_transition_default);

			// uJnԁEJڃ}bv쐬
			state_t                  dfa_start;
			dfa_transition_t         dfa_transition;
			dfa_transition_default_t dfa_transition_default;
			_build_dfa_transition(dfa_start, dfa_transition, dfa_transition_default, n2d_start, n2d_transition, n2d_transition_default, state_map);

			// e
			state_set_t dfa_accepts;
			_build_dfa_accepts(dfa_accepts, state_map);

			// DFAԂ
			return dfa<_Input>(dfa_start, dfa_accepts, dfa_transition, dfa_transition_default);
		}

	private:
		state_t                m_start;         // Jn
		state_set_t            m_accepts;       // eԂ̏W
		state_set_t            m_no_accepts;    // eԂ̏W
		nfa_transition<_Input> m_transition;    // Jڃ}bv

	private:
		// NFADFAϊp[`
		typedef std::pair<state_set_t, _Input>     n2d_tuple_t;
		typedef std::map<n2d_tuple_t, state_set_t> n2d_transition_t;
		typedef std::map<state_set_t, state_set_t> n2d_transition_default_t;
		typedef std::set<state_set_t>              n2d_state_set_set_t;
		typedef std::map<state_set_t, state_t>     n2d_state_map_t;
		typedef typename n2d_transition_t        ::const_iterator n2d_transition_const_iterator_t;
		typedef typename n2d_transition_default_t::const_iterator n2d_transition_default_const_iterator_t;
		typedef typename n2d_state_set_set_t     ::const_iterator n2d_state_set_set_const_iterator_t;
		typedef typename n2d_state_map_t         ::const_iterator n2d_state_map_const_iterator_t;

		typedef typename dfa<_Input>::transition_t         dfa_transition_t;
		typedef typename dfa<_Input>::transition_default_t dfa_transition_default_t;

		// statesinputŒH蒅͈͂擾
		state_set_t _n2d_transit(const state_set_t &states, const _Input &input) const
		{
			state_set_t ret;
			for(state_set_t::const_iterator p = states.begin(); p != states.end(); p++)
			{
				const state_set_t trans = transit(*p, input);
				ret.insert(trans.begin(), trans.end());
			}
			// ɃÑJڂŒH蒅͈͂܂
			return m_transition.expand_epsilon(ret);
		}

		// JnԁEJڃ}bv\z
		void _build_n2d_transition(state_set_t &n2d_start, n2d_transition_t &n2d_transition, n2d_transition_default_t &n2d_transition_default) const
		{
			// NFÅJnԂÑJڂŒH͈͂VȊJnԂƂ
			n2d_start = m_transition.expand_epsilon(m_start);

			// Jڃ}bv
			n2d_state_set_set_t done;
			_build_n2d_transition_sub(n2d_start, n2d_transition, n2d_transition_default, done);
		}
		void _build_n2d_transition_sub(const state_set_t &states, n2d_transition_t &n2d_transition, n2d_transition_default_t &n2d_transition_default, n2d_state_set_set_t &done) const
		{
			done.insert(states);

			// Jڃ}bvXV
			for(typename nfa_transition<_Input>::transition_const_iterator_t p = m_transition.begin(); p != m_transition.end(); p++)
			{
				const state_t from  = (p->first).first;
				const _Input  input = (p->first).second;
				if(states.find(from) != states.end())
				{
					// statesinputŒHꏊċA
					const n2d_tuple_t tuple(states, input);
					const state_set_t to = m_transition.expand_epsilon(p->second);
					n2d_transition[tuple] = to;
					if(done.find(to) == done.end())
					{
						_build_n2d_transition_sub(to, n2d_transition, n2d_transition_default, done);
					}
				}
			}

			// ftHgJڃ}bvXV
			for(typename nfa_transition<_Input>::transition_default_const_iterator_t p = m_transition.begin_default(); p != m_transition.end_default(); p++)
			{
				const state_t from = p->first;
				if(states.find(from) != states.end())
				{
					// statesftHgJڂŒHꏊċA
					const state_set_t to = m_transition.expand_epsilon(p->second);
					n2d_transition_default[states] = to;
					if(done.find(to) == done.end())
					{
						_build_n2d_transition_sub(to, n2d_transition, n2d_transition_default, done);
					}
				}
			}
		}

		// uԂ̏WvVȁuԁvɒu}bv쐬
		void _build_state_map(n2d_state_map_t &state_map, const n2d_transition_t &transition, const n2d_transition_default_t &transition_default) const
		{
			state_t state = 0;
			for(n2d_transition_const_iterator_t p = transition.begin(); p != transition.end(); p++)
			{
				state_map[(p->first).first] = state++;
				state_map[ p->second      ] = state++;
			}
			for(n2d_transition_default_const_iterator_t p = transition_default.begin(); p != transition_default.end(); p++)
			{
				state_map[p->first ] = state++;
				state_map[p->second] = state++;
			}
		}

		// JnԁEJڃ}bvEftHgJڃ}bvɂāAuԂ̏Wvuԁvɒû쐬
		void _build_dfa_transition(state_t &dfa_start, dfa_transition_t &dfa_transition, dfa_transition_default_t &dfa_transition_default, state_set_t &n2d_start, n2d_transition_t &n2d_transition, n2d_transition_default_t &n2d_transition_default, n2d_state_map_t &state_map) const
		{
			// Jn
			dfa_start = state_map[n2d_start];

			// Jڃ}bv
			for(n2d_transition_const_iterator_t p = n2d_transition.begin(); p != n2d_transition.end(); p++)
			{
				const state_set_t from_ = (p->first).first;
				const _Input      input = (p->first).second;
				const state_set_t to_   = p->second;

				const n2d_state_map_const_iterator_t from = state_map.find(from_);
				const n2d_state_map_const_iterator_t to   = state_map.find(to_);
				if(from != state_map.end() && to != state_map.end())
				{
					// ʂ͌nY
					dfa_transition[std::make_pair(from->second, input)] = to->second;
				}
			}

			// ftHgJڃ}bv
			for(n2d_transition_default_const_iterator_t p = n2d_transition_default.begin(); p != n2d_transition_default.end(); p++)
			{
				const state_set_t from_ = p->first;
				const state_set_t to_   = p->second;

				const n2d_state_map_const_iterator_t from = state_map.find(from_);
				const n2d_state_map_const_iterator_t to   = state_map.find(to_);
				if(from != state_map.end() && to != state_map.end())
				{
					// ʂ͌nY
					dfa_transition_default[from->second] = to->second;
				}
			}
		}

		// DFA̎eԂ̏W쐬
		void _build_dfa_accepts(state_set_t &dfa_accepts, const n2d_state_map_t &state_map) const
		{
			for(n2d_state_map_const_iterator_t p = state_map.begin(); p != state_map.end(); p++)
			{
				for(state_set_t::const_iterator p2 = m_accepts.begin(); p2 != m_accepts.end(); p2++)
				{
					// eԂ1ł܂܂ĂuԂ̏Wv΁AeԂɒǉ
					state_set_t::const_iterator found = p->first.find(*p2);
					if(found != p->first.end())
					{
						dfa_accepts.insert(p->second);
					}
				}
			}
		}
	};
}

#endif // __MERCURY_NFA__
