#ifndef __MERCURY_REGEX_COMMON__
#define __MERCURY_REGEX_COMMON__

#include <string>

#ifndef mercury_countof
#	define mercury_countof(array)  (sizeof(array) / sizeof(array[0]))
#endif

namespace mercury
{
	typedef enum tagREGEX_ERROR
	{
		RE_SYNTAX,
		RE_SET_RANGE,
		RE_REPEAT_MINMAX,
		RE_TOO_MANY_STATES,
	} REGEX_ERROR;
	inline std::string error_message(const REGEX_ERROR error)
	{
		std::string message;
		switch(error)
		{
		case mercury::RE_SYNTAX         : message = "Syntax Error"            ; break;
		case mercury::RE_SET_RANGE      : message = "Invalid Range of Set"    ; break;
		case mercury::RE_REPEAT_MINMAX  : message = "Invalid Number of Repeat"; break;
		case mercury::RE_TOO_MANY_STATES: message = "Too Many Internal States"; break;
		}
		return message;
	}
}

#endif
