#ifndef __MERCURY_STREAM_ITERATOR__
#define __MERCURY_STREAM_ITERATOR__
template<typename _Char, typename _InputIterator>
class stream_iterator_end
{
public:
	stream_iterator_end(void)
		: m_begin(_InputIterator()), m_end(_InputIterator())
	{
		m_now = m_begin;
	}
	stream_iterator_end(const _InputIterator &begin, const _InputIterator &end)
		: m_begin(begin), m_end(end)
	{
		m_now = m_begin;
	}
	bool eos(void                   ) const { return m_now == m_end; }
	bool eos(const _InputIterator &p) const { return p     == m_end; }
	_InputIterator iterator(void) const { return m_now; }
	void rewind(void) { m_now = m_begin; }
	const _Char &operator*(void) const { return *m_now; }
	stream_iterator_end &operator++(void)
	{
		if(!eos()) { m_now++; }
		return *this;
	}
	stream_iterator_end operator++(int)
	{
		stream_iterator_end _Tmp = *this;
		++*this;
		return _Tmp;
	}

	stream_iterator_end &operator>>(_Char &ch)
	{
		ch = *(*this)++;
		return *this;
	}

private:
	_InputIterator m_begin, m_end;
	_InputIterator m_now;
};
template<typename _Char, typename _InputIterator>
class stream_iterator_nul
{
public:
	stream_iterator_nul(void)
		: m_begin(_InputIterator()), m_nul(_Char())
	{
		m_now = m_begin;
	}
	stream_iterator_nul(const _InputIterator &begin, const _Char &nul)
		: m_begin(begin), m_nul(nul)
	{
		m_now = m_begin;
	}
	bool eos(void                   ) const { return *m_now == m_nul; }
	bool eos(const _InputIterator &p) const { return *p     == m_nul; }
	_InputIterator iterator(void) const { return m_now; }
	void rewind(void) { m_now = m_begin; }
	const _Char &operator*(void) const { return *m_now; }

	stream_iterator_nul &operator++(void)
	{
		if(!eos()) { m_now++; }
		return *this;
	}
	stream_iterator_nul operator++(int)
	{
		stream_iterator_nul _Tmp = *this;
		++*this;
		return _Tmp;
	}

	stream_iterator_nul &operator>>(_Char &ch)
	{
		ch = *(*this)++;
		return *this;
	}

private:
	_InputIterator m_begin;
	_Char m_nul;
	_InputIterator m_now;
};

#endif
