// nfa.hFK\pNFAi񌈒萫LI[g}gj̃f
// _IɂNFA̎eԂ͕݂邪A̓s1ɂ
// i̕ŒZv₷j
#ifndef __MERCURY_REGEX_NFA__
#define __MERCURY_REGEX_NFA__

#include <utility>                      // std::pair
#include <stack>                        // std::stack
#include <map>                          // std::map
#include <set>                          // std::set
#include "common.h"


namespace mercury
{
	namespace _regex
	{
		////////////////////////////////////////////////////////////////////////////////
		// f[^^
		typedef size_t state_t;                 // 

		typedef int priority_t;
		typedef std::pair<priority_t, state_t> state_priority_t;
		typedef std::set<state_priority_t    > state_priority_set_t;


		////////////////////////////////////////////////////////////////////////////////
		// 萔
		const state_t STATE_ERROR = static_cast<state_t>(-1);

		const priority_t PRIORITY_HIGH   = +1;
		const priority_t PRIORITY_LOW    = -1;
		const priority_t PRIORITY_MIDDLE =  0;


		////////////////////////////////////////////////////////////////////////////////
		// Ԑ
		class state_generator
		{
		public:
			state_generator(const size_t max_states)
			{
				m_max_states = max_states;
				m_state      = 0;
			}

			state_t operator()(void)
			{
				if(m_state >= m_max_states) { throw RE_TOO_MANY_STATES; }
				return m_state++;
			}

		private:
			size_t  m_max_states;
			state_t m_state;
		};


		////////////////////////////////////////////////////////////////////////////////
		// Jڃ}bvNX
		template<typename _Input>
		class nfa_transition
		{
		public:
			typedef typename std::pair<state_t, _Input> state_input_t;

			typedef typename std::map<state_input_t, state_priority_set_t> transition_t;
			typedef typename std::map<state_t      , state_priority_set_t> transition_epsilon_t;
			typedef typename std::map<state_t      , state_priority_t    > transition_default_t;

			typedef typename transition_t        ::const_iterator transition_const_iterator_t;
			typedef typename transition_epsilon_t::const_iterator transition_epsilon_const_iterator_t;
			typedef typename transition_default_t::const_iterator transition_default_const_iterator_t;

		public:
			transition_const_iterator_t begin(void) const { return m_transition.begin(); }
			transition_const_iterator_t end  (void) const { return m_transition.end  (); }
			transition_epsilon_const_iterator_t begin_epsilon(void) const { return m_transition_epsilon.begin(); }
			transition_epsilon_const_iterator_t end_epsilon  (void) const { return m_transition_epsilon.end  (); }
			transition_default_const_iterator_t begin_default(void) const { return m_transition_default.begin(); }
			transition_default_const_iterator_t end_default  (void) const { return m_transition_default.end  (); }

			// Jڂ쐬
			void connect(const state_t &from, const state_t &to, const _Input &input, const priority_t &priority = 0)
			{
				const _Input *inputs = &input;
				connect(from, to, &inputs[0], &inputs[1], priority);
			}
			template<typename _InputIterator>
			void connect(const state_t &from, const state_t &to, const _InputIterator &begin, const _InputIterator &end, const priority_t priority = 0)
			{
				// ԂƓ͂̃^v쐬
				for(_InputIterator p = begin; p != end; p++)
				{
					const state_input_t    tuple_from(from, *p);
					const state_priority_t tuple_to  (priority, to);
					m_transition[tuple_from].insert(tuple_to);
				}
			}
			// ÑJڂ쐬
			void connect_epsilon(const state_t &from, const state_t &to, const priority_t &priority = 0)
			{
				// ÑJڃ}bvɓo^
				m_transition_epsilon[from].insert(std::make_pair(priority, to));
			}
			// ftHgJڂ쐬
			void connect_default(const state_t &from, const state_t &to, const priority_t &priority = 0)
			{
				// ftHgJڃ}bvɓo^
				m_transition_default[from] = std::make_pair(priority, to);
			}

			// Jڂ}[W
			void merge(const nfa_transition<_Input> &rhs)
			{
				// Jڃ}bvEÑJځEftHgJڂ}[W
				_merge        (rhs.m_transition);
				_merge_epsilon(rhs.m_transition_epsilon);
				_merge_default(rhs.m_transition_default);
			}

			// J
			state_priority_set_t transit(const state_t &state, const _Input &input) const
			{
				// {block}
				// ԂƓ͂JڐT
				{
					// ԂƓ͂̃^v쐬
					const state_input_t tuple(state, input);
					transition_const_iterator_t p = m_transition.find(tuple);
					if(p != m_transition.end())
					{
						// ΑJڐԂ
						return p->second;
					}
				}

				// {block}
				// Jڐ悪Ȃ΃ftHgJڂs
				{
					transition_default_const_iterator_t p = m_transition_default.find(state);
					if(p != m_transition_default.end())
					{
						// ΑJڐԂ
						state_priority_set_t to;
						to.insert(p->second);
						return to;
					}
				}

				// Jڐ悪Ȃ΋̏WԂ
				return state_priority_set_t();
			}

			// ÑJ
			state_priority_set_t transit(const state_t &state) const
			{
				// ÑJڃ}bv
				transition_epsilon_const_iterator_t p = m_transition_epsilon.find(state);
				if(p != m_transition_epsilon.end())
				{
					// ΑJڐԂ
					return p->second;
				}

				// Jڐ悪Ȃ΋̏WԂ
				return state_priority_set_t();
			}

			// stateÑJڂňړ\Ȕ͈͂擾
			state_priority_set_t expand_epsilon(const state_t &state) const
			{
				state_priority_set_t states;
				states.insert(std::make_pair(0, state));
				return expand_epsilon(states);
			}
			state_priority_set_t expand_epsilon(const state_priority_set_t &states) const
			{
				// 󕶎HׂԂW߂X^bN
				std::stack<state_priority_t> remains;
				for(state_priority_set_t::const_iterator p = states.begin(); p != states.end(); p++)
				{
					remains.push(*p);
				}

				// HI
				state_priority_set_t done;

				while(!remains.empty())
				{
					// X^bNo
					const state_priority_t state_priority = remains.top();
					remains.pop();

					// ÑJڂɂĒH
					const state_priority_set_t nexts = transit(state_priority.second);

					// ̏Ԃ͒HI
					done.insert(state_priority);

					// HďoėԂɋ󕶎ŒH邽߁AL[ɓ
					for(state_priority_set_t::const_iterator p = nexts.begin(); p != nexts.end(); p++)
					{
						// HIĂȂvfL[ɓ
						if(done.find(*p) == done.end())
						{
							remains.push(*p);
						}
					}
				}
				return done;
			}

		private:
			transition_t         m_transition;
			transition_epsilon_t m_transition_epsilon;
			transition_default_t m_transition_default;

		private:
			// Jڃ}bv}[W
			void _merge(const transition_t &transition)
			{
				for(transition_const_iterator_t p = transition.begin(); p != transition.end(); p++)
				{
					const state_input_t        si = p->first;
					const state_priority_set_t sp = p->second;
					m_transition[si].insert(sp.begin(), sp.end());
				}
			}

			// ÑJڂ}[W
			void _merge_epsilon(const transition_epsilon_t &transition_epsilon)
			{
				for(transition_epsilon_const_iterator_t p = transition_epsilon.begin(); p != transition_epsilon.end(); p++)
				{
					const state_t              from = p->first;
					const state_priority_set_t to   = p->second;
					m_transition_epsilon[from].insert(to.begin(), to.end());
				}
			}

			// ftHgJڂ}[Wi㏑j
			void _merge_default(const transition_default_t &transition_default)
			{
				for(transition_default_const_iterator_t p = transition_default.begin(); p != transition_default.end(); p++)
				{
					const state_t          from = p->first;
					const state_priority_t to   = p->second;
					m_transition_default[from] = to;
				}
			}
		};

		////////////////////////////////////////////////////////////////////////////////
		// NFA
		template<typename _Input>
		class nfa
		{
		public:
			nfa(const state_t &start = STATE_ERROR)
			{
				m_start = start;
			}

			// J
			state_priority_set_t transit(const state_t &state, const _Input &input) const
			{
				return m_transition.transit(state, input);
			}

			// ÑJ
			state_priority_set_t transit(const state_t &state) const
			{
				return m_transition.transit(state);
			}

			// Jڂ쐬
			void connect(const state_t &from, const state_t &to, const _Input &input, const priority_t &priority = 0)
			{
				m_transition.connect(from, to, input, priority);
			}
			template<typename _InputIterator>
			void connect(const state_t &from, const state_t &to, const _InputIterator &begin, const _InputIterator &end, const priority_t &priority = 0)
			{
				m_transition.connect(from, to, begin, end, priority);
			}
			// ÑJڂ쐬
			void connect_epsilon(const state_t &from, const state_t &to, const priority_t &priority = 0)
			{
				m_transition.connect_epsilon(from, to, priority);
			}
			// ftHgJڂ쐬
			void connect_default(const state_t &from, const state_t &to, const priority_t &priority = 0)
			{
				m_transition.connect_default(from, to, priority);
			}

			// Jڂ}[W
			void merge_transition(const nfa &rhs)
			{
				m_transition.merge(rhs.m_transition);
			}

			void invert_accepts(void)
			{
				std::swap(m_accept, m_no_accept);
			}

			// JnԂ̎擾/ݒ
			state_t get_start(void) const          { return m_start; }
			void    set_start(const state_t start) { m_start = start; }

			// eԂ̎擾/ݒ
			state_t get_accept(void) const           { return m_accept; }
			void    set_accept(const state_t accept) { m_accept = accept; }

			// eԂ̎擾/ݒ
			state_t get_no_accept(void) const              { return m_no_accept; }
			void    set_no_accept(const state_t no_accept) { m_no_accept = no_accept; }

			// eԂH
			bool is_accept_state(const state_t &state) const { return (m_accept == state); }

			// }b`OiOvj
			//  * }b`ꍇAtrueԂă}b`ꏊ̃Ce[^ƈvi[
			//  * }b`ȂꍇAfalseԂ
			template<typename _InputStreamIterator, typename _InputOutputIterator>
			bool match_forward(const _InputStreamIterator &text, _InputOutputIterator &match_end, size_t &match_length) const
			{
				// ԂƃCe[^̃yA
				typedef typename std::pair<state_t, _InputOutputIterator> state_iterator_t;
				typedef typename std::set <state_iterator_t             > state_iterator_set_t;

				// ԁE[EXg[Ce[^
				typedef typename std::pair<state_t      , size_t              > state_depth_t;
				typedef typename std::pair<state_depth_t, _InputStreamIterator> state_depth_iterator_t;

				// IԁECe[^̏W
				state_iterator_set_t done;

				// ԂƃCe[^i[obt@
				std::stack<state_depth_iterator_t> remains;
				state_priority_set_t expands = m_transition.expand_epsilon(m_start);
				for(state_priority_set_t::const_iterator p = expands.begin(); p != expands.end(); p++)
				{
					const state_depth_t          sd (p->second, 1);
					const state_depth_iterator_t sdi(sd, text);
					remains.push(sdi);
				}

				while(!remains.empty())
				{
					// X^bN̐擪o
					state_depth_iterator_t top = remains.top();
					remains.pop();

					const state_t        &state = top.first.first;
					const size_t         &depth = top.first.second;
					_InputStreamIterator &pos   = top.second;

					// ς
					done.insert(std::make_pair(state, pos.iterator()));

					// eԂȂ}b`OʂԂ
					if(is_accept_state(state))
					{
						match_end    = pos.iterator();
						match_length = depth - 1;
						return true;
					}

					// I[܂ňvȂ΂蒼
					if(pos.eos())
					{
						continue;
					}

					// w蕶őJڂł͈͂擾iDx̒ႢɃ\[gj
					state_priority_set_t next = transit(state, *pos++);
					next = m_transition.expand_epsilon(next);

					// ړł͈͂X^bNɊi[
					// iX^bN̐擪ɂ͗Dx̍̂j
					for(state_priority_set_t::const_iterator p = next.begin(); p != next.end(); p++)
					{
						const state_iterator_t si(p->second, pos.iterator());
						if(done.find(si) == done.end())
						{
							const state_depth_t          sd (p->second, depth + 1);
							const state_depth_iterator_t sdi(sd, pos);
							remains.push(sdi);
						}
					}
				}

				return false;
			}

		private:
			state_t m_start;                        // Jn
			state_t m_accept;                       // eԂ̏W
			state_t m_no_accept;                    // eԂ̏W
			nfa_transition<_Input> m_transition;    // Jڃ}bv
		};
	}
}

#endif // __MERCURY_REGEX_NFA__
