// parse_tree.hFK\p̍\
#ifndef __MERCURY_REGEX_PARSE_TREE__
#define __MERCURY_REGEX_PARSE_TREE__

#include <cstdarg>                      // va_list
#include <utility>                      // operator!=, operator<=, operator>, operator>=
#include <list>                         // std::list
#include "common.h"
#include "lexer.h"
#include "nfa.h"


namespace mercury
{
	namespace _regex
	{
		using namespace std::rel_ops;


		////////////////////////////////////////////////////////////////////////////////
		// \؂̒ۃNX
		template<typename _Input>
		class parse_tree
		{
		public:
			parse_tree(void) {}
			virtual ~parse_tree(void) {}

		public:
			// NFA\z
			virtual nfa<_Input> build_nfa(state_generator &generator) const = 0;
		};


		////////////////////////////////////////////////////////////////////////////////
		// W̗vf̃X[p[NXî݂ƂATuNXnot, set, character, class, rangej
		// hNX́AnotŐW𓾂邽߂Ɉȉ̏𖞂Kv
		//  * eԂƔeԂ1
		//  * generatorɑ΂
		//    * JnԂ  generator.m_state
		//    * eԂ  generator.m_state+1
		//    * eԂgenerator.m_state+2
		// notŎeԂƔeԂ𔽓]\̂ŁA
		// KeԁEeԂ܂߂邱ƁB
		template<typename _Input>
		class parse_node_element_set : public parse_tree<_Input>
		{
		};


		////////////////////////////////////////////////////////////////////////////////
		// notiےj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_not : public parse_node_element_set<_Input>
		{
		public:
			parse_node_not(parse_node_element_set<_Input> *node)
			{
				m_node = node;
			}

			~parse_node_not(void)
			{
				delete m_node;
				m_node = NULL;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				// eԂƔeԂ𔽓]
				nfa<_Input> frag = m_node->build_nfa(generator);
				frag.invert_accepts();

				return frag;
			}

		private:
			parse_node_element_set<_Input> *m_node;
		};


		////////////////////////////////////////////////////////////////////////////////
		// setiWj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_set : public parse_node_element_set<_Input>
		{
		public:
			parse_node_set(parse_node_element_set<_Input> *node, ...)
			{
				va_list ap;
				va_start(ap, node);

				parse_node_element_set_ptr_t arg = node;
				do
				{
					m_nodes.push_back(arg);
					arg = va_arg(ap, parse_node_element_set_ptr_t);
				}
				while(arg != NULL);
				va_end(ap);
			}

			~parse_node_set(void)
			{
				// qm[hSĉ
				for(parse_node_element_set_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					parse_node_element_set_ptr_t node = *p;
					delete node;
				}
				m_nodes.clear();
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				const state_generator generator_base = generator;
				const state_t start     = generator();
				const state_t accept    = generator();
				const state_t no_accept = generator();

				nfa<_Input> frag(start);
				frag.set_accept   (   accept);
				frag.set_no_accept(no_accept);
				frag.connect_default(start, no_accept);

				for(parse_node_element_set_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					state_generator subgenerator = generator_base;
					nfa<_Input> frag_x = (*p)->build_nfa(subgenerator);

					// eԁEeԂ̑JڂSă}[W
					// iJnԁEeԁEeԂfragƓj
					frag.merge_transition(frag_x);
				}
				return frag;
			}

		private:
			typedef parse_node_element_set<_Input>                            *parse_node_element_set_ptr_t;
			typedef typename std::list<parse_node_element_set_ptr_t>           parse_node_element_set_ptr_list_t;
			typedef typename parse_node_element_set_ptr_list_t::const_iterator parse_node_element_set_ptr_list_const_iterator_t;
			parse_node_element_set_ptr_list_t m_nodes;
		};


		////////////////////////////////////////////////////////////////////////////////
		// characterij
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_character : public parse_node_element_set<_Input>
		{
		public:
			parse_node_character(const _Input &ch) : m_character(ch)
			{
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				const state_t start     = generator();
				const state_t accept    = generator();
				const state_t no_accept = generator();
				nfa<_Input> frag(start);

				// m_character
				frag.set_accept(accept);
				frag.connect(start, accept, m_character);

				// ȊO
				frag.set_no_accept(no_accept);
				frag.connect_default(start, no_accept);

				return frag;
			}

		private:
			_Input m_character;
		};


		////////////////////////////////////////////////////////////////////////////////
		// classiNXj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_class : public parse_node_element_set<_Input>
		{
		public:
			parse_node_class(const CHARCLASS &charclass, const bool invert) : m_charclass(charclass), m_invert(invert)
			{
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				const _Input underscore = _Traits::char_underscore();

				const struct
				{
					CHARCLASS     type;
					bool          invert;
					size_t        size;
					const _Input *inputs;
				}
				info[] =
				{
					{CHARCLASS_UPPER , false, _Traits::class_upper_count       (), _Traits::class_upper       ()},
					{CHARCLASS_LOWER , false, _Traits::class_lower_count       (), _Traits::class_lower       ()},
					{CHARCLASS_DIGIT , false, _Traits::class_digit_count       (), _Traits::class_digit       ()},
					{CHARCLASS_XDIGIT, false, _Traits::class_xdigit_count      (), _Traits::class_xdigit      ()},
					{CHARCLASS_PUNCT , false, _Traits::class_punct_count       (), _Traits::class_punct       ()},
					{CHARCLASS_BLANK , false, _Traits::class_blank_count       (), _Traits::class_blank       ()},
					{CHARCLASS_SPACE , false, _Traits::class_space_count       (), _Traits::class_space       ()},
					{CHARCLASS_CNTRL , false, _Traits::class_cntrl_count       (), _Traits::class_cntrl       ()},
					{CHARCLASS_GRAPH ,  true, _Traits::class_graph_invert_count(), _Traits::class_graph_invert()},
					{CHARCLASS_PRINT ,  true, _Traits::class_print_invert_count(), _Traits::class_print_invert()},
					{CHARCLASS_UNDER , false,                                   1, &underscore},
				};

				const state_t start     = generator();
				const state_t accept    = generator();
				const state_t no_accept = generator();

				nfa<_Input> frag(start);
				frag.set_accept   (   accept);
				frag.set_no_accept(no_accept);

				for(size_t i = 0; i < mercury_countof(info); i++)
				{
					if(m_charclass & info[i].type)
					{
						const size_t  size   = info[i].size;
						const _Input *inputs = info[i].inputs;
						if(!(info[i].invert ^ m_invert))
						{
							// w肳ꂽSĎ
							frag.connect(start, accept, &inputs[0], &inputs[size]);
						}
						else
						{
							// w肳ꂽȊOSĎ
							frag.connect(start, no_accept, &inputs[0], &inputs[size]);
							frag.connect_default(start, accept);
						}
					}
				}

				return frag;
			}

		private:
			CHARCLASS m_charclass;
			bool      m_invert;
		};


		////////////////////////////////////////////////////////////////////////////////
		// rangeí͈j
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_range : public parse_node_element_set<_Input>
		{
		public:
			parse_node_range(const _Input &char1, const _Input &char2) : m_char1(char1), m_char2(char2)
			{
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				const state_t start     = generator();
				const state_t accept    = generator();
				const state_t no_accept = generator();

				nfa<_Input> frag(start);
				frag.set_accept   (   accept);
				frag.set_no_accept(no_accept);

				// ͈͓̑SĂ̕󗝂
				for(_Input ch = m_char1; ch <= m_char2; ch = _Traits::next(ch))
				{
					frag.connect(start, accept, ch);
				}
				frag.connect_default(start, no_accept);

				return frag;
			}

		private:
			// m_char1 <= m_char2 ƂB
			_Input m_char1, m_char2;
		};


		////////////////////////////////////////////////////////////////////////////////
		// noneiȂj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_none : public parse_tree<_Input>
		{
		public:
			parse_node_none(void)
			{
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				const state_t start = generator();
				nfa<_Input> frag(start);

				// JnԂeԂɂ
				frag.set_accept(start);
				return frag;
			}
		};


		////////////////////////////////////////////////////////////////////////////////
		// anyiCӂ1j
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_any : public parse_tree<_Input>
		{
		public:
			parse_node_any(void)
			{
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				const state_t start  = generator();
				const state_t accept = generator();
				nfa<_Input> frag(start);
				frag.set_accept(accept);

				// startacceptփftHgJ
				frag.connect_default(start, accept);

				return frag;
			}
		};


		////////////////////////////////////////////////////////////////////////////////
		// conjunctioniAj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_conjunction : public parse_tree<_Input>
		{
		public:
			parse_node_conjunction(parse_tree<_Input> *node, ...)
			{
				va_list ap;
				va_start(ap, node);

				parse_node_ptr_t arg = node;
				do
				{
					m_nodes.push_back(arg);
					arg = va_arg(ap, parse_node_ptr_t);
				}
				while(arg != NULL);
				va_end(ap);
			}

			~parse_node_conjunction(void)
			{
				// qm[hSĉ
				for(parse_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					parse_node_ptr_t node = *p;
					delete node;
				}
				m_nodes.clear();
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				// _~[NFA쐬
				parse_node_none<_Input, _Traits> none;
				nfa<_Input> frag(none.build_nfa(generator));

				for(parse_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					nfa<_Input> frag_x = (*p)->build_nfa(generator);

					// frag̎eԂfrag_x̊JnԂփÑJ
					frag.connect_epsilon(frag.get_accept(), frag_x.get_start());

					// Jڃ}bv}[W
					frag.merge_transition(frag_x);

					// frag_x̎eԂfrag̎eԂɂ
					frag.set_accept(frag_x.get_accept());
				}
				return frag;
			}

		private:
			typedef parse_tree<_Input>                            *parse_node_ptr_t;
			typedef std::list<parse_node_ptr_t>                    parse_node_ptr_list_t;
			typedef typename parse_node_ptr_list_t::const_iterator parse_node_ptr_list_const_iterator_t;
			parse_node_ptr_list_t m_nodes;
		};


		////////////////////////////////////////////////////////////////////////////////
		// disjunctioniIj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_disjunction : public parse_tree<_Input>
		{
		public:
			parse_node_disjunction(parse_tree<_Input> *node, ...)
			{
				va_list ap;
				va_start(ap, node);

				parse_node_ptr_t arg = node;
				do
				{
					m_nodes.push_back(arg);
					arg = va_arg(ap, parse_node_ptr_t);
				}
				while(arg != NULL);
				va_end(ap);
			}

			~parse_node_disjunction(void)
			{
				// qm[hSĉ
				for(parse_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					parse_node_ptr_t node = *p;
					delete node;
				}
				m_nodes.clear();
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				const state_t start  = generator();
				const state_t accept = generator();
				nfa<_Input> frag(start);
				frag.set_accept(accept);

				for(parse_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					nfa<_Input> frag_x = (*p)->build_nfa(generator);

					// frag̊JnԂfrag_x̊JnԂփÑJ
					frag.connect_epsilon(start, frag_x.get_start());

					// Jڃ}bv}[W
					frag.merge_transition(frag_x);

					// frag_x̎eԂacceptփÑJ
					frag.connect_epsilon(frag_x.get_accept(), accept);
				}
				return frag;
			}

		private:
			typedef parse_tree<_Input>                            *parse_node_ptr_t;
			typedef std::list<parse_node_ptr_t>                    parse_node_ptr_list_t;
			typedef typename parse_node_ptr_list_t::const_iterator parse_node_ptr_list_const_iterator_t;
			parse_node_ptr_list_t m_nodes;
		};


		////////////////////////////////////////////////////////////////////////////////
		// repeat0i0ȏ̌JԂj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_repeat0 : public parse_tree<_Input>
		{
		public:
			parse_node_repeat0(parse_tree<_Input> *node, const bool lazy = false)
			{
				m_node = node;
				m_lazy = lazy;
			}

			~parse_node_repeat0(void)
			{
				delete m_node;
				m_node = NULL;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				nfa<_Input> frag = m_node->build_nfa(generator);

				const state_t start  = frag.get_start();
				const state_t accept = frag.get_accept();

				// eԂJnԂփÑJ
				frag.connect_epsilon(accept, start, m_lazy ? PRIORITY_LOW : PRIORITY_HIGH);

				// 0̌JԂ邽߁AstartacceptփÑJ
				frag.connect_epsilon(start, accept, m_lazy ? PRIORITY_HIGH : PRIORITY_LOW);

				return frag;
			}

		private:
			parse_tree<_Input> *m_node;
			bool                m_lazy;
		};


		////////////////////////////////////////////////////////////////////////////////
		// repeat1i1ȏ̌JԂj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_repeat1 : public parse_tree<_Input>
		{
		public:
			parse_node_repeat1(parse_tree<_Input> *node, const bool lazy = false)
			{
				m_node = node;
				m_lazy = lazy;
			}

			~parse_node_repeat1(void)
			{
				delete m_node;
				m_node = NULL;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				nfa<_Input> frag = m_node->build_nfa(generator);

				const state_t start  = frag.get_start();
				const state_t accept = frag.get_accept();

				// eԂJnԂփÑJ
				// repeat0Ƃ͈ႢAstartacceptւ̓ÑJڂȂ
				frag.connect_epsilon(accept, start, m_lazy ? PRIORITY_LOW : PRIORITY_HIGH);

				return frag;
			}

		private:
			parse_tree<_Input> *m_node;
			bool                m_lazy;
		};


		////////////////////////////////////////////////////////////////////////////////
		// repeat01i0܂1̌JԂj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_repeat01 : public parse_tree<_Input>
		{
		public:
			parse_node_repeat01(parse_tree<_Input> *node, const bool lazy = false)
			{
				m_node = node;
				m_lazy = lazy;
			}

			~parse_node_repeat01(void)
			{
				delete m_node;
				m_node = NULL;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				nfa<_Input> frag = m_node->build_nfa(generator);

				// 0̌JԂ邽߁AstartacceptփÑJڂ
				const state_t start  = frag.get_start();
				const state_t accept = frag.get_accept();
				frag.connect_epsilon(start, accept, m_lazy ? PRIORITY_HIGH : PRIORITY_LOW);

				return frag;
			}

		private:
			parse_tree<_Input> *m_node;
			bool                m_lazy;
		};


		////////////////////////////////////////////////////////////////////////////////
		// repeatniňJԂj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_repeatn : public parse_tree<_Input>
		{
		public:
			parse_node_repeatn(parse_tree<_Input> *node, const size_t number)
			{
				m_node   = node;
				m_number = number;
			}

			~parse_node_repeatn(void)
			{
				delete m_node;
				m_node = NULL;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				nfa<_Input> frag(generator());

				// nJԂ
				state_t accept = frag.get_start();
				for(size_t i = 0; i < m_number; i++)
				{
					nfa<_Input> frag_x = m_node->build_nfa(generator);
					frag.merge_transition(frag_x);

					// ݂̎eԂ玟̊JnԂփÑJ
					const state_t start_x = frag_x.get_start();
					frag.connect_epsilon(accept, start_x);

					// eԂXV
					accept = frag_x.get_accept();
				}

				// ŌɍNFA̎eԂVNFA̎eԂƂ
				frag.set_accept(accept);
				return frag;
			}

		private:
			parse_tree<_Input> *m_node;
			size_t              m_number;
		};


		////////////////////////////////////////////////////////////////////////////////
		// repeatn_inȏ̌JԂj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_repeatn_ : public parse_tree<_Input>
		{
		public:
			parse_node_repeatn_(parse_tree<_Input> *node, const size_t number, const bool lazy = false)
			{
				m_node   = node;
				m_number = number;
				m_lazy   = lazy;
			}

			~parse_node_repeatn_(void)
			{
				delete m_node;
				m_node = NULL;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				nfa<_Input> frag(generator());

				// nJԂ
				state_t start  = STATE_ERROR;
				state_t accept = frag.get_start();
				for(size_t i = 0; i < m_number; i++)
				{
					nfa<_Input> frag_x = m_node->build_nfa(generator);
					frag.merge_transition(frag_x);

					// ݂̎eԂ玟̊JnԂփÑJ
					start = frag_x.get_start();
					frag.connect_epsilon(accept, start);

					// eԂXV
					accept = frag_x.get_accept();
				}

				// Ō̎eԂŌ̊JnԂփÑJ
				frag.connect_epsilon(accept, start, m_lazy ? PRIORITY_LOW : PRIORITY_HIGH);

				// ŌɍNFA̎eԂVNFA̎eԂƂ
				frag.set_accept(accept);
				return frag;
			}

		private:
			parse_tree<_Input> *m_node;
			size_t              m_number;
			bool                m_lazy;
		};


		////////////////////////////////////////////////////////////////////////////////
		// repeatmnimȏnȉ̌JԂj
		template<typename _Input, typename _Traits = regex_traits<_Input> >
		class parse_node_repeatmn : public parse_tree<_Input>
		{
		public:
			parse_node_repeatmn(parse_tree<_Input> *node, const size_t number1, const size_t number2, const bool lazy = false)
			{
				// number1 <= number2Ƃ
				m_node    = node;
				m_number1 = number1;
				m_number2 = number2;
				m_lazy    = lazy;
			}

			~parse_node_repeatmn(void)
			{
				delete m_node;
				m_node = NULL;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_generator &generator) const
			{
				nfa<_Input> frag(generator());
				frag.set_accept(generator());

				// ݂̎e
				state_t accept = frag.get_start();

				// m_number1JԂ
				for(size_t i = 0; i < m_number1; i++)
				{
					nfa<_Input> frag_x = m_node->build_nfa(generator);
					frag.merge_transition(frag_x);

					// ݂̎eԂ玟̊JnԂփÑJ
					const state_t start = frag_x.get_start();
					frag.connect_epsilon(accept, start);

					// eԂXV
					accept = frag_x.get_accept();
				}

				// m_number2܂ŌJԂ
				for(size_t i = m_number1; i < m_number2; i++)
				{
					nfa<_Input> frag_x = m_node->build_nfa(generator);
					frag.merge_transition(frag_x);

					const state_t start = frag_x.get_start();

					// ݂̎eԂ玟̊JnԂփÑJ
					frag.connect_epsilon(accept, start, m_lazy ? PRIORITY_LOW : PRIORITY_HIGH);

					// łɐVNFA̎eԂփÑJ
					frag.connect_epsilon(accept, frag.get_accept(), m_lazy ? PRIORITY_HIGH : PRIORITY_LOW);

					// eԂXV
					accept = frag_x.get_accept();
				}

				// ŌɍNFA̎eԂVNFA̎eԂɃÑJ
				frag.connect_epsilon(accept, frag.get_accept(), m_lazy ? PRIORITY_HIGH : PRIORITY_LOW);

				return frag;
			}

		private:
			parse_tree<_Input> *m_node;
			size_t              m_number1;
			size_t              m_number2;
			bool                m_lazy;
		};
	}
}

#endif // __MERCURY_REGEX_PARSE_TREE__
