/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class ReplaceFeatureVersionWizardPage
extends WizardPage {
    private IFeature currentFeature;
    private IFeature[] features;
    private TableViewer tableViewer;

    public ReplaceFeatureVersionWizardPage(IFeature currentFeature, IFeature[] features) {
        super("SwapFeature");
        this.setTitle(UpdateUI.getString("ReplaceFeatureVersionWizardPage.title"));
        this.setDescription(UpdateUI.getString("ReplaceFeatureVersionWizardPage.desc"));
        this.currentFeature = currentFeature;
        this.features = features;
    }

    public void createControl(Composite parent) {
        Composite tableContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableContainer.setLayout((Layout)layout);
        Label label = new Label(tableContainer, 0);
        label.setText(UpdateUI.getString("ReplaceFeatureVersionWizardPage.label"));
        Table table = new Table(tableContainer, 2564);
        table.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
                return provider.get(UpdateUIImages.DESC_UNCONF_FEATURE_OBJ, 0);
            }

            public String getText(Object element) {
                IFeature feature = (IFeature)element;
                return String.valueOf(feature.getLabel()) + " " + feature.getVersionedIdentifier().getVersion().toString();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                return ReplaceFeatureVersionWizardPage.this.features;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                PluginVersionIdentifier v2;
                PluginVersionIdentifier v1 = ((IFeature)e1).getVersionedIdentifier().getVersion();
                return v1.isGreaterOrEqualTo(v2 = ((IFeature)e2).getVersionedIdentifier().getVersion()) ? -1 : 1;
            }
        });
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String version = ((IFeature)element).getVersionedIdentifier().getVersion().toString();
                return !version.equals(ReplaceFeatureVersionWizardPage.this.currentFeature.getVersionedIdentifier().getVersion().toString());
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)ReplaceFeatureVersionWizardPage.this.tableViewer.getSelection();
                if (ssel == null) {
                    return;
                }
                IFeature chosenFeature = (IFeature)ssel.getFirstElement();
                IStatus validationStatus = OperationsManager.getValidator().validatePendingReplaceVersion(ReplaceFeatureVersionWizardPage.this.currentFeature, chosenFeature);
                ReplaceFeatureVersionWizardPage.this.setPageComplete(validationStatus == null || validationStatus.getCode() == 2);
                if (validationStatus == null) {
                    ReplaceFeatureVersionWizardPage.this.setErrorMessage(null);
                } else if (validationStatus.getCode() == 2) {
                    ReplaceFeatureVersionWizardPage.this.setErrorMessage(null);
                    ReplaceFeatureVersionWizardPage.this.setMessage(validationStatus.getMessage(), 2);
                } else {
                    ReplaceFeatureVersionWizardPage.this.setErrorMessage(validationStatus.getMessage());
                }
            }
        });
        this.tableViewer.setInput((Object)this.currentFeature);
        this.tableViewer.getTable().select(0);
        this.setControl((Control)tableContainer);
        Dialog.applyDialogFont((Control)tableContainer);
    }

    public boolean performFinish() {
        IStructuredSelection ssel = (IStructuredSelection)this.tableViewer.getSelection();
        IFeature chosenFeature = (IFeature)ssel.getFirstElement();
        return this.swap(this.currentFeature, chosenFeature);
    }

    private boolean swap(final IFeature currentFeature, final IFeature anotherFeature) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IConfigFeatureOperation revertOperation = OperationsManager.getOperationFactory().createReplaceFeatureVersionOperation(currentFeature, anotherFeature);
                try {
                    try {
                        boolean restartNeeded = revertOperation.execute(monitor, null);
                        UpdateUI.requestRestart(restartNeeded);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, operation);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof InstallAbortedException) {
                return true;
            }
            UpdateUI.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

