/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IContextMenuContributor;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultViewEntry;

public class Search {
    private String fPageId;
    private String fSingularLabel;
    private String fPluralLabelPattern;
    private ImageDescriptor fImageDescriptor;
    private ILabelProvider fLabelProvider;
    private ISelection fSelection;
    private ArrayList fResults;
    private IAction fGotoMarkerAction;
    private IContextMenuContributor fContextMenuContributor;
    private IActionGroupFactory fActionGroupFactory;
    private IGroupByKeyComputer fGroupByKeyComputer;
    private IRunnableWithProgress fOperation;

    public Search(String pageId, String singularLabel, String pluralLabelPattern, ILabelProvider labelProvider, ImageDescriptor imageDescriptor, IAction gotoMarkerAction, IActionGroupFactory groupFactory, IGroupByKeyComputer groupByKeyComputer, IRunnableWithProgress operation) {
        this.fPageId = pageId;
        this.fSingularLabel = singularLabel;
        this.fPluralLabelPattern = pluralLabelPattern;
        this.fImageDescriptor = imageDescriptor;
        this.fLabelProvider = labelProvider;
        this.fGotoMarkerAction = gotoMarkerAction;
        this.fActionGroupFactory = groupFactory;
        this.fGroupByKeyComputer = groupByKeyComputer;
        this.fOperation = operation;
        if (this.fPluralLabelPattern == null) {
            this.fPluralLabelPattern = "";
        }
    }

    public Search(String pageId, String singularLabel, String pluralLabelPattern, ILabelProvider labelProvider, ImageDescriptor imageDescriptor, IAction gotoMarkerAction, IContextMenuContributor contextMenuContributor, IGroupByKeyComputer groupByKeyComputer, IRunnableWithProgress operation) {
        this.fPageId = pageId;
        this.fSingularLabel = singularLabel;
        this.fPluralLabelPattern = pluralLabelPattern;
        this.fImageDescriptor = imageDescriptor;
        this.fLabelProvider = labelProvider;
        this.fGotoMarkerAction = gotoMarkerAction;
        this.fContextMenuContributor = contextMenuContributor;
        this.fGroupByKeyComputer = groupByKeyComputer;
        this.fOperation = operation;
        if (this.fPluralLabelPattern == null) {
            this.fPluralLabelPattern = "";
        }
    }

    String getFullDescription() {
        if (this.fSingularLabel != null && this.getItemCount() == 1) {
            return this.fSingularLabel;
        }
        int i = this.fPluralLabelPattern.lastIndexOf("{0}");
        if (i < 0) {
            return this.fPluralLabelPattern;
        }
        return String.valueOf(this.fPluralLabelPattern.substring(0, i)) + this.getItemCount() + this.fPluralLabelPattern.substring(Math.min(i + 3, this.fPluralLabelPattern.length()));
    }

    String getShortDescription() {
        String text = this.getFullDescription();
        int separatorPos = text.indexOf(" - ");
        if (separatorPos < 1) {
            return String.valueOf(text.substring(0, Math.min(50, text.length()))) + "...";
        }
        if (separatorPos < 30) {
            return text;
        }
        if (text.charAt(0) == '\"') {
            return String.valueOf(text.substring(0, Math.min(30, text.length()))) + "...\" - " + text.substring(Math.min(separatorPos + 3, text.length()));
        }
        return String.valueOf(text.substring(0, Math.min(30, text.length()))) + "... - " + text.substring(Math.min(separatorPos + 3, text.length()));
    }

    ImageDescriptor getImageDescriptor() {
        return this.fImageDescriptor;
    }

    int getItemCount() {
        int count = 0;
        Iterator iter = this.getResults().iterator();
        while (iter.hasNext()) {
            count += ((ISearchResultViewEntry)iter.next()).getMatchCount();
        }
        return count;
    }

    List getResults() {
        if (this.fResults == null) {
            return new ArrayList();
        }
        return this.fResults;
    }

    ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    /*
     * Exception decompiling
     */
    void searchAgain() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 101->105)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean isSameSearch(Search search) {
        return search != null && search.getOperation() == this.fOperation && this.fOperation != null;
    }

    void backupMarkers() {
        Iterator iter = this.getResults().iterator();
        while (iter.hasNext()) {
            ((SearchResultViewEntry)iter.next()).backupMarkers();
        }
    }

    String getPageId() {
        return this.fPageId;
    }

    IGroupByKeyComputer getGroupByKeyComputer() {
        return this.fGroupByKeyComputer;
    }

    public IRunnableWithProgress getOperation() {
        return this.fOperation;
    }

    IAction getGotoMarkerAction() {
        return this.fGotoMarkerAction;
    }

    IContextMenuContributor getContextMenuContributor() {
        return this.fContextMenuContributor;
    }

    IActionGroupFactory getActionGroupFactory() {
        return this.fActionGroupFactory;
    }

    public void removeResults() {
        this.fResults = null;
    }

    void setResults(ArrayList results) {
        Assert.isNotNull((Object)results);
        this.fResults = results;
    }

    ISelection getSelection() {
        return this.fSelection;
    }

    void setSelection(ISelection selection) {
        this.fSelection = selection;
    }
}

