/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.BuildModel;

public class ExternalBuildModel
extends BuildModel {
    private String installLocation;

    public ExternalBuildModel(String installLocation) {
        this.installLocation = installLocation;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public boolean isEditable() {
        return false;
    }

    public void load() {
        String location = this.getFullPath();
        try {
            URL url = new URL(location);
            InputStream stream = url.openStream();
            this.load(stream, false);
            stream.close();
        }
        catch (IOException iOException) {
            this.build = new Build();
            this.build.setModel(this);
            this.loaded = true;
        }
    }

    protected void updateTimeStamp() {
        File file = new File(this.getFullPath());
        this.updateTimeStamp(file);
    }

    private String getFullPath() {
        String fileName = "build.properties";
        return String.valueOf(this.getInstallLocation()) + File.separator + fileName;
    }

    public boolean isInSync() {
        File file = new File(this.getFullPath());
        return this.isInSync(file);
    }

    public void setInstallLocation(String newInstallLocation) {
        this.installLocation = newInstallLocation;
    }
}

