/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.feature.FeatureObject;
import org.eclipse.pde.internal.core.feature.FeatureURLElement;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureURL
extends FeatureObject
implements IFeatureURL {
    private Vector updates = new Vector();
    private Vector discoveries = new Vector();

    public void addDiscovery(IFeatureURLElement discovery) throws CoreException {
        this.ensureModelEditable();
        this.discoveries.add(discovery);
        ((FeatureURLElement)discovery).setInTheModel(true);
        this.fireStructureChanged(discovery, 1);
    }

    public void addUpdate(IFeatureURLElement update) throws CoreException {
        this.ensureModelEditable();
        this.updates.add(update);
        ((FeatureURLElement)update).setInTheModel(true);
        this.fireStructureChanged(update, 1);
    }

    public IFeatureURLElement[] getDiscoveries() {
        Object[] result = new IFeatureURLElement[this.discoveries.size()];
        this.discoveries.copyInto(result);
        return result;
    }

    public IFeatureURLElement[] getUpdates() {
        Object[] result = new IFeatureURLElement[this.updates.size()];
        this.updates.copyInto(result);
        return result;
    }

    protected void parse(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String tag = child.getNodeName().toLowerCase();
                int urlType = -1;
                if (tag.equals("update")) {
                    urlType = 1;
                } else if (tag.equals("discovery")) {
                    urlType = 2;
                }
                if (urlType != -1) {
                    IFeatureURLElement element = this.getModel().getFactory().createURLElement(this, urlType);
                    ((FeatureURLElement)element).parse(child, lineTable);
                    if (urlType == 1) {
                        ((FeatureURLElement)element).setInTheModel(true);
                        this.updates.add(element);
                    } else if (urlType == 2) {
                        ((FeatureURLElement)element).setInTheModel(true);
                        this.discoveries.add(element);
                    }
                }
            }
            ++i;
        }
    }

    public void removeDiscovery(IFeatureURLElement discovery) throws CoreException {
        this.ensureModelEditable();
        this.discoveries.remove(discovery);
        ((FeatureURLElement)discovery).setInTheModel(false);
        this.fireStructureChanged(discovery, 2);
    }

    public void removeUpdate(IFeatureURLElement update) throws CoreException {
        this.ensureModelEditable();
        ((FeatureURLElement)update).setInTheModel(false);
        this.updates.remove(update);
        this.fireStructureChanged(update, 2);
    }

    public void write(String indent, PrintWriter writer) {
        IFeatureURLElement element;
        writer.println(String.valueOf(indent) + "<url>");
        String indent2 = String.valueOf(indent) + "   ";
        int i = 0;
        while (i < this.updates.size()) {
            element = (IFeatureURLElement)this.updates.elementAt(i);
            element.write(indent2, writer);
            ++i;
        }
        i = 0;
        while (i < this.discoveries.size()) {
            element = (IFeatureURLElement)this.discoveries.elementAt(i);
            element.write(indent2, writer);
            ++i;
        }
        writer.println(String.valueOf(indent) + "</url>");
    }
}

