/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ConfigurationTab
extends AbstractLauncherTab
implements ILauncherSettings {
    private Image fImage;
    private ArrayList fPluginList = new ArrayList();
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fUseDefault;
    private Button fClearConfig;
    private TableViewer fTableViewer;

    public ConfigurationTab() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fImage = PDEPluginImages.DESC_PLUGIN_CONFIG_OBJ.createImage();
    }

    private void initializeDefaultPlugins() {
        this.fPluginList.clear();
        HashMap map = LauncherUtils.getAutoStartPlugins(true, "");
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            String id = object.toString().trim();
            IPluginModelBase model = this.getPlugin(id);
            if (model == null) continue;
            this.fPluginList.add(new Entry(model, (Integer)map.get(object)));
        }
    }

    private void initializePlugins(String selected) {
        this.fPluginList.clear();
        StringTokenizer tokenizer = new StringTokenizer(selected, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            String id = token.substring(0, token.indexOf(64));
            Integer level = new Integer(token.substring(token.indexOf(64) + 1));
            IPluginModelBase model = this.getPlugin(id);
            if (model == null) continue;
            this.fPluginList.add(new Entry(model, level));
        }
    }

    private IPluginModelBase getPlugin(String id) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ModelEntry entry = manager.findEntry(id);
        return entry == null ? null : entry.getActiveModel();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createStartingSpace(container, 1);
        Label label = new Label(container, 64);
        label.setText(PDEPlugin.getResourceString("ConfigurationTab.listLabel"));
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        label.setLayoutData((Object)gd);
        Composite middle = new Composite(container, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        middle.setLayout((Layout)layout);
        middle.setLayoutData((Object)new GridData(1808));
        this.createViewer(middle);
        this.createButtonContainer(middle);
        this.fUseDefault = new Button(container, 32);
        this.fUseDefault.setText(PDEPlugin.getResourceString("ConfigurationTab.defaultList"));
        this.fUseDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationTab.this.fUseDefault.getSelection()) {
                    ConfigurationTab.this.initializeDefaultPlugins();
                    ConfigurationTab.this.fTableViewer.refresh();
                }
                ConfigurationTab.this.enableButtons(!ConfigurationTab.this.fUseDefault.getSelection());
                ConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fClearConfig = new Button(container, 32);
        this.fClearConfig.setText(PDEPlugin.getResourceString("ConfigurationTab.clearArea"));
        this.fClearConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private void createViewer(Composite container) {
        Table table = new Table(container, 67586);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(PDEPlugin.getResourceString("ConfigurationTab.col1"));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(PDEPlugin.getResourceString("ConfigurationTab.col2"));
        table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(80));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        table.setLayout((Layout)layout);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String id1 = ((Entry)e1).model.getPluginBase().getId();
                String id2 = ((Entry)e2).model.getPluginBase().getId();
                return super.compare(viewer, (Object)id1, (Object)id2);
            }
        });
        this.fTableViewer.setInput((Object)this.fPluginList);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationTab.this.enableButtons(!ConfigurationTab.this.fUseDefault.getSelection());
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 300;
        table.setLayoutData((Object)gd);
    }

    private void createButtonContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1040));
        this.fAddButton = new Button(container, 8);
        this.fAddButton.setText(PDEPlugin.getResourceString("ConfigurationTab.add"));
        this.fAddButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPluginModelBase[] models = PDECore.getDefault().getModelManager().getPlugins();
                ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
                int i = 0;
                while (i < models.length) {
                    if (!ConfigurationTab.this.fPluginList.contains(new Entry(models[i], -1))) {
                        list.add(models[i]);
                    }
                    ++i;
                }
                SelectionDialog dialog = new SelectionDialog(ConfigurationTab.this.getShell(), list.toArray(new IPluginModelBase[list.size()]), true);
                if (dialog.open() == 0) {
                    Object[] selected = dialog.getResult();
                    int i2 = 0;
                    while (i2 < selected.length) {
                        ConfigurationTab.this.fPluginList.add(new Entry((IPluginModelBase)selected[i2], dialog.getStartLevel()));
                        ++i2;
                    }
                    ConfigurationTab.this.fTableViewer.refresh();
                    ConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.fRemoveButton = new Button(container, 8);
        this.fRemoveButton.setText(PDEPlugin.getResourceString("ConfigurationTab.remove"));
        this.fRemoveButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ConfigurationTab.this.fTableViewer.getTable().getSelectionIndices()[0];
                TableItem[] items = ConfigurationTab.this.fTableViewer.getTable().getSelection();
                int i = 0;
                while (i < items.length) {
                    ConfigurationTab.this.fPluginList.remove(items[i].getData());
                    ++i;
                }
                ConfigurationTab.this.fTableViewer.refresh();
                if (index > ConfigurationTab.this.fPluginList.size() - 1) {
                    index = ConfigurationTab.this.fPluginList.size() - 1;
                }
                if (index >= 0) {
                    ConfigurationTab.this.fTableViewer.setSelection((ISelection)new StructuredSelection(ConfigurationTab.this.fTableViewer.getElementAt(index)));
                }
                ConfigurationTab.this.fRemoveButton.setEnabled(index >= 0);
                ConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void dispose() {
        this.fImage.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("useDefaultConfig", true);
        configuration.setAttribute("clearConfig", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean useDefault = configuration.getAttribute("useDefaultConfig", true);
            if (useDefault) {
                this.initializeDefaultPlugins();
            } else {
                this.initializePlugins(configuration.getAttribute("autoStartList", ""));
            }
            this.fUseDefault.setSelection(useDefault);
            this.enableButtons(!useDefault);
            this.fClearConfig.setSelection(configuration.getAttribute("clearConfig", false));
        }
        catch (CoreException coreException) {}
        this.fTableViewer.setInput((Object)this.fPluginList);
    }

    private void enableButtons(boolean enabled) {
        ISelection selection = this.fTableViewer.getSelection();
        boolean selected = selection != null && !selection.isEmpty();
        this.fAddButton.setEnabled(enabled);
        this.fRemoveButton.setEnabled(selected && enabled);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("clearConfig", this.fClearConfig.getSelection());
        configuration.setAttribute("useDefaultConfig", this.fUseDefault.getSelection());
        if (!this.fUseDefault.getSelection()) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.fPluginList.size()) {
                Entry entry = (Entry)this.fPluginList.get(i);
                IPluginModelBase model = entry.model;
                buffer.append(String.valueOf(model.getPluginBase().getId()) + "@" + entry.startLevel);
                if (i < this.fPluginList.size() - 1) {
                    buffer.append(',');
                }
                ++i;
            }
            configuration.setAttribute("autoStartList", buffer.toString());
        } else {
            configuration.setAttribute("autoStartList", null);
        }
    }

    public String getName() {
        return PDEPlugin.getResourceString("ConfigurationTab.name");
    }

    public Image getImage() {
        return this.fImage;
    }

    class SelectionDialog
    extends PluginSelectionDialog {
        private Text startLevelText;
        private int startLevel = -1;

        public SelectionDialog(Shell parentShell, IPluginModelBase[] models, boolean multipleSelection) {
            super(parentShell, models, multipleSelection);
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(area, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            container.setLayout((Layout)layout);
            container.setLayoutData((Object)new GridData(768));
            Label label = new Label(container, 0);
            label.setText(PDEPlugin.getResourceString("ConfigurationTab.startLevel"));
            this.startLevelText = new Text(container, 2052);
            this.startLevelText.setLayoutData((Object)new GridData(768));
            return area;
        }

        public int getStartLevel() {
            return this.startLevel;
        }

        protected void okPressed() {
            String level = this.startLevelText.getText().trim();
            if (level.length() > 0) {
                try {
                    Integer integer = new Integer(level);
                    if (integer > 0) {
                        this.startLevel = integer;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            super.okPressed();
        }
    }

    class Entry {
        public IPluginModelBase model;
        public Integer startLevel;

        public Entry(IPluginModelBase model, int level) {
            this.model = model;
            this.startLevel = new Integer(level);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return ((Entry)obj).model.getPluginBase().getId().equals(this.model.getPluginBase().getId());
            }
            return false;
        }
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }
    }

    class ConfigurationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ConfigurationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof Entry) {
                IPluginModelBase model = ((Entry)element).model;
                return PDEPlugin.getDefault().getLabelProvider().getImage(model);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Entry) {
                Entry entry = (Entry)element;
                switch (columnIndex) {
                    case 0: {
                        IPluginBase plugin = entry.model.getPluginBase();
                        return String.valueOf(plugin.getId()) + " (" + plugin.getVersion() + ")";
                    }
                    case 1: {
                        int start = entry.startLevel;
                        return start >= 0 ? entry.startLevel.toString() : PDEPlugin.getResourceString("ConfigurationTab.unspecified");
                    }
                }
            }
            return null;
        }
    }
}

