/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class RuntimeWorkbenchShortcut
implements ILaunchShortcut {
    public void run() {
        this.launch("run");
    }

    public void debug() {
        this.launch("debug");
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(mode);
    }

    public void launch(ISelection selection, String mode) {
        this.launch(mode);
    }

    protected void launch(String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(String mode) {
        ILaunchConfiguration[] configs = this.getLaunchConfigurations(this.getWorkbenchLaunchConfigType());
        if (configs.length == 0) {
            return this.createConfiguration();
        }
        if (configs.length == 1) {
            return configs[0];
        }
        return this.chooseConfiguration(configs, mode);
    }

    private ILaunchConfiguration[] getLaunchConfigurations(ILaunchConfigurationType configType) {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                if (!DebugUITools.isPrivate((ILaunchConfiguration)configs[i])) {
                    result.add(configs[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    protected ILaunchConfiguration chooseConfiguration(ILaunchConfiguration[] configs, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs);
        dialog.setTitle(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.title"));
        if (mode.equals("debug")) {
            dialog.setMessage(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.select.debug"));
        } else {
            dialog.setMessage(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.select.run"));
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration() {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getWorkbenchLaunchConfigType();
            String computedName = this.getComputedName(configType.getName());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, computedName);
            wc.setAttribute("location0", this.getDefaultWorkspaceLocation());
            wc.setAttribute("vmargs", "");
            wc.setAttribute("progargs", LauncherUtils.getDefaultProgramArguments());
            wc.setAttribute("default", true);
            wc.setAttribute("usefeatures", false);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            wc.setAttribute("clearws", false);
            wc.setAttribute("askclear", true);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            PDEPlugin.logException(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getWorkbenchLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
    }

    private String getComputedName(String prefix) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateUniqueLaunchConfigurationNameFrom(prefix);
    }

    protected Shell getShell() {
        return PDEPlugin.getActiveWorkbenchShell();
    }

    private String getDefaultWorkspaceLocation() {
        return LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString();
    }
}

