/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportOperation;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportWizardDetailedPage;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportWizardFirstPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class FeatureImportWizard
extends Wizard
implements IImportWizard {
    private static final String STORE_SECTION = "FeatureImportWizard";
    private static final String KEY_MESSAGES_TITLE = "FeatureImportWizard.messages.title";
    private FeatureImportWizardFirstPage fPage1;
    private FeatureImportWizardDetailedPage fPage2;

    public FeatureImportWizard() {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_FEATURE_IMPORT_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString("FeatureImportWizard.title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        this.fPage1 = new FeatureImportWizardFirstPage();
        this.addPage((IWizardPage)this.fPage1);
        this.fPage2 = new FeatureImportWizardDetailedPage(this.fPage1);
        this.addPage((IWizardPage)this.fPage2);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        try {
            IFeatureModel[] models = this.fPage2.getSelectedModels();
            this.fPage1.storeSettings(true);
            IPath targetPath = this.computeTargetPath();
            IRunnableWithProgress op = FeatureImportWizard.getImportOperation(this.getShell(), models, targetPath);
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return true;
        }
        return true;
    }

    private IPath computeTargetPath() {
        IPath pluginsLocation = PDEPlugin.getWorkspace().getRoot().getLocation();
        return pluginsLocation.removeLastSegments(1).append("features");
    }

    public static IRunnableWithProgress getImportOperation(final Shell shell, final IFeatureModel[] models, final IPath targetPath) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        ReplaceQuery query = new ReplaceQuery(shell);
                        FeatureImportOperation op = new FeatureImportOperation(models, targetPath, query);
                        PDEPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_8 = null;
                }
                monitor.done();
            }
        };
    }

    private static class ReplaceDialog
    extends MessageDialog {
        public ReplaceDialog(Shell parentShell, String dialogMessage) {
            super(parentShell, PDEPlugin.getResourceString(FeatureImportWizard.KEY_MESSAGES_TITLE), null, dialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, PDEPlugin.getResourceString("FeatureImportWizard.noToAll"), IDialogConstants.CANCEL_LABEL}, 0);
        }
    }

    private static class ReplaceQuery
    implements FeatureImportOperation.IReplaceQuery {
        private Shell shell;
        private int yesToAll = 0;
        private int[] RETURNCODES;

        public ReplaceQuery(Shell shell) {
            int[] nArray = new int[5];
            nArray[0] = 2;
            nArray[1] = 2;
            nArray[2] = 1;
            nArray[3] = 1;
            this.RETURNCODES = nArray;
            this.shell = shell;
        }

        public int doQuery(IProject project) {
            if (this.yesToAll != 0) {
                return this.yesToAll > 0 ? 2 : 1;
            }
            String message = PDEPlugin.getFormattedMessage("FeatureImportWizard.messages.exists", project.getName());
            int[] result = new int[1];
            this.shell.getDisplay().syncExec(new Runnable(this, message, result){
                final /* synthetic */ ReplaceQuery this$1;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = replaceQuery;
                    this.val$message = string;
                    this.val$result = nArray;
                }

                public void run() {
                    ReplaceDialog dialog = new ReplaceDialog(ReplaceQuery.access$0(this.this$1), this.val$message);
                    int retVal = dialog.open();
                    if (retVal >= 0) {
                        this.val$result[0] = ReplaceQuery.access$1(this.this$1)[retVal];
                        if (retVal == 1) {
                            ReplaceQuery.access$2(this.this$1, 1);
                        } else if (retVal == 3) {
                            ReplaceQuery.access$2(this.this$1, -1);
                        }
                    }
                }
            });
            return result[0];
        }

        static /* synthetic */ Shell access$0(ReplaceQuery replaceQuery) {
            return replaceQuery.shell;
        }

        static /* synthetic */ int[] access$1(ReplaceQuery replaceQuery) {
            return replaceQuery.RETURNCODES;
        }

        static /* synthetic */ void access$2(ReplaceQuery replaceQuery, int n) {
            replaceQuery.yesToAll = n;
        }
    }
}

