/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.StreamsProxy;

public class RuntimeProcess
extends PlatformObject
implements IProcess {
    private static final int MAX_WAIT_FOR_DEATH_ATTEMPTS = 10;
    private static final int TIME_TO_WAIT_FOR_THREAD_DEATH = 500;
    private ILaunch fLaunch;
    private Process fProcess;
    private int fExitValue;
    private ProcessMonitorJob fMonitor;
    private IStreamsProxy fStreamsProxy;
    private String fName;
    private boolean fTerminated;
    private Map fAttributes;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RuntimeProcess(ILaunch launch, Process process, String name, Map attributes) {
        this.setLaunch(launch);
        this.initializeAttributes(attributes);
        this.fProcess = process;
        this.fName = name;
        this.fTerminated = true;
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.fTerminated = false;
        }
        this.fStreamsProxy = this.createStreamsProxy();
        this.fMonitor = new ProcessMonitorJob(this);
        launch.addProcess(this);
        this.fireCreationEvent();
    }

    private void initializeAttributes(Map attributes) {
        if (attributes != null) {
            Iterator keys = attributes.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.setAttribute(key, (String)attributes.get(key));
            }
        }
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public String getLabel() {
        return this.fName;
    }

    protected void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected Process getSystemProcess() {
        return this.fProcess;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            this.fProcess.destroy();
            if (this.fStreamsProxy instanceof StreamsProxy) {
                ((StreamsProxy)this.fStreamsProxy).kill();
            }
            int attempts = 0;
            while (attempts < 10) {
                try {
                    if (this.fProcess != null) {
                        this.fExitValue = this.fProcess.exitValue();
                    }
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++attempts;
                }
            }
            if (this.fMonitor != null) {
                this.fMonitor.killJob();
                this.fMonitor = null;
            }
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.getString("RuntimeProcess.terminate_failed"), null);
            throw new DebugException((IStatus)status);
        }
    }

    protected void terminated() {
        if (this.fStreamsProxy instanceof StreamsProxy) {
            ((StreamsProxy)this.fStreamsProxy).close();
        }
        this.fTerminated = true;
        try {
            this.fExitValue = this.fProcess.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
        this.fProcess = null;
        this.fireTerminateEvent();
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fStreamsProxy;
    }

    protected IStreamsProxy createStreamsProxy() {
        return new StreamsProxy(this.getSystemProcess());
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent(this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent(this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent(this, 16));
    }

    public void setAttribute(String key, String value) {
        Object origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
        this.fireChangeEvent();
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(key);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IProcess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (this.equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.getString("RuntimeProcess.Exit_value_not_available_until_process_terminates._1"), null));
    }

    class ProcessMonitorJob
    extends Job {
        protected Process fOSProcess;
        protected RuntimeProcess fRuntimeProcess;
        protected Thread fThread;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IStatus run(IProgressMonitor monitor) {
            this.fThread = Thread.currentThread();
            while (true) {
                Object var2_2;
                if (this.fOSProcess == null) {
                    this.fThread = null;
                    return Status.OK_STATUS;
                }
                try {
                    try {
                        this.fOSProcess.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.interrupted();
                    }
                }
                catch (Throwable throwable) {
                    var2_2 = null;
                    this.fOSProcess = null;
                    this.fRuntimeProcess.terminated();
                    throw throwable;
                }
                {
                    var2_2 = null;
                    this.fOSProcess = null;
                    this.fRuntimeProcess.terminated();
                    continue;
                }
                break;
            }
        }

        public ProcessMonitorJob(RuntimeProcess process) {
            super(DebugCoreMessages.getString("ProcessMonitorJob.0"));
            this.setPriority(10);
            this.setSystem(true);
            this.fRuntimeProcess = process;
            this.fOSProcess = process.getSystemProcess();
            this.schedule();
        }

        protected void killJob() {
            if (this.fThread == null) {
                this.cancel();
            } else {
                this.fThread.interrupt();
            }
        }
    }
}

