/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSupertypeWherePossibleRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UseSupertypeWizard
extends RefactoringWizard {
    public UseSupertypeWizard(UseSupertypeWherePossibleRefactoring ref) {
        super((Refactoring)ref, 4);
        this.setDefaultPageTitle(RefactoringMessages.getString("UseSupertypeWizard.Use_Super_Type_Where_Possible"));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new UseSupertypeInputPage());
    }

    private static class UseSupertypeInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "UseSupertypeInputPage";
        private TableViewer fTableViewer;
        private final Map fFileCount = new HashMap(2);
        private static final String MESSAGE = RefactoringMessages.getString("UseSupertypeInputPage.Select_supertype");
        private JavaElementLabelProvider fTableLabelProvider;

        public UseSupertypeInputPage() {
            super(PAGE_NAME);
            this.setMessage(MESSAGE);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.setControl((Control)composite);
            composite.setLayout((Layout)new GridLayout());
            Label label = new Label(composite, 0);
            label.setText(RefactoringMessages.getString("UseSupertypeInputPage.Select_supertype_to_use"));
            label.setLayoutData((Object)new GridData());
            this.addTableComponent(composite);
            Dialog.applyDialogFont((Control)composite);
        }

        private void addTableComponent(Composite composite) {
            this.fTableViewer = new TableViewer(composite, 2820);
            this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
            this.fTableLabelProvider = new UseSupertypeLabelProvider(this.fFileCount);
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fTableLabelProvider);
            this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ UseSupertypeInputPage this$1;
                {
                    this.this$1 = useSupertypeInputPage;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                    if (new Integer(0).equals(UseSupertypeInputPage.access$0(this.this$1).get(ss.getFirstElement()))) {
                        this.this$1.setMessage(RefactoringMessages.getString("UseSupertypeInputPage.No_updates"), 1);
                        this.this$1.setPageComplete(false);
                    } else {
                        this.this$1.setMessage(UseSupertypeInputPage.access$1());
                        this.this$1.setPageComplete(true);
                    }
                    UseSupertypeInputPage.access$2(this.this$1).refresh();
                }
            });
            this.fTableViewer.setInput((Object)this.getUseSupertypeRefactoring().getSuperTypes());
            this.fTableViewer.getTable().setSelection(0);
        }

        private UseSupertypeWherePossibleRefactoring getUseSupertypeRefactoring() {
            return (UseSupertypeWherePossibleRefactoring)this.getRefactoring();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            IWizardPage nextPage = super.getNextPage();
            this.updateUpdateLabels();
            return nextPage;
        }

        private void updateUpdateLabels() {
            IType selectedType = this.getSelectedSupertype();
            Change change = this.getRefactoringWizard().getChange();
            if (change instanceof CompositeChange) {
                this.fFileCount.put(selectedType, new Integer(((CompositeChange)change).getChildren().length));
            }
            this.fTableViewer.refresh();
            if (this.noSupertypeCanBeUsed()) {
                this.setMessage(RefactoringMessages.getString("UseSupertypeWizard.10"), 1);
                this.setPageComplete(false);
            }
        }

        private boolean noSupertypeCanBeUsed() {
            return this.fTableViewer.getTable().getItemCount() == this.countFilesWithValue(0);
        }

        private int countFilesWithValue(int i) {
            int count = 0;
            Iterator iter = this.fFileCount.keySet().iterator();
            while (iter.hasNext()) {
                if ((Integer)this.fFileCount.get(iter.next()) != i) continue;
                ++count;
            }
            return count;
        }

        private IType getSelectedSupertype() {
            IStructuredSelection ss = (IStructuredSelection)this.fTableViewer.getSelection();
            return (IType)ss.getFirstElement();
        }

        public boolean performFinish() {
            this.initializeRefactoring();
            boolean superFinish = super.performFinish();
            if (!superFinish) {
                return false;
            }
            Change c = this.getRefactoringWizard().getChange();
            if (c instanceof CompositeChange && ((CompositeChange)c).getChildren().length == 0) {
                this.updateUpdateLabels();
                return false;
            }
            return superFinish;
        }

        private void initializeRefactoring() {
            StructuredSelection ss = (StructuredSelection)this.fTableViewer.getSelection();
            this.getUseSupertypeRefactoring().setSuperTypeToUse((IType)ss.getFirstElement());
        }

        public void dispose() {
            this.fTableViewer = null;
            this.fFileCount.clear();
            this.fTableLabelProvider = null;
            super.dispose();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.fTableViewer != null) {
                this.fTableViewer.getTable().setFocus();
            }
        }

        static /* synthetic */ Map access$0(UseSupertypeInputPage useSupertypeInputPage) {
            return useSupertypeInputPage.fFileCount;
        }

        static /* synthetic */ String access$1() {
            return MESSAGE;
        }

        static /* synthetic */ TableViewer access$2(UseSupertypeInputPage useSupertypeInputPage) {
            return useSupertypeInputPage.fTableViewer;
        }

        private static class UseSupertypeLabelProvider
        extends JavaElementLabelProvider {
            private final Map fFileCount;

            UseSupertypeLabelProvider(Map fileCount) {
                this.fFileCount = fileCount;
            }

            public String getText(Object element) {
                String superText = super.getText(element);
                if (!this.fFileCount.containsKey(element)) {
                    return superText;
                }
                int count = (Integer)this.fFileCount.get(element);
                if (count == 0) {
                    Object[] keys = new String[]{superText};
                    return RefactoringMessages.getFormattedString("UseSupertypeInputPage.no_possible_updates", keys);
                }
                if (count == 1) {
                    Object[] keys = new String[]{superText};
                    return RefactoringMessages.getFormattedString("UseSupertypeInputPage.updates_possible_in_file", keys);
                }
                Object[] keys = new String[]{superText, String.valueOf(count)};
                return RefactoringMessages.getFormattedString("UseSupertypeInputPage.updates_possible_in_files", keys);
            }
        }
    }
}

