/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.LinkedList;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.comment.CommentObjectFactory;
import org.eclipse.jdt.internal.ui.text.comment.CommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.ITextMeasurement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class CommentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private ITextMeasurement fTextMeasurement;
    private int fLastDocumentHash;
    private int fLastHeaderHash;
    private int fLastMainTokenEnd = -1;
    private int fLastDocumentsHeaderEnd;

    public static String getLineIndentation(IDocument document, CommentRegion region, int offset, boolean useTab) {
        String result = "";
        try {
            IRegion line = document.getLineInformationOfOffset(offset);
            int begin = line.getOffset();
            int end = Math.min(offset, line.getOffset() + line.getLength());
            result = region.stringToIndent(document.get(begin, end - begin), useTab);
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }

    public CommentFormattingStrategy() {
    }

    public CommentFormattingStrategy(ITextMeasurement textMeasurement) {
        this.fTextMeasurement = textMeasurement;
    }

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition position = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null && position != null) {
            boolean isFormmatingComments = this.getPreferences().get("comment_format_comments").equals("true");
            boolean isFormattingHeader = this.getPreferences().get("comment_format_header").equals("true");
            boolean useTab = this.getPreferences().get("org.eclipse.jdt.core.formatter.tabulation.char").equals("tab");
            int documentsHeaderEnd = this.computeHeaderEnd(document);
            if (isFormmatingComments && (isFormattingHeader || position.offset >= documentsHeaderEnd)) {
                CommentRegion region = CommentObjectFactory.createRegion(document, position, TextUtilities.getDefaultLineDelimiter((IDocument)document), this.getPreferences(), this.fTextMeasurement);
                TextEdit edit = region.format(CommentFormattingStrategy.getLineIndentation(document, region, position.getOffset(), useTab));
                try {
                    if (edit != null) {
                        edit.apply(document);
                    }
                }
                catch (MalformedTreeException exception) {
                    JavaPlugin.log(exception);
                }
                catch (BadLocationException exception) {
                    JavaPlugin.log(exception);
                }
            }
        }
    }

    private int computeHeaderEnd(IDocument document) {
        if (document == null) {
            return -1;
        }
        try {
            if (this.fLastMainTokenEnd >= 0 && document.hashCode() == this.fLastDocumentHash && this.fLastMainTokenEnd < document.getLength() && document.get(0, this.fLastMainTokenEnd).hashCode() == this.fLastHeaderHash) {
                return this.fLastDocumentsHeaderEnd;
            }
        }
        catch (BadLocationException badLocationException) {}
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(document.get().toCharArray());
        try {
            int offset = -1;
            int terminal = scanner.getNextToken();
            while (terminal != 158 && terminal != 165 && terminal != 180) {
                if (terminal == 1003) {
                    offset = scanner.getCurrentTokenStartPosition();
                }
                terminal = scanner.getNextToken();
            }
            int mainTokenEnd = scanner.getCurrentTokenEndPosition();
            if (terminal != 158) {
                ++mainTokenEnd;
            } else {
                offset = -1;
            }
            try {
                this.fLastHeaderHash = document.get(0, mainTokenEnd).hashCode();
            }
            catch (BadLocationException badLocationException) {
                mainTokenEnd = -1;
            }
            this.fLastDocumentHash = document.hashCode();
            this.fLastMainTokenEnd = mainTokenEnd;
            this.fLastDocumentsHeaderEnd = offset;
            return offset;
        }
        catch (InvalidInputException invalidInputException) {
            return -1;
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        this.fPartitions.clear();
        this.fDocuments.clear();
        super.formatterStops();
    }
}

