/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.AddArgumentCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CastCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ChangeMethodSignatureProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.NewCUCompletionUsingWizardProposal;
import org.eclipse.jdt.internal.ui.text.correction.NewMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.NewVariableCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.RenameNodeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ReplaceCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElement;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElementsRequestor;
import org.eclipse.jdt.internal.ui.text.correction.TypeMismatchSubProcessor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.swt.graphics.Image;

public class UnresolvedElementsSubProcessor {
    public static void getVariableProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ITypeBinding binding = null;
        ITypeBinding declaringTypeBinding = Bindings.getBindingOfParentType(selectedNode);
        if (declaringTypeBinding == null) {
            return;
        }
        boolean suggestVariableProposals = true;
        int typeKind = 0;
        while (selectedNode instanceof ParenthesizedExpression) {
            selectedNode = ((ParenthesizedExpression)selectedNode).getExpression();
        }
        SimpleName node = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                node = (SimpleName)selectedNode;
                ASTNode parent = node.getParent();
                if (parent instanceof MethodInvocation && node.equals((Object)((MethodInvocation)parent).getExpression())) {
                    typeKind = 2;
                    break;
                }
                if (parent instanceof SimpleType) {
                    suggestVariableProposals = false;
                    typeKind = 6;
                    break;
                }
                if (!(parent instanceof QualifiedName)) break;
                Name qualifier = ((QualifiedName)parent).getQualifier();
                if (qualifier != node) {
                    binding = qualifier.resolveTypeBinding();
                } else {
                    typeKind = 6;
                }
                ASTNode outerParent = parent.getParent();
                while (outerParent instanceof QualifiedName) {
                    outerParent = outerParent.getParent();
                }
                if (!(outerParent instanceof SimpleType)) break;
                typeKind = 6;
                suggestVariableProposals = false;
                break;
            }
            case 40: {
                QualifiedName qualifierName = (QualifiedName)selectedNode;
                ITypeBinding qualifierBinding = qualifierName.getQualifier().resolveTypeBinding();
                if (qualifierBinding != null) {
                    node = qualifierName.getName();
                    binding = qualifierBinding;
                } else {
                    node = qualifierName.getQualifier();
                    typeKind = 6;
                    suggestVariableProposals = node.isSimpleName();
                }
                if (!(selectedNode.getParent() instanceof SimpleType)) break;
                typeKind = 6;
                suggestVariableProposals = false;
                break;
            }
            case 22: {
                FieldAccess access = (FieldAccess)selectedNode;
                Expression expression = access.getExpression();
                if (expression == null || (binding = expression.resolveTypeBinding()) == null) break;
                node = access.getName();
                break;
            }
            case 47: {
                binding = declaringTypeBinding.getSuperclass();
                node = ((SuperFieldAccess)selectedNode).getName();
            }
        }
        if (node == null) {
            return;
        }
        if (typeKind != 0) {
            int relevance = Character.isUpperCase(ASTNodes.getSimpleNameIdentifier((Name)node).charAt(0)) ? 3 : 0;
            UnresolvedElementsSubProcessor.addSimilarTypeProposals(typeKind, cu, (Name)node, relevance + 1, proposals);
            UnresolvedElementsSubProcessor.addNewTypeProposals(cu, (Name)node, 6, relevance, proposals);
        }
        if (!suggestVariableProposals) {
            return;
        }
        SimpleName simpleName = node.isSimpleName() ? node : ((QualifiedName)node).getName();
        boolean isWriteAccess = ASTResolving.isWriteAccess((Name)node);
        UnresolvedElementsSubProcessor.addSimilarVariableProposals(cu, astRoot, binding, simpleName, isWriteAccess, proposals);
        UnresolvedElementsSubProcessor.addNewFieldProposals(cu, astRoot, binding, declaringTypeBinding, simpleName, isWriteAccess, proposals);
        if (binding == null) {
            UnresolvedElementsSubProcessor.addNewVariableProposals(cu, (Name)node, simpleName, proposals);
        }
    }

    private static void addNewVariableProposals(ICompilationUnit cu, Name node, SimpleName simpleName, Collection proposals) {
        Assignment assignment;
        Image image;
        String label;
        int relevance;
        String name = simpleName.getIdentifier();
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        int type = bodyDeclaration.getNodeType();
        if (type == 31) {
            relevance = StubUtility.hasParameterName(cu.getJavaProject(), name) ? 8 : 5;
            label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createparameter.description", simpleName.getIdentifier());
            image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            proposals.add(new NewVariableCompletionProposal(label, cu, 3, simpleName, null, relevance, image));
        }
        if (type == 31 || type == 28) {
            relevance = StubUtility.hasLocalVariableName(cu.getJavaProject(), name) ? 10 : 7;
            label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createlocal.description", simpleName.getIdentifier());
            image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            proposals.add(new NewVariableCompletionProposal(label, cu, 1, simpleName, null, relevance, image));
        }
        if (node.getParent().getNodeType() == 7 && (assignment = (Assignment)node.getParent()).getLeftHandSide() == node && assignment.getParent().getNodeType() == 21) {
            ASTNode statement = assignment.getParent();
            ASTRewrite rewrite = ASTRewrite.create((AST)statement.getAST());
            rewrite.remove(statement, null);
            String label2 = CorrectionMessages.getString("UnresolvedElementsSubProcessor.removestatement.description");
            Image image2 = JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label2, cu, rewrite, 4, image2);
            proposals.add(proposal);
        }
    }

    private static void addNewFieldProposals(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding, ITypeBinding declaringTypeBinding, SimpleName simpleName, boolean isWriteAccess, Collection proposals) throws JavaModelException {
        Image image;
        String label;
        int relevance;
        ITypeBinding bind;
        ASTNode anonymDecl;
        ITypeBinding senderBinding;
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, binding);
        ITypeBinding iTypeBinding = senderBinding = binding != null ? binding : declaringTypeBinding;
        if (!senderBinding.isFromSource() || targetCU == null || !JavaModelUtil.isEditable(targetCU)) {
            return;
        }
        ITypeBinding outsideAnonymous = null;
        if (binding == null && senderBinding.isAnonymous() && (anonymDecl = astRoot.findDeclaringNode((IBinding)senderBinding)) != null && !(bind = Bindings.getBindingOfParentType(anonymDecl.getParent())).isAnonymous()) {
            outsideAnonymous = bind;
        }
        String name = simpleName.getIdentifier();
        int n = relevance = StubUtility.hasFieldName(cu.getJavaProject(), name) ? 9 : 6;
        if (binding == null) {
            label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createfield.description", name);
            image = JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif");
        } else {
            label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createfield.other.description", new Object[]{name, binding.getName()});
            image = JavaPluginImages.get("org.eclipse.jdt.ui.field_public_obj.gif");
        }
        proposals.add(new NewVariableCompletionProposal(label, targetCU, 2, simpleName, senderBinding, relevance, image));
        if (outsideAnonymous != null) {
            label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createfield.other.description", new Object[]{name, outsideAnonymous.getName()});
            image = JavaPluginImages.get("org.eclipse.jdt.ui.field_public_obj.gif");
            proposals.add(new NewVariableCompletionProposal(label, targetCU, 2, simpleName, outsideAnonymous, relevance + 1, image));
        }
        if (!isWriteAccess) {
            ITypeBinding target;
            relevance = StubUtility.hasConstantName(name) ? 9 : 4;
            ITypeBinding iTypeBinding2 = target = outsideAnonymous != null ? outsideAnonymous : senderBinding;
            if (binding == null) {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createconst.description", name);
                image = JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif");
            } else {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createconst.other.description", new Object[]{name, binding.getName()});
                image = JavaPluginImages.get("org.eclipse.jdt.ui.field_public_obj.gif");
            }
            proposals.add(new NewVariableCompletionProposal(label, targetCU, 4, simpleName, target, relevance, image));
        }
    }

    private static void addSimilarVariableProposals(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding, SimpleName node, boolean isWriteAccess, Collection proposals) {
        IBinding[] varsInScope = new ScopeAnalyzer(astRoot).getDeclarationsInScope(node, 18);
        if (varsInScope.length > 0) {
            String otherNameInAssign = null;
            String methodSenderName = null;
            String fieldSenderName = null;
            ASTNode parent = node.getParent();
            switch (parent.getNodeType()) {
                case 59: {
                    otherNameInAssign = ((VariableDeclarationFragment)parent).getName().getIdentifier();
                    break;
                }
                case 7: {
                    Assignment assignment = (Assignment)parent;
                    if (isWriteAccess && assignment.getRightHandSide() instanceof SimpleName) {
                        otherNameInAssign = ((SimpleName)assignment.getRightHandSide()).getIdentifier();
                        break;
                    }
                    if (isWriteAccess || !(assignment.getLeftHandSide() instanceof SimpleName)) break;
                    otherNameInAssign = ((SimpleName)assignment.getLeftHandSide()).getIdentifier();
                    break;
                }
                case 32: {
                    MethodInvocation inv = (MethodInvocation)parent;
                    if (inv.getExpression() != node) break;
                    methodSenderName = inv.getName().getIdentifier();
                    break;
                }
                case 40: {
                    QualifiedName qualName = (QualifiedName)parent;
                    if (qualName.getQualifier() != node) break;
                    fieldSenderName = qualName.getName().getIdentifier();
                }
            }
            ITypeBinding guessedType = ASTResolving.guessBindingForReference((ASTNode)node);
            if (astRoot.getAST().resolveWellKnownType("java.lang.Object") == guessedType) {
                guessedType = null;
            }
            String identifier = node.getIdentifier();
            int i = 0;
            while (i < varsInScope.length) {
                IVariableBinding curr = (IVariableBinding)varsInScope[i];
                String currName = curr.getName();
                boolean isFinal = Modifier.isFinal((int)curr.getModifiers());
                if (!(currName.equals(otherNameInAssign) || isFinal && curr.isField() && isWriteAccess)) {
                    ITypeBinding varType;
                    int relevance = 0;
                    if (NameMatcher.isSimilarName(currName, identifier)) {
                        relevance += 3;
                    }
                    if (currName.equalsIgnoreCase(identifier)) {
                        relevance += 5;
                    }
                    if ((varType = curr.getType()) != null) {
                        if (guessedType != null && (!isWriteAccess && TypeRules.canAssign(varType, guessedType) || isWriteAccess && TypeRules.canAssign(guessedType, varType))) {
                            relevance += 2;
                        }
                        if (methodSenderName != null && UnresolvedElementsSubProcessor.hasMethodWithName(varType, methodSenderName)) {
                            relevance += 2;
                        }
                        if (fieldSenderName != null && UnresolvedElementsSubProcessor.hasFieldWithName(varType, fieldSenderName)) {
                            relevance += 2;
                        }
                    }
                    if (relevance > 0) {
                        String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changevariable.description", currName);
                        proposals.add(new RenameNodeCompletionProposal(label, cu, node.getStartPosition(), node.getLength(), currName, relevance));
                    }
                }
                ++i;
            }
        }
        if (binding != null && binding.isArray()) {
            String idLength = "length";
            String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changevariable.description", idLength);
            proposals.add(new RenameNodeCompletionProposal(label, cu, node.getStartPosition(), node.getLength(), idLength, 8));
        }
    }

    private static boolean hasMethodWithName(ITypeBinding typeBinding, String name) {
        IVariableBinding[] fields = typeBinding.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            return UnresolvedElementsSubProcessor.hasMethodWithName(superclass, name);
        }
        return false;
    }

    private static boolean hasFieldWithName(ITypeBinding typeBinding, String name) {
        IMethodBinding[] methods = typeBinding.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            return UnresolvedElementsSubProcessor.hasMethodWithName(superclass, name);
        }
        return false;
    }

    public static void getTypeProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        int kind = 14;
        ASTNode parent = selectedNode.getParent();
        while (parent.getLength() == selectedNode.getLength()) {
            parent = parent.getParent();
        }
        switch (parent.getNodeType()) {
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)parent;
                if (typeDeclaration.superInterfaces().contains(selectedNode)) {
                    kind = 4;
                    break;
                }
                if (!selectedNode.equals((Object)typeDeclaration.getSuperclass())) break;
                kind = 2;
                break;
            }
            case 31: {
                MethodDeclaration methodDeclaration = (MethodDeclaration)parent;
                if (methodDeclaration.thrownExceptions().contains(selectedNode)) {
                    kind = 2;
                    break;
                }
                if (!selectedNode.equals((Object)methodDeclaration.getReturnType())) break;
                kind = 30;
                break;
            }
            case 62: {
                kind = 6;
                break;
            }
            case 53: {
                kind = 6;
                break;
            }
            case 14: {
                if (((ClassInstanceCreation)parent).getAnonymousClassDeclaration() == null) {
                    kind = 2;
                    break;
                }
                kind = 6;
                break;
            }
            case 44: {
                int superParent = parent.getParent().getNodeType();
                if (superParent != 12) break;
                kind = 2;
                break;
            }
            case 65: {
                kind = 6;
            }
        }
        Name node = null;
        if (selectedNode instanceof SimpleType) {
            node = ((SimpleType)selectedNode).getName();
        } else if (selectedNode instanceof ArrayType) {
            Type elementType = ((ArrayType)selectedNode).getElementType();
            if (elementType.isSimpleType()) {
                node = ((SimpleType)elementType).getName();
            }
        } else if (selectedNode instanceof Name) {
            node = (Name)selectedNode;
        } else {
            return;
        }
        UnresolvedElementsSubProcessor.addSimilarTypeProposals(kind, cu, node, 3, proposals);
        UnresolvedElementsSubProcessor.addNewTypeProposals(cu, node, kind, 0, proposals);
    }

    private static void addSimilarTypeProposals(int kind, ICompilationUnit cu, Name node, int relevance, Collection proposals) throws CoreException {
        SimilarElement[] elements = SimilarElementsRequestor.findSimilarElement(cu, node, kind);
        String resolvedTypeName = null;
        ITypeBinding binding = ASTResolving.guessBindingForTypeReference((ASTNode)node);
        if (binding != null) {
            if (binding.isArray()) {
                binding = binding.getElementType();
            }
            resolvedTypeName = binding.getQualifiedName();
            proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeProposal(cu, resolvedTypeName, node, relevance + 2));
        }
        int i = 0;
        while (i < elements.length) {
            String fullName;
            SimilarElement elem = elements[i];
            if ((elem.getKind() & 0xE) != 0 && !(fullName = elem.getName()).equals(resolvedTypeName)) {
                proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeProposal(cu, fullName, node, relevance));
            }
            ++i;
        }
    }

    private static CUCorrectionProposal createTypeRefChangeProposal(ICompilationUnit cu, String fullName, Name node, int relevance) throws CoreException {
        CUCorrectionProposal proposal;
        ImportRewrite importRewrite = new ImportRewrite(cu);
        importRewrite.setFindAmbiguosImports(true);
        String simpleName = importRewrite.addImport(fullName);
        String packName = Signature.getQualifier((String)fullName);
        Object[] arg = new String[]{simpleName, packName};
        if (node.isSimpleName() && simpleName.equals(((SimpleName)node).getIdentifier())) {
            String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.importtype.description", arg);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.imp_obj.gif");
            proposal = new CUCorrectionProposal(label, cu, relevance + 100, image);
        } else {
            String label = packName.length() == 0 ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changetype.nopack.description", simpleName) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changetype.description", arg);
            proposal = new RenameNodeCompletionProposal(label, cu, node.getStartPosition(), node.getLength(), simpleName, relevance);
        }
        proposal.setImportRewrite(importRewrite);
        return proposal;
    }

    private static void addNewTypeProposals(ICompilationUnit cu, Name refNode, int kind, int relevance, Collection proposals) throws JavaModelException {
        Name qualifier;
        Name node = refNode;
        do {
            boolean isPossibleName;
            String typeName = ASTNodes.getSimpleNameIdentifier(node);
            qualifier = null;
            boolean bl = isPossibleName = Character.isUpperCase(typeName.charAt(0)) || node == refNode;
            if (!isPossibleName) continue;
            IPackageFragment enclosingPackage = null;
            IType enclosingType = null;
            if (node.isSimpleName()) {
                enclosingPackage = (IPackageFragment)cu.getParent();
            } else {
                Name qualifierName = ((QualifiedName)node).getQualifier();
                IJavaElement[] res = cu.codeSelect(qualifierName.getStartPosition(), qualifierName.getLength());
                if (res != null && res.length > 0 && res[0] instanceof IType) {
                    enclosingType = (IType)res[0];
                } else {
                    qualifier = qualifierName;
                    enclosingPackage = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu).getPackageFragment(ASTResolving.getFullName(qualifierName));
                }
            }
            if (enclosingPackage != null && !enclosingPackage.getCompilationUnit(String.valueOf(typeName) + ".java").exists()) {
                if ((kind & 2) != 0) {
                    proposals.add(new NewCUCompletionUsingWizardProposal(cu, node, true, (IJavaElement)enclosingPackage, relevance));
                }
                if ((kind & 4) != 0) {
                    proposals.add(new NewCUCompletionUsingWizardProposal(cu, node, false, (IJavaElement)enclosingPackage, relevance));
                }
            }
            if (enclosingType == null || enclosingType.isReadOnly() || enclosingType.getType(typeName).exists()) continue;
            if ((kind & 2) != 0) {
                proposals.add(new NewCUCompletionUsingWizardProposal(cu, node, true, (IJavaElement)enclosingType, relevance));
            }
            if ((kind & 4) == 0) continue;
            proposals.add(new NewCUCompletionUsingWizardProposal(cu, node, false, (IJavaElement)enclosingType, relevance));
        } while ((node = qualifier) != null);
    }

    public static void getMethodProposals(IInvocationContext context, IProblemLocation problem, boolean isOnlyParameterMismatch, Collection proposals) throws CoreException {
        String label;
        ICompilationUnit targetCU;
        boolean isSuperInvocation;
        Expression sender;
        List arguments;
        MethodInvocation methodImpl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        ASTNode invocationNode = nameNode.getParent();
        if (invocationNode instanceof MethodInvocation) {
            methodImpl = (MethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getExpression();
            isSuperInvocation = false;
        } else if (invocationNode instanceof SuperMethodInvocation) {
            methodImpl = (SuperMethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getQualifier();
            isSuperInvocation = true;
        } else {
            return;
        }
        String methodName = nameNode.getIdentifier();
        int nArguments = arguments.size();
        IBinding[] bindings = new ScopeAnalyzer(astRoot).getDeclarationsInScope(nameNode, 1);
        HashSet<String> suggestedRenames = new HashSet<String>();
        int i = 0;
        while (i < bindings.length) {
            IMethodBinding binding = (IMethodBinding)bindings[i];
            String curr = binding.getName();
            if (!curr.equals(methodName) && binding.getParameterTypes().length == nArguments && NameMatcher.isSimilarName(methodName, curr) && suggestedRenames.add(curr)) {
                String label2 = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changemethod.description", curr);
                proposals.add(new RenameNodeCompletionProposal(label2, context.getCompilationUnit(), problem.getOffset(), problem.getLength(), curr, 6));
            }
            ++i;
        }
        suggestedRenames = null;
        if (isOnlyParameterMismatch) {
            ArrayList<IMethodBinding> parameterMismatchs = new ArrayList<IMethodBinding>();
            int i2 = 0;
            while (i2 < bindings.length) {
                IMethodBinding binding = (IMethodBinding)bindings[i2];
                if (binding.getName().equals(methodName)) {
                    parameterMismatchs.add(binding);
                }
                ++i2;
            }
            UnresolvedElementsSubProcessor.addParameterMissmatchProposals(context, problem, parameterMismatchs, invocationNode, arguments, proposals);
        }
        ITypeBinding binding = null;
        if (sender != null) {
            binding = sender.resolveTypeBinding();
        } else {
            binding = Bindings.getBindingOfParentType(invocationNode);
            if (isSuperInvocation && binding != null) {
                binding = binding.getSuperclass();
            }
        }
        if (binding != null && binding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, binding)) != null) {
            ASTNode anonymDecl;
            Image image;
            String sig = UnresolvedElementsSubProcessor.getMethodSignature(methodName, arguments);
            if (cu.equals(targetCU)) {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createmethod.description", sig);
                image = JavaPluginImages.get("org.eclipse.jdt.ui.methpri_obj.gif");
            } else {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createmethod.other.description", new Object[]{sig, targetCU.getElementName()});
                image = JavaPluginImages.get("org.eclipse.jdt.ui.methpub_obj.gif");
            }
            proposals.add(new NewMethodCompletionProposal(label, targetCU, invocationNode, arguments, binding, 5, image));
            if (binding.isAnonymous() && cu.equals(targetCU) && sender == null && Bindings.findMethodInHierarchy(binding, methodName, null) == null && (anonymDecl = astRoot.findDeclaringNode((IBinding)binding)) != null && !(binding = Bindings.getBindingOfParentType(anonymDecl.getParent())).isAnonymous()) {
                Object[] args = new String[]{sig, binding.getName()};
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createmethod.other.description", args);
                image = JavaPluginImages.get("org.eclipse.jdt.ui.methpro_obj.gif");
                proposals.add(new NewMethodCompletionProposal(label, targetCU, invocationNode, arguments, binding, 5, image));
            }
        }
        if (!isOnlyParameterMismatch && !isSuperInvocation && sender != null) {
            UnresolvedElementsSubProcessor.addMissingCastParentsProposal(cu, (MethodInvocation)invocationNode, proposals);
        }
        if (!isSuperInvocation && sender == null && invocationNode.getParent() instanceof ThrowStatement) {
            String str = "new ";
            label = CorrectionMessages.getString("UnresolvedElementsSubProcessor.addnewkeyword.description");
            int relevance = Character.isUpperCase(methodName.charAt(0)) ? 7 : 4;
            ReplaceCorrectionProposal proposal = new ReplaceCorrectionProposal(label, cu, invocationNode.getStartPosition(), 0, str, relevance);
            proposals.add(proposal);
        }
    }

    private static void addMissingCastParentsProposal(ICompilationUnit cu, MethodInvocation invocationNode, Collection proposals) {
        Expression sender = invocationNode.getExpression();
        if (sender instanceof ThisExpression) {
            return;
        }
        ITypeBinding senderBinding = sender.resolveTypeBinding();
        if (senderBinding == null || Modifier.isFinal((int)senderBinding.getModifiers())) {
            return;
        }
        if (sender instanceof Name && ((Name)sender).resolveBinding() instanceof ITypeBinding) {
            return;
        }
        ASTNode parent = invocationNode.getParent();
        while (parent instanceof Expression && parent.getNodeType() != 11) {
            parent = parent.getParent();
        }
        boolean hasCastProposal = false;
        if (parent instanceof CastExpression) {
            hasCastProposal = UnresolvedElementsSubProcessor.useExistingParentCastProposal(cu, (CastExpression)parent, sender, invocationNode.getName(), UnresolvedElementsSubProcessor.getArgumentTypes(invocationNode.arguments()), proposals);
        }
        if (!hasCastProposal) {
            String label;
            Expression target = sender;
            while (target instanceof ParenthesizedExpression) {
                target = ((ParenthesizedExpression)target).getExpression();
            }
            if (target.getNodeType() != 11) {
                String targetName = null;
                if (target.getLength() <= 18) {
                    targetName = ASTNodes.asString((ASTNode)target);
                }
                label = targetName == null ? CorrectionMessages.getString("UnresolvedElementsSubProcessor.methodtargetcast.description") : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.methodtargetcast2.description", targetName);
            } else {
                String targetName = null;
                if (target.getLength() <= 18) {
                    targetName = ASTNodes.asString((ASTNode)((CastExpression)target).getExpression());
                }
                label = targetName == null ? CorrectionMessages.getString("UnresolvedElementsSubProcessor.changemethodtargetcast.description") : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changemethodtargetcast2.description", targetName);
            }
            proposals.add(new CastCompletionProposal(label, cu, target, null, 3));
        }
    }

    private static boolean useExistingParentCastProposal(ICompilationUnit cu, CastExpression expression, Expression accessExpression, SimpleName accessSelector, ITypeBinding[] paramTypes, Collection proposals) {
        ITypeBinding castType = expression.getType().resolveBinding();
        if (castType == null) {
            return false;
        }
        if (paramTypes != null ? Bindings.findMethodInHierarchy(castType, accessSelector.getIdentifier(), paramTypes) == null : Bindings.findFieldInHierarchy(castType, accessSelector.getIdentifier()) == null) {
            return false;
        }
        ITypeBinding bindingToCast = accessExpression.resolveTypeBinding();
        if (bindingToCast != null && !TypeRules.canCast(castType, bindingToCast)) {
            return false;
        }
        IMethodBinding res = Bindings.findMethodInHierarchy(castType, accessSelector.getIdentifier(), paramTypes);
        if (res != null) {
            AST ast = expression.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            CastExpression newCast = ast.newCastExpression();
            newCast.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)expression.getType()));
            newCast.setExpression((Expression)rewrite.createCopyTarget((ASTNode)accessExpression));
            ParenthesizedExpression parents = ast.newParenthesizedExpression();
            parents.setExpression((Expression)newCast);
            ASTNode node = rewrite.createCopyTarget((ASTNode)expression.getExpression());
            rewrite.replace((ASTNode)expression, node, null);
            rewrite.replace((ASTNode)accessExpression, (ASTNode)parents, null);
            String label = CorrectionMessages.getString("UnresolvedElementsSubProcessor.missingcastbrackets.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_cast.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 8, image);
            proposals.add(proposal);
            return true;
        }
        return false;
    }

    private static void addParameterMissmatchProposals(IInvocationContext context, IProblemLocation problem, List similarElements, ASTNode invocationNode, List arguments, Collection proposals) throws CoreException {
        int nSimilarElements = similarElements.size();
        ITypeBinding[] argTypes = UnresolvedElementsSubProcessor.getArgumentTypes(arguments);
        if (argTypes == null || nSimilarElements == 0) {
            return;
        }
        int i = 0;
        while (i < nSimilarElements) {
            IMethodBinding elem = (IMethodBinding)similarElements.get(i);
            int diff = elem.getParameterTypes().length - argTypes.length;
            if (diff == 0) {
                int nProposals = proposals.size();
                UnresolvedElementsSubProcessor.doEqualNumberOfParameters(context, invocationNode, problem, arguments, argTypes, elem, proposals);
                if (nProposals != proposals.size()) {
                    return;
                }
            } else if (diff > 0) {
                UnresolvedElementsSubProcessor.doMoreParameters(context, problem, invocationNode, arguments, argTypes, elem, proposals);
            } else {
                UnresolvedElementsSubProcessor.doMoreArguments(context, problem, invocationNode, arguments, argTypes, elem, proposals);
            }
            ++i;
        }
    }

    private static void doMoreParameters(IInvocationContext context, IProblemLocation problem, ASTNode invocationNode, List arguments, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection proposals) throws CoreException {
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int k = 0;
        int nSkipped = 0;
        int diff = paramTypes.length - argTypes.length;
        int[] indexSkipped = new int[diff];
        int i = 0;
        while (i < paramTypes.length) {
            if (k < argTypes.length && TypeRules.canAssign(argTypes[k], paramTypes[i])) {
                ++k;
            } else {
                if (nSkipped >= diff) {
                    return;
                }
                indexSkipped[nSkipped++] = i;
            }
            ++i;
        }
        ITypeBinding declaringType = methodBinding.getDeclaringClass();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        Object[] arg = new String[]{UnresolvedElementsSubProcessor.getMethodSignature(methodBinding, false)};
        String label = diff == 1 ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.addargument.description", arg) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.addarguments.description", arg);
        AddArgumentCorrectionProposal proposal = new AddArgumentCorrectionProposal(label, context.getCompilationUnit(), invocationNode, indexSkipped, paramTypes, 8);
        proposal.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif"));
        proposals.add(proposal);
        if (!declaringType.isFromSource()) {
            return;
        }
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        if (targetCU != null) {
            ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[paramTypes.length];
            ITypeBinding[] changedTypes = new ITypeBinding[diff];
            int i2 = diff - 1;
            while (i2 >= 0) {
                int idx = indexSkipped[i2];
                changeDesc[idx] = new ChangeMethodSignatureProposal.RemoveDescription();
                changedTypes[i2] = paramTypes[idx];
                --i2;
            }
            Object[] arg2 = new String[]{UnresolvedElementsSubProcessor.getMethodSignature(methodBinding, !cu.equals(targetCU)), UnresolvedElementsSubProcessor.getTypeNames(changedTypes)};
            String label2 = methodBinding.isConstructor() ? (diff == 1 ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.removeparam.constr.description", arg2) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.removeparams.constr.description", arg2)) : (diff == 1 ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.removeparam.description", arg2) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.removeparams.description", arg2));
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.remove_correction.gif");
            ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU, invocationNode, methodBinding, changeDesc, null, 5, image);
            proposals.add(proposal2);
        }
    }

    private static String getTypeNames(ITypeBinding[] types) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(types[i].getName());
            ++i;
        }
        return buf.toString();
    }

    private static String getArgumentName(ICompilationUnit cu, List arguments, int index) {
        String def = String.valueOf(index + 1);
        ASTNode expr = (ASTNode)arguments.get(index);
        if (expr.getLength() > 18) {
            return def;
        }
        ASTMatcher matcher = new ASTMatcher();
        int i = 0;
        while (i < arguments.size()) {
            if (i != index && matcher.safeSubtreeMatch((Object)expr, arguments.get(i))) {
                return def;
            }
            ++i;
        }
        return String.valueOf('\'') + ASTNodes.asString(expr) + '\'';
    }

    private static void doMoreArguments(IInvocationContext context, IProblemLocation problem, ASTNode invocationNode, List arguments, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection proposals) throws CoreException {
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int k = 0;
        int nSkipped = 0;
        int diff = argTypes.length - paramTypes.length;
        int[] indexSkipped = new int[diff];
        int i = 0;
        while (i < argTypes.length) {
            if (k < paramTypes.length && TypeRules.canAssign(argTypes[i], paramTypes[k])) {
                ++k;
            } else {
                if (nSkipped >= diff) {
                    return;
                }
                indexSkipped[nSkipped++] = i;
            }
            ++i;
        }
        ITypeBinding declaringType = methodBinding.getDeclaringClass();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        int i2 = diff - 1;
        while (i2 >= 0) {
            rewrite.remove((ASTNode)((Expression)arguments.get(indexSkipped[i2])), null);
            --i2;
        }
        Object[] arg = new String[]{UnresolvedElementsSubProcessor.getMethodSignature(methodBinding, false)};
        String label = diff == 1 ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.removeargument.description", arg) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.removearguments.description", arg);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.remove_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 8, image);
        proposals.add(proposal);
        if (!declaringType.isFromSource()) {
            return;
        }
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        if (targetCU != null) {
            boolean isDifferentCU;
            boolean bl = isDifferentCU = !cu.equals(targetCU);
            if (UnresolvedElementsSubProcessor.isImplicitConstructor(methodBinding, targetCU)) {
                return;
            }
            ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[argTypes.length];
            ITypeBinding[] changeTypes = new ITypeBinding[diff];
            int i3 = diff - 1;
            while (i3 >= 0) {
                int idx = indexSkipped[i3];
                Expression arg2 = (Expression)arguments.get(idx);
                String name = arg2 instanceof SimpleName ? ((SimpleName)arg2).getIdentifier() : null;
                ITypeBinding newType = Bindings.normalizeTypeBinding(argTypes[idx]);
                if (newType == null) {
                    newType = astRoot.getAST().resolveWellKnownType("java.lang.Object");
                }
                changeDesc[idx] = new ChangeMethodSignatureProposal.InsertDescription(newType, name);
                changeTypes[i3] = newType;
                --i3;
            }
            Object[] arg3 = new String[]{UnresolvedElementsSubProcessor.getMethodSignature(methodBinding, isDifferentCU), UnresolvedElementsSubProcessor.getTypeNames(changeTypes)};
            String label2 = methodBinding.isConstructor() ? (diff == 1 ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.addparam.constr.description", arg3) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.addparams.constr.description", arg3)) : (diff == 1 ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.addparam.description", arg3) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.addparams.description", arg3));
            Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
            ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU, invocationNode, methodBinding, changeDesc, null, 5, image2);
            proposals.add(proposal2);
        }
    }

    private static boolean isImplicitConstructor(IMethodBinding meth, ICompilationUnit targetCU) {
        if (meth.isConstructor() && meth.getParameterTypes().length == 0) {
            IMethodBinding[] bindings = meth.getDeclaringClass().getDeclaredMethods();
            int i = 0;
            while (i < bindings.length) {
                IMethodBinding curr = bindings[i];
                if (curr.isConstructor() && curr != meth) {
                    return false;
                }
                ++i;
            }
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setSource(targetCU);
            parser.setFocalPosition(0);
            parser.setResolveBindings(true);
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            return unit.findDeclaringNode(meth.getKey()) == null;
        }
        return false;
    }

    private static String getMethodSignature(IMethodBinding binding, boolean inOtherCU) {
        StringBuffer buf = new StringBuffer();
        if (inOtherCU && !binding.isConstructor()) {
            buf.append(binding.getDeclaringClass().getName()).append('.');
        }
        buf.append(binding.getName());
        return UnresolvedElementsSubProcessor.getMethodSignature(buf.toString(), binding.getParameterTypes());
    }

    private static String getMethodSignature(String name, List args) {
        ITypeBinding[] params = new ITypeBinding[args.size()];
        int i = 0;
        while (i < args.size()) {
            Expression expr = (Expression)args.get(i);
            ITypeBinding curr = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
            if (curr == null) {
                curr = expr.getAST().resolveWellKnownType("java.lang.Object");
            }
            params[i] = curr;
            ++i;
        }
        return UnresolvedElementsSubProcessor.getMethodSignature(name, params);
    }

    private static String getMethodSignature(String name, ITypeBinding[] params) {
        StringBuffer buf = new StringBuffer();
        buf.append(name).append('(');
        int i = 0;
        while (i < params.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(params[i].getName());
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    private static void doEqualNumberOfParameters(IInvocationContext context, ASTNode invocationNode, IProblemLocation problem, List arguments, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection proposals) throws CoreException {
        ICompilationUnit targetCU;
        Object[] arg;
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int[] indexOfDiff = new int[paramTypes.length];
        int nDiffs = 0;
        int n = 0;
        while (n < argTypes.length) {
            if (!TypeRules.canAssign(argTypes[n], paramTypes[n])) {
                indexOfDiff[nDiffs++] = n;
            }
            ++n;
        }
        ITypeBinding declaringType = methodBinding.getDeclaringClass();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode nameNode = problem.getCoveringNode(astRoot);
        if (nameNode == null) {
            return;
        }
        if (nDiffs == 0) {
            MethodInvocation inv;
            if (nameNode.getParent() instanceof MethodInvocation && (inv = (MethodInvocation)nameNode.getParent()).getExpression() == null) {
                UnresolvedElementsSubProcessor.addQualifierToOuterProposal(context, inv, methodBinding, proposals);
            }
            return;
        }
        if (nDiffs == 1) {
            int idx = indexOfDiff[0];
            Expression nodeToCast = (Expression)arguments.get(idx);
            ITypeBinding castType = paramTypes[idx];
            ITypeBinding binding = nodeToCast.resolveTypeBinding();
            if (binding == null || TypeRules.canCast(castType, binding)) {
                String castTypeName = castType.getQualifiedName();
                ASTRewriteCorrectionProposal proposal = TypeMismatchSubProcessor.createCastProposal(context, castTypeName, nodeToCast, 6);
                arg = new String[]{UnresolvedElementsSubProcessor.getArgumentName(cu, arguments, idx), castTypeName};
                proposal.setDisplayName(CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.addargumentcast.description", arg));
                proposals.add(proposal);
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, nodeToCast, castType, false, 5, proposals);
        }
        if (nDiffs == 2) {
            boolean canSwap;
            int idx1 = indexOfDiff[0];
            int idx2 = indexOfDiff[1];
            boolean bl = canSwap = TypeRules.canAssign(argTypes[idx1], paramTypes[idx2]) && TypeRules.canAssign(argTypes[idx2], paramTypes[idx1]);
            if (canSwap) {
                ICompilationUnit targetCU2;
                Expression arg1 = (Expression)arguments.get(idx1);
                Expression arg2 = (Expression)arguments.get(idx2);
                ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
                rewrite.replace((ASTNode)arg1, rewrite.createCopyTarget((ASTNode)arg2), null);
                rewrite.replace((ASTNode)arg2, rewrite.createCopyTarget((ASTNode)arg1), null);
                arg = new String[]{UnresolvedElementsSubProcessor.getArgumentName(cu, arguments, idx1), UnresolvedElementsSubProcessor.getArgumentName(cu, arguments, idx2)};
                String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.swaparguments.description", arg);
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 8, image);
                proposals.add(proposal);
                if (declaringType.isFromSource() && (targetCU2 = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType)) != null) {
                    ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[paramTypes.length];
                    int i = 0;
                    while (i < nDiffs) {
                        changeDesc[idx1] = new ChangeMethodSignatureProposal.SwapDescription(idx2);
                        ++i;
                    }
                    ITypeBinding[] swappedTypes = new ITypeBinding[]{paramTypes[idx1], paramTypes[idx2]};
                    Object[] args = new String[]{UnresolvedElementsSubProcessor.getMethodSignature(methodBinding, !targetCU2.equals(cu)), UnresolvedElementsSubProcessor.getTypeNames(swappedTypes)};
                    String label2 = methodBinding.isConstructor() ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.swapparams.constr.description", args) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.swapparams.description", args);
                    Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                    ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU2, invocationNode, methodBinding, changeDesc, null, 5, image2);
                    proposals.add(proposal2);
                }
                return;
            }
        }
        if (declaringType.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType)) != null) {
            ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[paramTypes.length];
            int i = 0;
            while (i < nDiffs) {
                int diffIndex = indexOfDiff[i];
                Expression arg2 = (Expression)arguments.get(diffIndex);
                String name = arg2 instanceof SimpleName ? ((SimpleName)arg2).getIdentifier() : null;
                changeDesc[diffIndex] = new ChangeMethodSignatureProposal.EditDescription(argTypes[diffIndex], name);
                ++i;
            }
            ITypeBinding[] newParamTypes = new ITypeBinding[changeDesc.length];
            int i2 = 0;
            while (i2 < newParamTypes.length) {
                newParamTypes[i2] = changeDesc[i2] == null ? paramTypes[i2] : ((ChangeMethodSignatureProposal.EditDescription)changeDesc[i2]).type;
                ++i2;
            }
            Object[] args = new String[]{UnresolvedElementsSubProcessor.getMethodSignature(methodBinding, !targetCU.equals(cu)), UnresolvedElementsSubProcessor.getMethodSignature(methodBinding.getName(), newParamTypes)};
            String label = methodBinding.isConstructor() ? CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changeparamsignature.constr.description", args) : CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changeparamsignature.description", args);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ChangeMethodSignatureProposal proposal = new ChangeMethodSignatureProposal(label, targetCU, invocationNode, methodBinding, changeDesc, null, 7, image);
            proposals.add(proposal);
        }
    }

    private static ITypeBinding[] getArgumentTypes(List arguments) {
        ITypeBinding[] res = new ITypeBinding[arguments.size()];
        int i = 0;
        while (i < res.length) {
            Expression expression = (Expression)arguments.get(i);
            ITypeBinding curr = expression.resolveTypeBinding();
            if (curr == null) {
                return null;
            }
            if (!curr.isNullType() && (curr = Bindings.normalizeTypeBinding(curr)) == null) {
                curr = expression.getAST().resolveWellKnownType("java.lang.Object");
            }
            res[i] = curr;
            ++i;
        }
        return res;
    }

    private static void addQualifierToOuterProposal(IInvocationContext context, MethodInvocation invocationNode, IMethodBinding binding, Collection proposals) throws CoreException {
        Name newExpression;
        ITypeBinding parentType;
        ITypeBinding declaringType = binding.getDeclaringClass();
        ITypeBinding currType = parentType = Bindings.getBindingOfParentType((ASTNode)invocationNode);
        boolean isInstanceMethod = !Modifier.isStatic((int)binding.getModifiers());
        while (currType != null && !Bindings.isSuperType(declaringType, currType)) {
            if (isInstanceMethod && Modifier.isStatic((int)currType.getModifiers())) {
                return;
            }
            currType = currType.getDeclaringClass();
        }
        if (currType == null || currType == parentType) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)invocationNode.getAST());
        ImportRewrite imports = new ImportRewrite(context.getCompilationUnit());
        AST ast = invocationNode.getAST();
        String qualifier = imports.addImport(currType);
        Name name = ASTNodeFactory.newName(ast, qualifier);
        if (isInstanceMethod) {
            ThisExpression expr = ast.newThisExpression();
            expr.setQualifier(name);
            newExpression = expr;
        } else {
            newExpression = name;
        }
        rewrite.set((ASTNode)invocationNode, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)newExpression, null);
        String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changetoouter.description", currType.getName());
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 8, image);
        proposal.setImportRewrite(imports);
        proposals.add(proposal);
    }

    public static void getConstructorProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit targetCU;
        ITypeBinding typeBinding;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ITypeBinding targetBinding = null;
        List arguments = null;
        IMethodBinding recursiveConstructor = null;
        int type = selectedNode.getNodeType();
        if (type == 14) {
            ClassInstanceCreation creation = (ClassInstanceCreation)selectedNode;
            IBinding binding = creation.getName().resolveBinding();
            if (binding instanceof ITypeBinding) {
                targetBinding = (ITypeBinding)binding;
                arguments = creation.arguments();
            }
        } else if (type == 46) {
            typeBinding = Bindings.getBindingOfParentType(selectedNode);
            if (typeBinding != null && !typeBinding.isAnonymous()) {
                targetBinding = typeBinding.getSuperclass();
                arguments = ((SuperConstructorInvocation)selectedNode).arguments();
            }
        } else if (type == 17 && (typeBinding = Bindings.getBindingOfParentType(selectedNode)) != null && !typeBinding.isAnonymous()) {
            targetBinding = typeBinding;
            arguments = ((ConstructorInvocation)selectedNode).arguments();
            recursiveConstructor = ASTResolving.findParentMethodDeclaration(selectedNode).resolveBinding();
        }
        if (targetBinding == null) {
            return;
        }
        IMethodBinding[] methods = targetBinding.getDeclaredMethods();
        ArrayList<IMethodBinding> similarElements = new ArrayList<IMethodBinding>();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding curr = methods[i];
            if (curr.isConstructor() && recursiveConstructor != curr) {
                similarElements.add(curr);
            }
            ++i;
        }
        UnresolvedElementsSubProcessor.addParameterMissmatchProposals(context, problem, similarElements, selectedNode, arguments, proposals);
        if (targetBinding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, targetBinding)) != null) {
            Object[] args = new String[]{UnresolvedElementsSubProcessor.getMethodSignature(targetBinding.getName(), arguments)};
            String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createconstructor.description", args);
            Image image = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE);
            proposals.add(new NewMethodCompletionProposal(label, targetCU, selectedNode, arguments, targetBinding, 5, image));
        }
    }

    public static void getAmbiguosTypeReferenceProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        int offset = problem.getOffset();
        int len = problem.getLength();
        IJavaElement[] elements = cu.codeSelect(offset, len);
        int i = 0;
        while (i < elements.length) {
            IJavaElement curr = elements[i];
            if (curr instanceof IType && !TypeFilter.isFiltered((IType)curr)) {
                String qualifiedTypeName = JavaModelUtil.getFullyQualifiedName((IType)curr);
                ImportRewrite imports = new ImportRewrite(cu);
                imports.setFindAmbiguosImports(true);
                imports.addImport(qualifiedTypeName);
                String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.importexplicit.description", qualifiedTypeName);
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.imp_obj.gif");
                CUCorrectionProposal proposal = new CUCorrectionProposal(label, cu, 5, image);
                proposal.setImportRewrite(imports);
                proposals.add(proposal);
            }
            ++i;
        }
    }

    public static void getArrayAccessProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        CompilationUnit root = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(root);
        if (!(selectedNode instanceof MethodInvocation)) {
            return;
        }
        MethodInvocation decl = (MethodInvocation)selectedNode;
        SimpleName nameNode = decl.getName();
        String methodName = nameNode.getIdentifier();
        IBinding[] bindings = new ScopeAnalyzer(root).getDeclarationsInScope(nameNode, 1);
        int i = 0;
        while (i < bindings.length) {
            String currName = bindings[i].getName();
            if (NameMatcher.isSimilarName(methodName, currName)) {
                String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.arraychangetomethod.description", currName);
                proposals.add(new RenameNodeCompletionProposal(label, context.getCompilationUnit(), nameNode.getStartPosition(), nameNode.getLength(), currName, 6));
            }
            ++i;
        }
        String lengthId = "length";
        String label = CorrectionMessages.getString("UnresolvedElementsSubProcessor.arraychangetolength.description");
        int offset = nameNode.getStartPosition();
        int length = decl.getStartPosition() + decl.getLength() - offset;
        proposals.add(new RenameNodeCompletionProposal(label, context.getCompilationUnit(), offset, length, lengthId, 7));
    }
}

