/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;

public class CPListLabelProvider
extends LabelProvider {
    private String fNewLabel = NewWizardMessages.getString("CPListLabelProvider.new");
    private String fClassLabel = NewWizardMessages.getString("CPListLabelProvider.classcontainer");
    private String fCreateLabel = NewWizardMessages.getString("CPListLabelProvider.willbecreated");
    private ImageDescriptor fJarIcon;
    private ImageDescriptor fExtJarIcon;
    private ImageDescriptor fJarWSrcIcon;
    private ImageDescriptor fExtJarWSrcIcon;
    private ImageDescriptor fFolderImage;
    private ImageDescriptor fProjectImage;
    private ImageDescriptor fVariableImage;
    private ImageDescriptor fContainerImage;
    private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();

    public CPListLabelProvider() {
        this.fJarIcon = JavaPluginImages.DESC_OBJS_JAR;
        this.fExtJarIcon = JavaPluginImages.DESC_OBJS_EXTJAR;
        this.fJarWSrcIcon = JavaPluginImages.DESC_OBJS_JAR_WSRC;
        this.fExtJarWSrcIcon = JavaPluginImages.DESC_OBJS_EXTJAR_WSRC;
        this.fFolderImage = JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT;
        this.fContainerImage = JavaPluginImages.DESC_OBJS_LIBRARY;
        this.fVariableImage = JavaPluginImages.DESC_OBJS_ENV_VAR;
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public String getText(Object element) {
        if (element instanceof CPListElement) {
            return this.getCPListElementText((CPListElement)element);
        }
        if (element instanceof CPListElementAttribute) {
            return this.getCPListElementAttributeText((CPListElementAttribute)element);
        }
        if (element instanceof CPUserLibraryElement) {
            return this.getCPUserLibraryText((CPUserLibraryElement)element);
        }
        return super.getText(element);
    }

    public String getCPUserLibraryText(CPUserLibraryElement element) {
        String name = element.getName();
        if (element.isSystemLibrary()) {
            name = NewWizardMessages.getFormattedString("CPListLabelProvider.systemlibrary", name);
        }
        return name;
    }

    public String getCPListElementAttributeText(CPListElementAttribute attrib) {
        String notAvailable = NewWizardMessages.getString("CPListLabelProvider.none");
        StringBuffer buf = new StringBuffer();
        String key = attrib.getKey();
        if (key.equals("sourcepath")) {
            buf.append(NewWizardMessages.getString("CPListLabelProvider.source_attachment.label"));
            IPath path = (IPath)attrib.getValue();
            if (path != null && !path.isEmpty()) {
                if (attrib.getParent().getEntryKind() == 4) {
                    buf.append(this.getVariableString(path));
                } else {
                    buf.append(this.getPathString(path, path.getDevice() != null));
                }
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("rootpath")) {
            buf.append(NewWizardMessages.getString("CPListLabelProvider.source_attachment_root.label"));
            IPath path = (IPath)attrib.getValue();
            if (path != null && !path.isEmpty()) {
                buf.append(path.toString());
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("javadoc")) {
            buf.append(NewWizardMessages.getString("CPListLabelProvider.javadoc_location.label"));
            URL path = (URL)attrib.getValue();
            if (path != null) {
                String prefix;
                String str = path.toExternalForm();
                if (str.startsWith(prefix = "jar:file:/")) {
                    int sepIndex = str.lastIndexOf(33);
                    if (sepIndex == -1) {
                        buf.append(str.substring(prefix.length()));
                    } else {
                        String archive = str.substring(prefix.length(), sepIndex);
                        String root = str.substring(sepIndex + 1);
                        if (root.length() > 0 && !root.equals(String.valueOf('/'))) {
                            buf.append(NewWizardMessages.getFormattedString("CPListLabelProvider.twopart", new String[]{archive, root}));
                        } else {
                            buf.append(archive);
                        }
                    }
                } else {
                    buf.append(str);
                }
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("output")) {
            buf.append(NewWizardMessages.getString("CPListLabelProvider.output_folder.label"));
            IPath path = (IPath)attrib.getValue();
            if (path != null) {
                buf.append(path.makeRelative().toString());
            } else {
                buf.append(NewWizardMessages.getString("CPListLabelProvider.default_output_folder.label"));
            }
        } else if (key.equals("exclusion")) {
            buf.append(NewWizardMessages.getString("CPListLabelProvider.exclusion_filter.label"));
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int i = 0;
                while (i < patterns.length) {
                    if (i > 0) {
                        buf.append(NewWizardMessages.getString("CPListLabelProvider.exclusion_filter_separator"));
                    }
                    buf.append(patterns[i].toString());
                    ++i;
                }
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("inclusion")) {
            buf.append(NewWizardMessages.getString("CPListLabelProvider.inclusion_filter.label"));
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int i = 0;
                while (i < patterns.length) {
                    if (i > 0) {
                        buf.append(NewWizardMessages.getString("CPListLabelProvider.inclusion_filter_separator"));
                    }
                    buf.append(patterns[i].toString());
                    ++i;
                }
            } else {
                buf.append(NewWizardMessages.getString("CPListLabelProvider.all"));
            }
        }
        return buf.toString();
    }

    public String getCPListElementText(CPListElement cpentry) {
        IPath path = cpentry.getPath();
        switch (cpentry.getEntryKind()) {
            case 1: {
                IResource resource = cpentry.getResource();
                if (resource instanceof IContainer) {
                    StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                    buf.append(' ');
                    buf.append(this.fClassLabel);
                    if (!resource.exists()) {
                        buf.append(' ');
                        if (cpentry.isMissing()) {
                            buf.append(this.fCreateLabel);
                        } else {
                            buf.append(this.fNewLabel);
                        }
                    }
                    return buf.toString();
                }
                if (ArchiveFileFilter.isArchivePath(path)) {
                    return this.getPathString(path, resource == null);
                }
                return path.makeRelative().toString();
            }
            case 4: {
                return this.getVariableString(path);
            }
            case 2: {
                return path.lastSegment();
            }
            case 5: {
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)cpentry.getJavaProject());
                    if (container != null) {
                        return container.getDescription();
                    }
                    ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)path.segment(0));
                    if (initializer != null) {
                        String description = initializer.getDescription(path, cpentry.getJavaProject());
                        return NewWizardMessages.getFormattedString("CPListLabelProvider.unbound_library", description);
                    }
                }
                catch (JavaModelException javaModelException) {}
                return path.toString();
            }
            case 3: {
                StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                IResource resource = cpentry.getResource();
                if (resource != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.isMissing()) {
                        buf.append(this.fCreateLabel);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                }
                return buf.toString();
            }
        }
        return NewWizardMessages.getString("CPListLabelProvider.unknown_element.label");
    }

    private String getPathString(IPath path, boolean isExternal) {
        if (ArchiveFileFilter.isArchivePath(path)) {
            IPath appendedPath = path.removeLastSegments(1);
            String appended = isExternal ? appendedPath.toOSString() : appendedPath.makeRelative().toString();
            return NewWizardMessages.getFormattedString("CPListLabelProvider.twopart", new String[]{path.lastSegment(), appended});
        }
        return isExternal ? path.toOSString() : path.makeRelative().toString();
    }

    private String getVariableString(IPath path) {
        String name = path.makeRelative().toString();
        IPath entryPath = JavaCore.getClasspathVariable((String)path.segment(0));
        if (entryPath != null) {
            String appended = entryPath.append(path.removeFirstSegments(1)).toOSString();
            return NewWizardMessages.getFormattedString("CPListLabelProvider.twopart", new String[]{name, appended});
        }
        return name;
    }

    private ImageDescriptor getCPListElementBaseImage(CPListElement cpentry) {
        switch (cpentry.getEntryKind()) {
            case 3: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fFolderImage;
            }
            case 1: {
                IResource res = cpentry.getResource();
                IPath path = (IPath)cpentry.getAttribute("sourcepath");
                if (res == null) {
                    if (path == null || path.isEmpty()) {
                        return this.fExtJarIcon;
                    }
                    return this.fExtJarWSrcIcon;
                }
                if (res instanceof IFile) {
                    if (path == null || path.isEmpty()) {
                        return this.fJarIcon;
                    }
                    return this.fJarWSrcIcon;
                }
                return this.fFolderImage;
            }
            case 2: {
                return this.fProjectImage;
            }
            case 4: {
                return this.fVariableImage;
            }
            case 5: {
                return this.fContainerImage;
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof CPListElement) {
            CPListElement cpentry = (CPListElement)element;
            Object imageDescriptor = this.getCPListElementBaseImage(cpentry);
            if (imageDescriptor != null) {
                if (cpentry.isMissing()) {
                    imageDescriptor = new JavaElementImageDescriptor((ImageDescriptor)imageDescriptor, 32, JavaElementImageProvider.SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)imageDescriptor);
            }
        } else {
            if (element instanceof CPListElementAttribute) {
                String key = ((CPListElementAttribute)element).getKey();
                if (key.equals("sourcepath")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_SOURCE_ATTACH_ATTRIB);
                }
                if (key.equals("javadoc")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_JAVADOC_LOCATION_ATTRIB);
                }
                if (key.equals("output")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_OUTPUT_FOLDER_ATTRIB);
                }
                if (key.equals("exclusion")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB);
                }
                if (key.equals("inclusion")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB);
                }
                return this.fRegistry.get(this.fVariableImage);
            }
            if (element instanceof CPUserLibraryElement) {
                return this.fRegistry.get(JavaPluginImages.DESC_OBJS_LIBRARY);
            }
        }
        return null;
    }
}

