/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;

public final class Utils
implements IPDEBuildConstants {
    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getArrayFromStringWithBlank(String list, String separator) {
        if (list == null || list.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean previousWasSeparator = true;
        StringTokenizer tokens = new StringTokenizer(list, separator, true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals(separator)) {
                if (previousWasSeparator) {
                    result.add("");
                }
                previousWasSeparator = true;
                continue;
            }
            result.add(token);
            previousWasSeparator = false;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getArrayFromString(String list) {
        return Utils.getArrayFromString(list, ",");
    }

    public static URL[] asURL(String[] target) throws CoreException {
        if (target == null) {
            return null;
        }
        try {
            URL[] result = new URL[target.length];
            int i = 0;
            while (i < target.length) {
                result[i] = new URL(target[i]);
                ++i;
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, e.getMessage(), (Throwable)e));
        }
    }

    public static URL[] asURL(Collection target) throws CoreException {
        if (target == null) {
            return null;
        }
        try {
            URL[] result = new URL[target.size()];
            int i = 0;
            Iterator iter = target.iterator();
            while (iter.hasNext()) {
                result[i++] = ((File)iter.next()).toURL();
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, e.getMessage(), (Throwable)e));
        }
    }

    public static String getStringFromCollection(Collection collection, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(i.next());
        }
        return result.toString();
    }

    public static String getStringFromArray(String[] values, String separator) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(values[i]);
            ++i;
        }
        return result.toString();
    }

    protected static List findRootNodes(Map counts) {
        ArrayList result = new ArrayList(5);
        Iterator i = counts.keySet().iterator();
        while (i.hasNext()) {
            Object node = i.next();
            int count = (Integer)counts.get(node);
            if (count != 0) continue;
            result.add(node);
        }
        return result;
    }

    public static ArrayList getArrayList(Object[] args) {
        ArrayList<Object> result = new ArrayList<Object>(args.length);
        int i = 0;
        while (i < args.length) {
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    public static IPath makeRelative(IPath location, IPath base) {
        if (location.getDevice() != null && !location.getDevice().equalsIgnoreCase(base.getDevice())) {
            return location;
        }
        int baseCount = base.segmentCount();
        int count = base.matchingFirstSegments(location);
        String temp = "";
        int j = 0;
        while (j < baseCount - count) {
            temp = String.valueOf(temp) + "../";
            ++j;
        }
        return new Path(temp).append(location.removeFirstSegments(count));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead != -1) {
                    destination.write(buffer, 0, bytesRead);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {}
        source.close();
        try {}
        catch (IOException iOException) {
            return;
        }
        destination.close();
    }

    public static IPluginEntry[] getPluginEntry(IFeature feature, String pluginId, boolean raw) {
        IPluginEntry[] plugins = raw ? feature.getRawPluginEntries() : feature.getPluginEntries();
        ArrayList<IPluginEntry> foundEntries = new ArrayList<IPluginEntry>(5);
        int i = 0;
        while (i < plugins.length) {
            if (plugins[i].getVersionedIdentifier().getIdentifier().equals(pluginId)) {
                foundEntries.add(plugins[i]);
            }
            ++i;
        }
        return foundEntries.toArray(new IPluginEntry[foundEntries.size()]);
    }

    public static Collection findFiles(String from, String foldername, final String filename) {
        File root = new File(from);
        if (root.isFile() && root.getName().equals(filename)) {
            ArrayList<File> coll = new ArrayList<File>(1);
            coll.add(root);
            return coll;
        }
        String featureDirectory = String.valueOf(from) + '/' + foldername;
        ArrayList<File> collectedElements = new ArrayList<File>(10);
        File[] featureDirectoryContent = new File(featureDirectory).listFiles();
        if (featureDirectoryContent == null) {
            return null;
        }
        int i = 0;
        while (i < featureDirectoryContent.length) {
            File[] featureFiles;
            if (featureDirectoryContent[i].isDirectory() && (featureFiles = featureDirectoryContent[i].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equals(filename);
                }
            })).length != 0) {
                collectedElements.add(featureFiles[0]);
            }
            ++i;
        }
        return collectedElements;
    }

    public static boolean isIn(IPluginEntry[] array, IPluginEntry element) {
        int i = 0;
        while (i < array.length) {
            if (array[i].getVersionedIdentifier().equals((Object)element.getVersionedIdentifier())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Collection copyFiles(String fromDir, String toDir) throws CoreException {
        File[] files;
        File templateLocation = new File(fromDir);
        ArrayList<String> copiedFiles = new ArrayList<String>();
        if (templateLocation.exists() && (files = templateLocation.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory()) {
                    FileInputStream inputStream = null;
                    FileOutputStream outputStream = null;
                    try {
                        inputStream = new FileInputStream(files[i]);
                    }
                    catch (FileNotFoundException e) {
                        String message = Policy.bind("exception.missingFile", files[i].getAbsolutePath());
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
                    }
                    String fileToCopy = String.valueOf(toDir) + '/' + files[i].getName();
                    try {
                        outputStream = new FileOutputStream(fileToCopy);
                    }
                    catch (FileNotFoundException e) {
                        String message = Policy.bind("exception.missingFile", fileToCopy);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
                    }
                    try {
                        Utils.transferStreams(inputStream, outputStream);
                        copiedFiles.add(files[i].getName());
                    }
                    catch (IOException e) {
                        String message = Policy.bind("exception.writingFile", fileToCopy);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                    }
                }
                ++i;
            }
        }
        return copiedFiles;
    }

    public static List extractPlugins(List initialList, List toExtract) {
        if (initialList.size() == toExtract.size()) {
            return initialList;
        }
        ArrayList result = new ArrayList(toExtract.size());
        Iterator iter = initialList.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!toExtract.contains(element)) continue;
            result.add(element);
            if (result.size() == toExtract.size()) break;
        }
        return result;
    }

    public static List computePrerequisiteOrder(List plugins) {
        BundleDescription current;
        ArrayList<Relation> prereqs = new ArrayList<Relation>(plugins.size());
        ArrayList<BundleDescription> fragments = new ArrayList<BundleDescription>();
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            current = (BundleDescription)iter.next();
            if (current.getHost() != null) {
                fragments.add(current);
                continue;
            }
            boolean found = false;
            BundleDescription[] prereqList = PDEState.getDependentBundles(current);
            int j = 0;
            while (j < prereqList.length) {
                if (plugins.contains(prereqList[j])) {
                    found = true;
                    prereqs.add(new Relation(current, prereqList[j]));
                }
                ++j;
            }
            if (found) continue;
            prereqs.add(new Relation(current, null));
        }
        iter = fragments.iterator();
        while (iter.hasNext()) {
            current = (BundleDescription)iter.next();
            if (plugins.contains(current.getHost().getBundle())) {
                prereqs.add(new Relation(current, current.getHost().getSupplier()));
            } else {
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 16, Policy.bind("exception.hostNotFound", current.getSymbolicName()), null));
            }
            BundleDescription[] prereqList = PDEState.getDependentBundles(current);
            int j = 0;
            while (j < prereqList.length) {
                if (plugins.contains(prereqList[j])) {
                    prereqs.add(new Relation(current, prereqList[j]));
                }
                ++j;
            }
        }
        return Utils.computeNodeOrder(prereqs);
    }

    protected static List computeNodeOrder(List edges) {
        Map counts = Utils.computeCounts(edges);
        ArrayList nodes = new ArrayList(counts.size());
        while (!counts.isEmpty()) {
            List roots = Utils.findRootNodes(counts);
            if (roots.isEmpty()) break;
            Iterator i = roots.iterator();
            while (i.hasNext()) {
                counts.remove(i.next());
            }
            nodes.addAll(roots);
            Utils.removeArcs(edges, roots, counts);
        }
        return nodes;
    }

    protected static Map computeCounts(List mappings) {
        HashMap<Object, Integer> counts = new HashMap<Object, Integer>(5);
        int i = 0;
        while (i < mappings.size()) {
            Object from = ((Relation)mappings.get((int)i)).from;
            Integer fromCount = (Integer)counts.get(from);
            Object to = ((Relation)mappings.get((int)i)).to;
            if (to == null) {
                counts.put(from, new Integer(0));
            } else {
                if ((Integer)counts.get(to) == null) {
                    counts.put(to, new Integer(0));
                }
                fromCount = fromCount == null ? new Integer(1) : new Integer(fromCount + 1);
                counts.put(from, fromCount);
            }
            ++i;
        }
        return counts;
    }

    protected static void removeArcs(List edges, List roots, Map counts) {
        Iterator j = roots.iterator();
        while (j.hasNext()) {
            Object root = j.next();
            int i = 0;
            while (i < edges.size()) {
                Object input;
                Integer count;
                if (root.equals(((Relation)edges.get((int)i)).to) && (count = (Integer)counts.get(input = ((Relation)edges.get((int)i)).from)) != null) {
                    counts.put(input, new Integer(count - 1));
                }
                ++i;
            }
        }
    }

    public static boolean isStringIn(String[] searched, String toSearch) {
        int i = 0;
        while (i < searched.length) {
            if (toSearch.startsWith(searched[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class Relation {
        Object from;
        Object to;

        Relation(Object from, Object to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return String.valueOf(this.from.toString()) + "->" + (this.to == null ? "" : this.to.toString());
        }
    }
}

