/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class TextContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};

    public int describe(Reader contents, IContentDescription description) throws IOException {
        return 1;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        if (description == null || !description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            return 1;
        }
        byte[] bom = this.getByteOrderMark(contents);
        if (bom != null) {
            description.setProperty(IContentDescription.BYTE_ORDER_MARK, bom);
        }
        return 1;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    byte[] getByteOrderMark(InputStream input) throws IOException {
        int first = input.read() & 0xFF;
        int second = input.read() & 0xFF;
        if (first == -1 || second == -1) {
            return null;
        }
        if (first == 254 && second == 255) {
            return IContentDescription.BOM_UTF_16BE;
        }
        if (first == 255 && second == 254) {
            return IContentDescription.BOM_UTF_16LE;
        }
        int third = input.read() & 0xFF;
        if (third == -1) {
            return null;
        }
        if (first == 239 && second == 187 && third == 191) {
            return IContentDescription.BOM_UTF_8;
        }
        return null;
    }
}

