/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.Vector;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class MonitorMemoryBlockDialog
extends Dialog
implements ModifyListener {
    private static Vector history = new Vector();
    private Combo expressionInput;
    private Text lengthInput;
    private String expression;
    private String length;
    private boolean needLength = true;
    private static final String PREFIX = "MonitorMemoryBlockDialog.";
    private static final String ENTER_EXPRESSION = "MonitorMemoryBlockDialog.EnterExpressionToMonitor";
    private static final String MONITOR_MEMORY = "MonitorMemoryBlockDialog.MonitorMemory";
    private static final String NUMBER_OF_BYTES = "MonitorMemoryBlockDialog.NumberOfBytes";

    public MonitorMemoryBlockDialog(Shell parentShell, IMemoryBlockRetrieval memRetrieval) {
        super(parentShell);
        if (memRetrieval instanceof IExtendedMemoryBlockRetrieval) {
            this.needLength = false;
        }
        WorkbenchHelp.setHelp((Control)parentShell, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MonitorMemoryBlockDialog_context"));
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        GridData spec2 = new GridData();
        spec2.grabExcessVerticalSpace = true;
        spec2.grabExcessHorizontalSpace = true;
        spec2.horizontalAlignment = 4;
        spec2.verticalAlignment = 2;
        parent.setLayoutData((Object)spec2);
        Label textLabel = new Label(parent, 0);
        textLabel.setText(DebugUIMessages.getString(ENTER_EXPRESSION));
        GridData textLayout = new GridData();
        textLayout.widthHint = 280;
        textLabel.setLayoutData((Object)textLayout);
        this.expressionInput = new Combo(parent, 2048);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        spec.heightHint = 50;
        this.expressionInput.setLayoutData((Object)spec);
        String[] historyExpression = history.toArray(new String[history.size()]);
        int i = 0;
        while (i < historyExpression.length) {
            this.expressionInput.add(historyExpression[i]);
            ++i;
        }
        this.expressionInput.addModifyListener((ModifyListener)this);
        if (this.needLength) {
            Label lengthLabel = new Label(parent, 0);
            lengthLabel.setText(DebugUIMessages.getString(NUMBER_OF_BYTES));
            GridData lengthLayout = new GridData();
            lengthLayout.widthHint = 280;
            lengthLabel.setLayoutData((Object)lengthLayout);
            this.lengthInput = new Text(parent, 2048);
            GridData lengthSpec = new GridData();
            lengthSpec.grabExcessVerticalSpace = false;
            lengthSpec.grabExcessHorizontalSpace = true;
            lengthSpec.horizontalAlignment = 4;
            this.lengthInput.setLayoutData((Object)lengthSpec);
            this.lengthInput.addModifyListener((ModifyListener)this);
        }
        return parent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DebugUIMessages.getString(MONITOR_MEMORY));
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLength() {
        return this.length;
    }

    protected void okPressed() {
        this.expression = this.expressionInput.getText();
        if (!history.contains(this.expression)) {
            history.insertElementAt(this.expression, 0);
        }
        if (this.needLength) {
            this.length = this.lengthInput.getText();
        }
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        if (this.needLength) {
            String lengthText = this.lengthInput.getText();
            String input = this.expressionInput.getText();
            if (input == null || input.equals("") || lengthText == null || lengthText.equals("")) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        } else {
            String input = this.expressionInput.getText();
            if (input == null || input.equals("")) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control ret = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return ret;
    }
}

