/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;

public class AddAction
extends WorkspaceAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (!this.promptForAddOfIgnored()) {
            return;
        }
        new AddOperation(this.getTargetPart(), this.getSelectedResources()).run();
    }

    private boolean promptForAddOfIgnored() {
        IResource[] resources = this.getSelectedResources();
        boolean prompt = false;
        int i = 0;
        while (i < resources.length) {
            ICVSResource resource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]);
            try {
                if (resource.isIgnored()) {
                    prompt = true;
                    break;
                }
            }
            catch (CVSException e) {
                this.handle((Exception)((Object)e));
            }
            ++i;
        }
        if (prompt) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("AddAction.addIgnoredTitle"), (String)Policy.bind("AddAction.addIgnoredQuestion"));
        }
        return true;
    }

    protected boolean isEnabledForManagedResources() {
        return false;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabledForIgnoredResources() {
        return true;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        IResource resource = cvsResource.getIResource();
        if (resource.isLinked()) {
            return false;
        }
        return super.isEnabledForCVSResource(cvsResource);
    }
}

