/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutToRemoteFolderOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;

public class ReconcileProjectOperation
extends ShareProjectOperation {
    private ICVSRemoteFolder folder;
    private SyncInfoFilter.ContentComparisonSyncInfoFilter contentCompare = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);
    private CVSWorkspaceSubscriber subscriber = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();

    public ReconcileProjectOperation(Shell shell, IProject project, ICVSRemoteFolder folder) {
        super(shell, folder.getRepository(), project, folder.getRepositoryRelativePath());
        this.folder = folder;
    }

    protected String getTaskName() {
        return Policy.bind("ReconcileProjectOperation.0", this.getProject().getName(), this.folder.getRepositoryRelativePath());
    }

    protected ICVSRemoteFolder createRemoteFolder(IProgressMonitor monitor) throws CVSException {
        return this.folder;
    }

    protected void mapProjectToRemoteFolder(ICVSRemoteFolder remote, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100);
        super.mapProjectToRemoteFolder(remote, Policy.subMonitorFor(monitor, 10));
        this.reconcileSyncInfo(Policy.subMonitorFor(monitor, 90));
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reconcileSyncInfo(IProgressMonitor monitor) throws CVSException {
        try {
            try {
                monitor.beginTask(null, 100);
                ICVSRemoteFolder remote = CheckoutToRemoteFolderOperation.checkoutRemoteFolder(this.getPart(), this.folder, Policy.subMonitorFor(monitor, 80));
                this.populateWorkspace(remote, Policy.subMonitorFor(monitor, 20));
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        monitor.done();
    }

    private void populateWorkspace(final ICVSRemoteFolder remote, IProgressMonitor monitor) throws CVSException {
        CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.getProject()).run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                ReconcileProjectOperation.this.populateWorkspace((IResource)ReconcileProjectOperation.this.getProject(), (ICVSRemoteResource)remote, monitor);
            }
        }, monitor);
    }

    void populateWorkspace(IResource resource, ICVSRemoteResource remote, IProgressMonitor monitor) throws CVSException {
        try {
            if (resource.getType() == 1) {
                if (remote.isContainer()) {
                    CVSUIPlugin.log(4, Policy.bind("ReconcileProjectOperation.1", resource.getFullPath().toString(), remote.getRepositoryRelativePath()), null);
                } else {
                    IFile file = (IFile)resource;
                    IResourceVariant variant = (IResourceVariant)remote;
                    if (file.exists() && variant != null && this.contentCompare.compareContents(file, variant, monitor)) {
                        this.makeInSync(file, remote, monitor);
                    }
                }
            } else if (!remote.isContainer()) {
                CVSUIPlugin.log(4, Policy.bind("ReconcileProjectOperation.2", resource.getFullPath().toString(), remote.getRepositoryRelativePath()), null);
            } else {
                ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                folder.setFolderSyncInfo(((ICVSFolder)remote).getFolderSyncInfo());
                ICVSRemoteResource[] members = remote.members(monitor);
                int i = 0;
                while (i < members.length) {
                    ICVSRemoteResource member = members[i];
                    this.populateWorkspace(this.getLocalChild((IContainer)resource, member), member, monitor);
                    ++i;
                }
            }
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
    }

    private IResource getLocalChild(IContainer parent, ICVSRemoteResource member) {
        Object resource = parent.findMember(member.getName());
        if (resource == null) {
            resource = member.isContainer() ? parent.getFolder((IPath)new Path(member.getName())) : parent.getFile((IPath)new Path(member.getName()));
        }
        return resource;
    }

    private void makeInSync(IFile file, ICVSRemoteResource remote, IProgressMonitor monitor) throws CVSException {
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
        ResourceSyncInfo info = remote.getSyncInfo();
        Date modTime = info.getTimeStamp();
        if (modTime != null) {
            cvsFile.setTimeStamp(modTime);
        }
        modTime = cvsFile.getTimeStamp();
        MutableResourceSyncInfo newInfoWithTimestamp = info.cloneMutable();
        newInfoWithTimestamp.setTimeStamp(modTime);
        cvsFile.setSyncInfo((ResourceSyncInfo)newInfoWithTimestamp, 1);
    }
}

