/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceSynchronizeParticipant;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ccvs.ui.wizards.SharingWizardPageActionGroup;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ParticipantPageSaveablePart;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.PageBook;

public class SharingWizardSyncPage
extends CVSWizardPage
implements ISyncInfoSetChangeListener {
    private static final String PAGE_HEIGHT = "SyncPageHeight";
    private static final String PAGE_WIDTH = "SyncPageWidth";
    private ParticipantPageSaveablePart input;
    private ISynchronizePageConfiguration configuration;
    private SyncInfoSet infos;
    private IProject project;
    PageBook pageBook;
    private Control syncPage;
    private Control noChangesPage;
    private Control errorPage;
    private int width;
    private int height;
    private SharingWizardPageActionGroup sharingWizardPageActionGroup;

    public SharingWizardSyncPage(String pageName, String title, ImageDescriptor titleImage, String description) {
        super(pageName, title, titleImage, description);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.sharing_sync_page_context");
        this.pageBook = new PageBook(composite, 0);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.pageBook.setLayoutData((Object)data);
        this.input = this.createCompareInput();
        this.input.createPartControl((Composite)this.pageBook);
        this.syncPage = this.input.getControl();
        this.infos = this.configuration.getSyncInfoSet();
        this.infos.addSyncSetChangedListener((ISyncInfoSetChangeListener)this);
        this.noChangesPage = this.createNoChangesPage(this.pageBook);
        this.noChangesPage.setLayoutData((Object)new GridData(1808));
        this.errorPage = this.createErrorPage(this.pageBook);
        this.errorPage.setLayoutData((Object)new GridData(1808));
        this.updatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    private Control createNoChangesPage(PageBook pageBook) {
        Composite composite = this.createComposite((Composite)pageBook, 1);
        this.createWrappingLabel(composite, Policy.bind("SharingWizardSyncPage.3", this.project.getName()), 0);
        return composite;
    }

    private Control createErrorPage(PageBook pageBook) {
        Composite composite = new Composite((Composite)pageBook, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createWrappingLabel(composite, Policy.bind("SharingWizardSyncPage.4"), 0);
        Button showErrors = new Button(composite, 8);
        showErrors.setText(Policy.bind("SharingWizardSyncPage.5"));
        GridData data = new GridData(128);
        showErrors.setLayoutData((Object)data);
        showErrors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SharingWizardSyncPage.this.showErrors();
            }
        });
        return composite;
    }

    void showErrors() {
        ITeamStatus[] status = this.infos.getErrors();
        String title = Policy.bind("SharingWizardSyncPage.8");
        if (status.length == 1) {
            ITeamStatus s = status[0];
            if (s.getException() instanceof CoreException) {
                s = ((CoreException)s.getException()).getStatus();
            }
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)s);
        } else {
            MultiStatus multi = new MultiStatus("org.eclipse.team.cvs.ui", 0, (IStatus[])status, Policy.bind("SharingWizardSyncPage.9"), null);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)multi);
        }
    }

    private ParticipantPageSaveablePart createCompareInput() {
        WorkspaceSynchronizeParticipant participant = new WorkspaceSynchronizeParticipant((ISynchronizeScope)new ResourceScope(new IResource[]{this.project}));
        this.configuration = participant.createPageConfiguration();
        this.configuration.setProperty("org.eclipse.team.ui.P_TOOLBAR_MENU", (Object)new String[]{"layout", "cvs_sharing_page_actions"});
        this.sharingWizardPageActionGroup = new SharingWizardPageActionGroup();
        this.configuration.addActionContribution((SynchronizePageActionGroup)this.sharingWizardPageActionGroup);
        this.configuration.setRunnableContext((IRunnableContext)this.getContainer());
        CompareConfiguration cc = new CompareConfiguration();
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        ParticipantPageSaveablePart part = new ParticipantPageSaveablePart(this.getShell(), cc, this.configuration, (ISynchronizeParticipant)participant);
        return part;
    }

    public void dispose() {
        if (this.input != null) {
            this.input.getParticipant().dispose();
            this.input.dispose();
        }
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(null);
    }

    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        this.updatePage();
    }

    public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        this.updatePage();
    }

    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        this.updatePage();
    }

    private void updatePage() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (SharingWizardSyncPage.this.pageBook.isDisposed()) {
                    return;
                }
                if (SharingWizardSyncPage.this.infos.getErrors().length > 0) {
                    SharingWizardSyncPage.this.pageBook.showPage(SharingWizardSyncPage.this.errorPage);
                } else if (SharingWizardSyncPage.this.infos.isEmpty()) {
                    SharingWizardSyncPage.this.pageBook.showPage(SharingWizardSyncPage.this.noChangesPage);
                } else {
                    SharingWizardSyncPage.this.pageBook.showPage(SharingWizardSyncPage.this.syncPage);
                }
            }
        });
    }

    public void showError(TeamStatus status) {
        this.infos.addError((ITeamStatus)status);
    }

    public WorkspaceSynchronizeParticipant getParticipant() {
        return (WorkspaceSynchronizeParticipant)this.configuration.getParticipant();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.syncPage.isVisible()) {
            this.initializeSize();
            this.getShell().setSize(Math.max(this.width, 300), Math.max(this.height, 300));
        }
    }

    private void initializeSize() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            try {
                this.width = settings.getInt(PAGE_WIDTH);
                this.height = settings.getInt(PAGE_HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.width == 0) {
            this.width = 640;
        }
        if (this.height == 0) {
            this.height = 480;
        }
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            Point size = this.getShell().getSize();
            settings.put(PAGE_WIDTH, size.x);
            settings.put(PAGE_HEIGHT, size.y);
        }
    }

    public void promptToCommit() {
        if (this.sharingWizardPageActionGroup != null && this.sharingWizardPageActionGroup.getCommitAction().isEnabled() && MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("SharingWizardSyncPage.10"), (String)Policy.bind("SharingWizardSyncPage.11"))) {
            this.configuration.setRunnableContext(null);
            this.sharingWizardPageActionGroup.getCommitAction().run();
        }
    }
}

