/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GenericSignature {
    private static final char C_BOOLEAN = 'Z';
    private static final char C_BYTE = 'B';
    private static final char C_CHAR = 'C';
    private static final char C_SHORT = 'S';
    private static final char C_DOUBLE = 'D';
    private static final char C_FLOAT = 'F';
    private static final char C_INT = 'I';
    private static final char C_LONG = 'J';
    private static final char C_CLASS_TYPE = 'L';
    private static final char C_TYPE_VARIABLE = 'T';
    private static final char C_ARRAY = '[';
    private static final char C_VOID = 'V';
    private static final char C_WILDCARD_PLUS = '+';
    private static final char C_WILDCARD_MINUS = '-';
    private static final char C_TYPE_END = ';';
    private static final char C_PARAMETERS_START = '(';
    private static final char C_PARAMETERS_END = ')';
    private static final char C_EXCEPTION_START = '^';
    private static final char C_TYPE_ARGUMENTS_START = '<';
    private static final char C_TYPE_ARGUMENTS_END = '>';
    private static final char C_TYPE_PARAMETERS_START = '<';
    private static final char C_TYPE_PARAMETERS_END = '>';
    private static final char C_TYPE_PARAMETERS_COLON = ':';

    public static String getReturnType(String methodSignature) {
        int parametersEnd = methodSignature.lastIndexOf(41);
        if (parametersEnd == -1) {
            throw new IllegalArgumentException();
        }
        int exceptionStart = methodSignature.indexOf(94, parametersEnd + 1);
        if (exceptionStart == -1) {
            return methodSignature.substring(parametersEnd + 1);
        }
        return methodSignature.substring(parametersEnd + 1, exceptionStart);
    }

    public static List getArgumentsSignature(String methodSignature) {
        int parameterStart = methodSignature.indexOf(40);
        int parametersEnd = methodSignature.lastIndexOf(41);
        if (parameterStart == -1 || parametersEnd == -1) {
            throw new IllegalArgumentException();
        }
        return GenericSignature.getTypeSignatureList(methodSignature.substring(parameterStart + 1, parametersEnd));
    }

    public static List getTypeParameters(String genericClassSignature) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (genericClassSignature.charAt(0) == '<') {
            int pos = 1;
            while (genericClassSignature.charAt(pos) != '>') {
                int identEnd = genericClassSignature.indexOf(58, pos);
                parameters.add(genericClassSignature.substring(pos, identEnd));
                pos = identEnd + 1;
                if (genericClassSignature.charAt(pos) != ':') {
                    pos += GenericSignature.nextTypeSignatureLength(genericClassSignature, pos);
                }
                while (genericClassSignature.charAt(pos) == ':') {
                    pos = pos++ + GenericSignature.nextTypeSignatureLength(genericClassSignature, pos);
                }
            }
        }
        return parameters;
    }

    public static String signatureToName(String typeSignature) {
        String name = null;
        char char0 = typeSignature.charAt(0);
        int length = typeSignature.length();
        switch (char0) {
            case 'Z': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "boolean";
                break;
            }
            case 'B': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "byte";
                break;
            }
            case 'C': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "char";
                break;
            }
            case 'S': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "short";
                break;
            }
            case 'D': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "double";
                break;
            }
            case 'F': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "float";
                break;
            }
            case 'I': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "int";
                break;
            }
            case 'J': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "long";
                break;
            }
            case 'V': {
                GenericSignature.checkLength(typeSignature, 1);
                name = "void";
                break;
            }
            case '[': {
                name = String.valueOf(GenericSignature.signatureToName(typeSignature.substring(1))) + "[]";
                break;
            }
            case '+': {
                name = "? extends " + GenericSignature.signatureToName(typeSignature.substring(1));
                break;
            }
            case '-': {
                name = "? super " + GenericSignature.signatureToName(typeSignature.substring(1));
                break;
            }
            case 'L': {
                GenericSignature.checkChar(typeSignature, length - 1, ';');
                int argumentStart = typeSignature.indexOf(60, 1);
                if (argumentStart != -1) {
                    GenericSignature.checkChar(typeSignature, length - 2, '>');
                    name = String.valueOf(typeSignature.substring(1, argumentStart).replace('/', '.')) + '<' + GenericSignature.nameListToString(GenericSignature.listSignaturetoListName(GenericSignature.getTypeSignatureList(typeSignature.substring(argumentStart + 1, length - 2)))) + '>';
                    break;
                }
                name = typeSignature.substring(1, length - 1).replace('/', '.');
                break;
            }
            case 'T': {
                GenericSignature.checkChar(typeSignature, length - 1, ';');
                name = typeSignature.substring(1, length - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return name;
    }

    public static String nameListToString(List names) {
        StringBuffer string = new StringBuffer();
        Iterator iterator = names.iterator();
        if (iterator.hasNext()) {
            string.append(iterator.next());
            while (iterator.hasNext()) {
                string.append(',').append(iterator.next());
            }
        }
        return string.toString();
    }

    public static List listSignaturetoListName(List signatures) {
        ArrayList<String> names = new ArrayList<String>(signatures.size());
        Iterator iterator = signatures.iterator();
        while (iterator.hasNext()) {
            names.add(GenericSignature.signatureToName((String)iterator.next()));
        }
        return names;
    }

    private static List getTypeSignatureList(String typeSignatureList) {
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < typeSignatureList.length()) {
            int signatureLength = GenericSignature.nextTypeSignatureLength(typeSignatureList, pos);
            list.add(typeSignatureList.substring(pos, pos += signatureLength));
        }
        return list;
    }

    private static int nextTypeSignatureLength(String signature, int startPos) {
        int inclusionLevel = 0;
        int i = startPos;
        int length = signature.length();
        while (i < length) {
            block11: {
                block10: {
                    if (inclusionLevel != 0) break block10;
                    switch (signature.charAt(i)) {
                        case '+': 
                        case '-': 
                        case 'L': 
                        case 'T': {
                            inclusionLevel = 1;
                            break block11;
                        }
                        case '[': {
                            break block11;
                        }
                        default: {
                            return i - startPos + 1;
                        }
                    }
                }
                switch (signature.charAt(i)) {
                    case ';': {
                        if (inclusionLevel != 1) break;
                        return i - startPos + 1;
                    }
                    case '<': {
                        ++inclusionLevel;
                        break;
                    }
                    case '>': {
                        --inclusionLevel;
                    }
                }
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    private static void checkChar(String string, int index, char character) {
        if (string.charAt(index) != character) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkLength(String string, int length) {
        if (string.length() != length) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isClassSignature(String signature) {
        return signature.charAt(0) == 'L';
    }

    public static boolean isArraySignature(String signature) {
        return signature.charAt(0) == '[';
    }

    public static boolean isPrimitiveSignature(String signature) {
        switch (signature.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    public static boolean isVoidSignature(String signature) {
        return signature.charAt(0) == 'V';
    }
}

