/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.ConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketListeningConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketTransportImpl;

public class SocketRawLaunchingConnectorImpl
extends ConnectorImpl
implements LaunchingConnector {
    private static final int ACCEPT_TIMEOUT = 10000;
    private String fCommand;
    private String fAddress;

    public SocketRawLaunchingConnectorImpl(VirtualMachineManagerImpl virtualMachineManager) {
        super(virtualMachineManager);
        SocketTransportImpl transport = new SocketTransportImpl();
        this.setTransport(transport);
    }

    public Map defaultArguments() {
        HashMap<String, ConnectorImpl.StringArgumentImpl> arguments = new HashMap<String, ConnectorImpl.StringArgumentImpl>(3);
        ConnectorImpl.StringArgumentImpl strArg = new ConnectorImpl.StringArgumentImpl("command", ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Raw_command_to_start_the_debugged_application_VM_1"), ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Command_2"), true);
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl("address", ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Address_from_which_to_listen_for_a_connection_after_the_raw_command_is_run_3"), ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Address_4"), true);
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl("quote", ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Character_used_to_combine_space-delimited_text_into_a_single_command_line_argument_5"), ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Quote_6"), true);
        strArg.setValue("\"");
        arguments.put(strArg.name(), strArg);
        return arguments;
    }

    public String name() {
        return "com.sun.jdi.RawCommandLineLaunch";
    }

    public String description() {
        return ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Launches_target_using_user-specified_command_line_and_attaches_to_it_7");
    }

    private void getConnectionArguments(Map connectionArgs) throws IllegalConnectorArgumentsException {
        String attribute = "";
        try {
            attribute = "command";
            this.fCommand = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "address";
            this.fAddress = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "quote";
            ((Connector.StringArgument)connectionArgs.get(attribute)).value();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Connection_argument_is_not_of_the_right_type_8"), attribute);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Necessary_connection_argument_is_null_9"), attribute);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketRawLaunchingConnectorImpl.Connection_argument_is_not_a_number_10"), attribute);
        }
    }

    public VirtualMachine launch(Map connectionArgs) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        VirtualMachineImpl virtualMachine;
        this.getConnectionArguments(connectionArgs);
        SocketListeningConnectorImpl listenConnector = new SocketListeningConnectorImpl(this.virtualMachineManager());
        Map args = listenConnector.defaultArguments();
        ((Connector.IntegerArgument)args.get("port")).setValue(this.fAddress);
        ((Connector.IntegerArgument)args.get("timeout")).setValue(10000);
        listenConnector.startListening(args);
        Process proc = Runtime.getRuntime().exec(this.fCommand);
        try {
            virtualMachine = (VirtualMachineImpl)listenConnector.accept(args);
        }
        catch (InterruptedIOException interruptedIOException) {
            proc.destroy();
            String message = MessageFormat.format(ConnectMessages.getString("SocketLaunchingConnectorImpl.VM_did_not_connect_within_given_time__{0}_ms_1"), ((Connector.IntegerArgument)args.get("timeout")).value());
            throw new VMStartException(message, proc);
        }
        virtualMachine.setLauncedProcess(proc);
        return virtualMachine;
    }
}

