/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Vector;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class IntroHomePage
extends AbstractIntroPage {
    private static final String ATT_URL = "url";
    private String url;
    private boolean isDynamic = false;
    private boolean isStandbyPage;

    IntroHomePage(Element element, Bundle bundle) {
        super(element, bundle);
        this.url = this.getAttribute(element, ATT_URL);
        if (this.url == null) {
            this.isDynamic = true;
        } else {
            this.url = IntroModelRoot.resolveURL(this.url, bundle);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public int getType() {
        return 4;
    }

    public boolean isStandbyPage() {
        return this.isStandbyPage;
    }

    public void setStandbyPage(boolean isStandbyPage) {
        this.isStandbyPage = isStandbyPage;
    }

    public IntroLink[] getLinks() {
        Vector<AbstractIntroElement> linkVector = new Vector<AbstractIntroElement>();
        AbstractIntroElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            AbstractIntroElement child = children[i];
            if (child.isOfType(64)) {
                linkVector.add(child);
            } else if (child.isOfType(16)) {
                this.addLinks((IntroGroup)child, linkVector);
            }
            ++i;
        }
        Object[] links = new IntroLink[linkVector.size()];
        linkVector.copyInto(links);
        return links;
    }

    private void addLinks(IntroGroup group, Vector linkVector) {
        AbstractIntroElement[] children = group.getChildren();
        int i = 0;
        while (i < children.length) {
            AbstractIntroElement child = children[i];
            if (child.isOfType(64)) {
                linkVector.add(child);
            } else if (child.isOfType(16)) {
                this.addLinks((IntroGroup)child, linkVector);
            }
            ++i;
        }
    }
}

