/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.team.core.DefaultRepositoryProviderType;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.core.DefaultProjectSetCapability;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;

public abstract class RepositoryProviderType {
    private static Map allProviderTypes = new HashMap();
    private String id;

    public static RepositoryProviderType getProviderType(String id) {
        RepositoryProviderType type = (RepositoryProviderType)allProviderTypes.get(id);
        if (type != null) {
            return type;
        }
        return RepositoryProviderType.newProviderType(id);
    }

    private void setID(String id) {
        this.id = id;
    }

    private static RepositoryProviderType newProviderType(String id) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("repository")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String extensionId = configElements[j].getAttribute("id");
                    if (extensionId != null && extensionId.equals(id)) {
                        try {
                            RepositoryProviderType providerType = configElements[j].getAttribute("typeClass") == null ? new DefaultRepositoryProviderType() : (RepositoryProviderType)configElements[j].createExecutableExtension("typeClass");
                            super.setID(id);
                            allProviderTypes.put(id, providerType);
                            return providerType;
                        }
                        catch (CoreException e) {
                            TeamPlugin.log(e);
                        }
                        catch (ClassCastException e) {
                            String className = configElements[j].getAttribute("typeClass");
                            TeamPlugin.log(4, Policy.bind("RepositoryProviderType.invalidClass", id, className), e);
                        }
                        return null;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public final String getID() {
        return this.id;
    }

    public ProjectSetCapability getProjectSetCapability() {
        IProjectSetSerializer oldSerializer = Team.getProjectSetSerializer(this.getID());
        if (oldSerializer != null) {
            DefaultProjectSetCapability capability = new DefaultProjectSetCapability();
            capability.setSerializer(oldSerializer);
            return capability;
        }
        return null;
    }
}

