/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DialogSettingsHelper;
import org.eclipse.jdt.internal.debug.ui.Filter;
import org.eclipse.jdt.internal.debug.ui.StatusDialog;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateStepFilterDialog
extends StatusDialog {
    private static final String DEFAULT_NEW_FILTER_TEXT = "";
    private Text text;
    private Filter filter;
    private Button okButton;
    private boolean filterValid;
    private boolean okClicked;
    private Filter[] existingFilters;

    private CreateStepFilterDialog(Shell parent, Filter filter, Filter[] existingFilters) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.filter = filter;
        this.existingFilters = existingFilters;
        this.setTitle(DebugUIMessages.getString("CreateStepFilterDialog.2"));
        this.setStatusLineAboveButtons(false);
    }

    static Filter showCreateStepFilterDialog(Shell parent, Filter[] existingFilters) {
        CreateStepFilterDialog createStepFilterDialog = new CreateStepFilterDialog(parent, new Filter(DEFAULT_NEW_FILTER_TEXT, true), existingFilters);
        createStepFilterDialog.create();
        createStepFilterDialog.open();
        return createStepFilterDialog.filter;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        container.setLayout((Layout)gridLayout);
        int textStyles = 16388;
        Label label = new Label(container, textStyles);
        label.setText(DebugUIMessages.getString("CreateStepFilterDialog.3"));
        label.setFont(container.getFont());
        if (!SWT.getPlatform().equals("motif")) {
            textStyles |= 0x800;
        }
        this.text = new Text(container, textStyles);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 300;
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(container.getFont());
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateStepFilterDialog.this.validateChange();
                if (!CreateStepFilterDialog.this.filterValid) {
                    CreateStepFilterDialog.this.updateStatus(new StatusInfo(4, DebugUIMessages.getString("CreateStepFilterDialog.4")));
                } else {
                    if (CreateStepFilterDialog.this.isDuplicateFilter(CreateStepFilterDialog.this.text.getText().trim())) {
                        CreateStepFilterDialog.this.updateStatus(new StatusInfo(2, DebugUIMessages.getString("CreateStepFilterDialog.5")));
                        return;
                    }
                    CreateStepFilterDialog.this.updateStatus(new StatusInfo());
                }
            }
        });
        return container;
    }

    private void validateChange() {
        String trimmedValue = this.text.getText().trim();
        if (trimmedValue.length() > 0 && this.validateInput(trimmedValue)) {
            this.okButton.setEnabled(true);
            this.filter.setName(this.text.getText());
            this.filterValid = true;
        } else {
            this.okButton.setEnabled(false);
            this.filter.setName(DEFAULT_NEW_FILTER_TEXT);
            this.filterValid = false;
        }
    }

    private boolean isDuplicateFilter(String trimmedValue) {
        int i = 0;
        while (i < this.existingFilters.length) {
            if (this.existingFilters[i].getName().equals(trimmedValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean validateInput(String trimmedValue) {
        char firstChar = trimmedValue.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar) && firstChar != '*') {
            return false;
        }
        int length = trimmedValue.length();
        int i = 1;
        while (i < length) {
            char c = trimmedValue.charAt(i);
            if (!(Character.isJavaIdentifierPart(c) || c == '.' && i != length - 1 || c == '*' && i == length - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String getDialogSettingsSectionName() {
        return String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".CREATE_STEP_FILTER_DIALOG_SECTION";
    }

    protected Point getInitialLocation(Point initialSize) {
        Point initialLocation = DialogSettingsHelper.getInitialLocation(this.getDialogSettingsSectionName());
        if (initialLocation != null) {
            return initialLocation;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        return DialogSettingsHelper.getInitialSize(this.getDialogSettingsSectionName(), size);
    }

    public boolean close() {
        if (!this.okClicked) {
            this.filterValid = false;
            this.filter = null;
        }
        DialogSettingsHelper.persistShellGeometry(this.getShell(), this.getDialogSettingsSectionName());
        return super.close();
    }

    protected void okPressed() {
        this.okClicked = true;
        super.okPressed();
    }
}

