/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.RunToLineAdapter;
import org.eclipse.jdt.internal.debug.ui.actions.StepIntoSelectionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class StepIntoSelectionActionDelegate
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private IEditorPart fEditorPart = null;
    private IWorkbenchWindow fWindow = null;
    private String runToLineType = null;
    private int runToLineLine = -1;
    private IDebugEventSetListener listener = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void run(IAction action) {
        IJavaStackFrame frame = this.getStackFrame();
        if (frame == null || !frame.isSuspended()) {
            return;
        }
        ITextSelection textSelection = this.getTextSelection();
        IMethod method = this.getMethod();
        IType callingType = this.getType();
        if (method == null || callingType == null) {
            return;
        }
        try {
            int lineNumber = frame.getLineNumber();
            if (textSelection.getStartLine() != lineNumber - 1 || !callingType.getFullyQualifiedName().equals(frame.getReceivingTypeName())) {
                this.runToLineBeforeStepIn(textSelection, frame.getThread(), method);
                return;
            }
            this.doStepIn(frame, method);
        }
        catch (DebugException e) {
            this.showErrorMessage(e.getStatus().getMessage());
            return;
        }
    }

    private void doStepIn(IJavaStackFrame frame, IMethod method) throws DebugException {
        IStackFrame tos = frame.getThread().getTopStackFrame();
        if (tos == null) {
            return;
        }
        if (!tos.equals(frame)) {
            this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.Step_into_selection_only_available_in_top_stack_frame._3"));
            return;
        }
        StepIntoSelectionHandler handler = new StepIntoSelectionHandler((IJavaThread)frame.getThread(), frame, method);
        handler.step();
    }

    private void runToLineBeforeStepIn(ITextSelection textSelection, final IThread thread, final IMethod method) {
        this.runToLineType = this.getType().getFullyQualifiedName();
        this.runToLineLine = textSelection.getStartLine() + 1;
        if (this.runToLineType == null || this.runToLineLine == -1) {
            return;
        }
        RunToLineAdapter runToLineAction = null;
        IEditorPart ed = this.getActiveEditor();
        if (ed != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runToLineAction = (IRunToLineTarget)ed.getAdapter((Class)clazz)) == null) {
                IAdapterManager adapterManager = Platform.getAdapterManager();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterManager.hasAdapter((Object)ed, clazz2.getName())) {
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    runToLineAction = (IRunToLineTarget)adapterManager.loadAdapter((Object)ed, clazz3.getName());
                }
            }
        }
        if (runToLineAction == null) {
            runToLineAction = new RunToLineAdapter();
        }
        this.listener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    switch (event.getKind()) {
                        case 2: {
                            this.handleSuspendEvent(event);
                            break;
                        }
                        case 8: {
                            this.handleTerminateEvent(event);
                            break;
                        }
                    }
                    ++i;
                }
            }

            private void handleSuspendEvent(DebugEvent event) {
                Object source = event.getSource();
                if (source instanceof IJavaThread) {
                    try {
                        IJavaStackFrame frame = (IJavaStackFrame)((IJavaThread)source).getTopStackFrame();
                        if (this.isExpectedFrame(frame)) {
                            DebugPlugin plugin = DebugPlugin.getDefault();
                            plugin.removeDebugEventListener(StepIntoSelectionActionDelegate.this.listener);
                            plugin.asyncExec(new Runnable(this, frame, method){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IJavaStackFrame val$frame;
                                private final /* synthetic */ IMethod val$method;
                                {
                                    this.this$1 = var1_1;
                                    this.val$frame = iJavaStackFrame;
                                    this.val$method = iMethod;
                                }

                                public void run() {
                                    try {
                                        StepIntoSelectionActionDelegate.access$1(1.access$0(this.this$1), this.val$frame, this.val$method);
                                    }
                                    catch (DebugException e) {
                                        1.access$0(this.this$1).showErrorMessage(e.getStatus().getMessage());
                                    }
                                }
                            });
                        }
                    }
                    catch (DebugException debugException) {
                        return;
                    }
                }
            }

            private boolean isExpectedFrame(IJavaStackFrame frame) throws DebugException {
                return frame != null && StepIntoSelectionActionDelegate.this.runToLineLine == frame.getLineNumber() && frame.getReceivingTypeName().equals(StepIntoSelectionActionDelegate.this.runToLineType);
            }

            private void handleTerminateEvent(DebugEvent event) {
                Object source = event.getSource();
                if (thread.getDebugTarget() == source) {
                    DebugPlugin.getDefault().removeDebugEventListener(StepIntoSelectionActionDelegate.this.listener);
                }
            }

            static /* synthetic */ StepIntoSelectionActionDelegate access$0(1 var0) {
                return var0.StepIntoSelectionActionDelegate.this;
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.listener);
        try {
            runToLineAction.runToLine((IWorkbenchPart)this.getActiveEditor(), (ISelection)textSelection, (ISuspendResume)thread);
        }
        catch (CoreException e) {
            DebugPlugin.getDefault().removeDebugEventListener(this.listener);
            this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.4"));
            JDIDebugUIPlugin.log(e.getStatus());
        }
    }

    private ITextSelection getTextSelection() {
        IEditorPart part = this.getActiveEditor();
        if (part instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)part;
            return (ITextSelection)editor.getSelectionProvider().getSelection();
        }
        this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.Step_into_selection_only_available_in_Java_editor._4"));
        return null;
    }

    private IMethod getMethod() {
        ITextSelection textSelection = this.getTextSelection();
        IEditorInput input = this.getActiveEditor().getEditorInput();
        ICodeAssist codeAssist = null;
        Object element = JavaUI.getWorkingCopyManager().getWorkingCopy(input);
        if (element == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.IClassFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            element = input.getAdapter((Class)clazz);
        }
        if (!(element instanceof ICodeAssist)) {
            this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.Step_into_selection_only_available_for_types_in_Java_projects._1"));
            return null;
        }
        codeAssist = (ICodeAssist)element;
        IMethod method = null;
        try {
            IJavaElement[] resolve = codeAssist.codeSelect(textSelection.getOffset(), 0);
            int i = 0;
            while (i < resolve.length) {
                IJavaElement javaElement = resolve[i];
                if (javaElement instanceof IMethod) {
                    method = (IMethod)javaElement;
                    break;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugPlugin.log((Throwable)e);
        }
        if (method == null) {
            this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.No_Method"));
        }
        return method;
    }

    protected IType getType() {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(this.getTextSelection());
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        return type;
    }

    protected void showErrorMessage(String message) {
        if (this.getActiveEditor() != null) {
            IEditorStatusLine statusLine;
            IEditorPart iEditorPart = this.getActiveEditor();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((statusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz)) != null) {
                statusLine.setMessage(true, message, null);
            }
        }
        JDIDebugUIPlugin.getStandardDisplay().beep();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditorPart = targetEditor;
    }

    protected IEditorPart getActiveEditor() {
        if (this.fWindow != null) {
            return this.fWindow.getActivePage().getActiveEditor();
        }
        return this.fEditorPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IJavaStackFrame getStackFrame() {
        return EvaluationContextManager.getEvaluationContext((IWorkbenchPart)this.getActiveEditor());
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    static /* synthetic */ void access$1(StepIntoSelectionActionDelegate stepIntoSelectionActionDelegate, IJavaStackFrame iJavaStackFrame, IMethod iMethod) {
        stepIntoSelectionActionDelegate.doStepIn(iJavaStackFrame, iMethod);
    }
}

